/*
 * Decompiled with CFR 0.152.
 */
package org.apache.opendal;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.opendal.AsyncExecutor;
import org.apache.opendal.Entry;
import org.apache.opendal.Layer;
import org.apache.opendal.Metadata;
import org.apache.opendal.NativeObject;
import org.apache.opendal.Operator;
import org.apache.opendal.OperatorInfo;
import org.apache.opendal.PresignedRequest;

public class AsyncOperator
extends NativeObject {
    public final OperatorInfo info;
    private final long executorHandle;

    public static AsyncOperator of(String schema, Map<String, String> map) {
        return AsyncOperator.of(schema, map, null);
    }

    public static AsyncOperator of(String schema, Map<String, String> map, AsyncExecutor executor) {
        long executorHandle = executor != null ? executor.nativeHandle : 0L;
        long nativeHandle = AsyncOperator.constructor(executorHandle, schema, map);
        OperatorInfo info = AsyncOperator.makeOperatorInfo(nativeHandle);
        return new AsyncOperator(nativeHandle, executorHandle, info);
    }

    private AsyncOperator(long nativeHandle, long executorHandle, OperatorInfo info) {
        super(nativeHandle);
        this.info = info;
        this.executorHandle = executorHandle;
    }

    public AsyncOperator duplicate() {
        long nativeHandle = AsyncOperator.duplicate(this.nativeHandle);
        return new AsyncOperator(nativeHandle, this.executorHandle, this.info);
    }

    public AsyncOperator layer(Layer layer) {
        long nativeHandle = layer.layer(this.nativeHandle);
        return new AsyncOperator(nativeHandle, this.executorHandle, AsyncOperator.makeOperatorInfo(nativeHandle));
    }

    public Operator blocking() {
        long nativeHandle = AsyncOperator.makeBlockingOp(this.nativeHandle);
        OperatorInfo info = this.info;
        return new Operator(nativeHandle, info);
    }

    public CompletableFuture<Void> write(String path, String content) {
        return this.write(path, content.getBytes(StandardCharsets.UTF_8));
    }

    public CompletableFuture<Void> write(String path, byte[] content) {
        long requestId = AsyncOperator.write(this.nativeHandle, this.executorHandle, path, content);
        return AsyncRegistry.take(requestId);
    }

    public CompletableFuture<Void> append(String path, String content) {
        return this.append(path, content.getBytes(StandardCharsets.UTF_8));
    }

    public CompletableFuture<Void> append(String path, byte[] content) {
        long requestId = AsyncOperator.append(this.nativeHandle, this.executorHandle, path, content);
        return AsyncRegistry.take(requestId);
    }

    public CompletableFuture<Metadata> stat(String path) {
        long requestId = AsyncOperator.stat(this.nativeHandle, this.executorHandle, path);
        return AsyncRegistry.take(requestId);
    }

    public CompletableFuture<byte[]> read(String path) {
        long requestId = AsyncOperator.read(this.nativeHandle, this.executorHandle, path);
        return AsyncRegistry.take(requestId);
    }

    public CompletableFuture<PresignedRequest> presignRead(String path, Duration duration) {
        long requestId = AsyncOperator.presignRead(this.nativeHandle, this.executorHandle, path, duration.toNanos());
        return AsyncRegistry.take(requestId);
    }

    public CompletableFuture<PresignedRequest> presignWrite(String path, Duration duration) {
        long requestId = AsyncOperator.presignWrite(this.nativeHandle, this.executorHandle, path, duration.toNanos());
        return AsyncRegistry.take(requestId);
    }

    public CompletableFuture<PresignedRequest> presignStat(String path, Duration duration) {
        long requestId = AsyncOperator.presignStat(this.nativeHandle, this.executorHandle, path, duration.toNanos());
        return AsyncRegistry.take(requestId);
    }

    public CompletableFuture<Void> delete(String path) {
        long requestId = AsyncOperator.delete(this.nativeHandle, this.executorHandle, path);
        return AsyncRegistry.take(requestId);
    }

    public CompletableFuture<Void> createDir(String path) {
        long requestId = AsyncOperator.createDir(this.nativeHandle, this.executorHandle, path);
        return AsyncRegistry.take(requestId);
    }

    public CompletableFuture<Void> copy(String sourcePath, String targetPath) {
        long requestId = AsyncOperator.copy(this.nativeHandle, this.executorHandle, sourcePath, targetPath);
        return AsyncRegistry.take(requestId);
    }

    public CompletableFuture<Void> rename(String sourcePath, String targetPath) {
        long requestId = AsyncOperator.rename(this.nativeHandle, this.executorHandle, sourcePath, targetPath);
        return AsyncRegistry.take(requestId);
    }

    public CompletableFuture<Void> removeAll(String path) {
        long requestId = AsyncOperator.removeAll(this.nativeHandle, this.executorHandle, path);
        return AsyncRegistry.take(requestId);
    }

    public CompletableFuture<List<Entry>> list(String path) {
        long requestId = AsyncOperator.list(this.nativeHandle, this.executorHandle, path);
        CompletableFuture result = AsyncRegistry.take(requestId);
        return Objects.requireNonNull(result).thenApplyAsync(Arrays::asList);
    }

    @Override
    protected native void disposeInternal(long var1);

    private static native long duplicate(long var0);

    private static native long constructor(long var0, String var2, Map<String, String> var3);

    private static native long read(long var0, long var2, String var4);

    private static native long write(long var0, long var2, String var4, byte[] var5);

    private static native long append(long var0, long var2, String var4, byte[] var5);

    private static native long delete(long var0, long var2, String var4);

    private static native long stat(long var0, long var2, String var4);

    private static native long presignRead(long var0, long var2, String var4, long var5);

    private static native long presignWrite(long var0, long var2, String var4, long var5);

    private static native long presignStat(long var0, long var2, String var4, long var5);

    private static native OperatorInfo makeOperatorInfo(long var0);

    private static native long makeBlockingOp(long var0);

    private static native long createDir(long var0, long var2, String var4);

    private static native long copy(long var0, long var2, String var4, String var5);

    private static native long rename(long var0, long var2, String var4, String var5);

    private static native long removeAll(long var0, long var2, String var4);

    private static native long list(long var0, long var2, String var4);

    private static enum AsyncRegistry {
        INSTANCE;

        private final Map<Long, CompletableFuture<?>> registry = new ConcurrentHashMap();

        private static long requestId() {
            long requestId;
            CompletableFuture prev;
            CompletableFuture f = new CompletableFuture();
            while ((prev = AsyncRegistry.INSTANCE.registry.putIfAbsent(requestId = Math.abs(UUID.randomUUID().getLeastSignificantBits()), f)) != null) {
            }
            return requestId;
        }

        private static CompletableFuture<?> get(long requestId) {
            return AsyncRegistry.INSTANCE.registry.get(requestId);
        }

        private static <T> CompletableFuture<T> take(long requestId) {
            CompletableFuture<?> f = AsyncRegistry.get(requestId);
            if (f != null) {
                f.whenComplete((r, e) -> AsyncRegistry.INSTANCE.registry.remove(requestId));
            }
            return f;
        }
    }
}

