/*
 * Decompiled with CFR 0.152.
 */
package org.apache.opendal;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.opendal.AsyncOperator;
import org.apache.opendal.Entry;
import org.apache.opendal.Metadata;
import org.apache.opendal.NativeObject;
import org.apache.opendal.OperatorInfo;
import org.apache.opendal.OperatorInputStream;
import org.apache.opendal.OperatorOutputStream;

public class Operator
extends NativeObject {
    public final OperatorInfo info;

    public static Operator of(String schema, Map<String, String> map) {
        try (AsyncOperator operator = AsyncOperator.of(schema, map);){
            Operator operator2 = operator.blocking();
            return operator2;
        }
    }

    Operator(long nativeHandle, OperatorInfo info) {
        super(nativeHandle);
        this.info = info;
    }

    public Operator duplicate() {
        long nativeHandle = Operator.duplicate(this.nativeHandle);
        return new Operator(nativeHandle, this.info);
    }

    public void write(String path, String content) {
        this.write(path, content.getBytes(StandardCharsets.UTF_8));
    }

    public void write(String path, byte[] content) {
        Operator.write(this.nativeHandle, path, content);
    }

    public OperatorOutputStream createOutputStream(String path) {
        return new OperatorOutputStream(this, path);
    }

    public byte[] read(String path) {
        return Operator.read(this.nativeHandle, path);
    }

    public OperatorInputStream createInputStream(String path) {
        return new OperatorInputStream(this, path);
    }

    public void delete(String path) {
        Operator.delete(this.nativeHandle, path);
    }

    public Metadata stat(String path) {
        return Operator.stat(this.nativeHandle, path);
    }

    public void createDir(String path) {
        Operator.createDir(this.nativeHandle, path);
    }

    public void copy(String sourcePath, String targetPath) {
        Operator.copy(this.nativeHandle, sourcePath, targetPath);
    }

    public void rename(String sourcePath, String targetPath) {
        Operator.rename(this.nativeHandle, sourcePath, targetPath);
    }

    public void removeAll(String path) {
        Operator.removeAll(this.nativeHandle, path);
    }

    public List<Entry> list(String path) {
        return Arrays.asList(Operator.list(this.nativeHandle, path));
    }

    @Override
    protected native void disposeInternal(long var1);

    private static native long duplicate(long var0);

    private static native void write(long var0, String var2, byte[] var3);

    private static native byte[] read(long var0, String var2);

    private static native void delete(long var0, String var2);

    private static native Metadata stat(long var0, String var2);

    private static native long createDir(long var0, String var2);

    private static native long copy(long var0, String var2, String var3);

    private static native long rename(long var0, String var2, String var3);

    private static native void removeAll(long var0, String var2);

    private static native Entry[] list(long var0, String var2);
}

