/*
 * Decompiled with CFR 0.152.
 */
package org.apache.opendal;

import java.io.IOException;
import java.io.InputStream;
import org.apache.opendal.NativeObject;
import org.apache.opendal.Operator;

public class OperatorInputStream
extends InputStream {
    private final Reader reader;
    private int offset = 0;
    private byte[] bytes = new byte[0];

    public OperatorInputStream(Operator operator, String path) {
        long op = operator.nativeHandle;
        this.reader = new Reader(OperatorInputStream.constructReader(op, path));
    }

    @Override
    public int read() throws IOException {
        if (this.bytes != null && this.offset >= this.bytes.length) {
            this.bytes = OperatorInputStream.readNextBytes(this.reader.nativeHandle);
            this.offset = 0;
        }
        if (this.bytes != null) {
            return this.bytes[this.offset++] & 0xFF;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private static native long constructReader(long var0, String var2);

    private static native long disposeReader(long var0);

    private static native byte[] readNextBytes(long var0);

    private static class Reader
    extends NativeObject {
        private Reader(long nativeHandle) {
            super(nativeHandle);
        }

        @Override
        protected void disposeInternal(long handle) {
            OperatorInputStream.disposeReader(handle);
        }
    }
}

