/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.net.URI;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class ServiceLocator {
    private final Context context;

    public ServiceLocator(URI serverUri) throws NamingException {
        this(serverUri, null, null, null);
    }

    public ServiceLocator(URI serverUri, String username, String password) throws NamingException {
        this(serverUri, username, password, null);
    }

    public ServiceLocator(URI serverUri, String username, String password, String realm) throws NamingException {
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "org.apache.openejb.client.RemoteInitialContextFactory");
        properties.put("java.naming.provider.url", serverUri.toString());
        if (username != null && password != null) {
            properties.put("java.naming.security.principal", username);
            properties.put("java.naming.security.credentials", password);
            if (realm != null) {
                properties.put("openejb.authentication.realmName", realm);
            }
        }
        this.context = new InitialContext(properties);
    }

    public ServiceLocator(Context context) {
        this.context = context;
    }

    public Object lookup(String name) {
        try {
            return this.context.lookup(name);
        }
        catch (NamingException e) {
            throw new IllegalArgumentException(e);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

