/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.rules;

import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.SessionBean;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.rules.ValidationBase;
import org.apache.openejb.jee.EntityBean;
import org.apache.openejb.jee.RemoteBean;
import org.apache.openejb.jee.SessionType;

public class CheckMethods
extends ValidationBase {
    @Override
    public void validate(EjbModule ejbModule) {
        for (org.apache.openejb.jee.EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
            if (!(bean instanceof RemoteBean)) continue;
            RemoteBean b = (RemoteBean)bean;
            if (b.getHome() != null) {
                this.check_remoteInterfaceMethods(b);
                this.check_homeInterfaceMethods(b);
            }
            if (b.getLocalHome() != null) {
                this.check_localInterfaceMethods(b);
                this.check_localHomeInterfaceMethods(b);
            }
            this.check_unusedCreateMethods(b);
            this.check_unusedPostCreateMethods(b);
        }
    }

    private void check_localHomeInterfaceMethods(RemoteBean b) {
        Class home = null;
        Class bean = null;
        try {
            home = this.loadClass(b.getLocalHome());
            bean = this.loadClass(b.getEjbClass());
        }
        catch (OpenEJBException e) {
            return;
        }
        if (!EJBLocalHome.class.isAssignableFrom(home)) {
            return;
        }
        if (this.check_hasCreateMethod(b, bean, home)) {
            this.check_createMethodsAreImplemented(b, bean, home);
        }
    }

    private void check_localInterfaceMethods(RemoteBean b) {
        Class intrface = null;
        Class beanClass = null;
        try {
            intrface = this.loadClass(b.getLocal());
            beanClass = this.loadClass(b.getEjbClass());
        }
        catch (OpenEJBException e) {
            return;
        }
        if (!EJBLocalObject.class.isAssignableFrom(intrface)) {
            return;
        }
        Method[] interfaceMethods = intrface.getMethods();
        for (int i = 0; i < interfaceMethods.length; ++i) {
            if (interfaceMethods[i].getDeclaringClass() == EJBLocalObject.class) continue;
            String name = interfaceMethods[i].getName();
            try {
                Class<?>[] params = interfaceMethods[i].getParameterTypes();
                beanClass.getMethod(name, params);
                continue;
            }
            catch (NoSuchMethodException nsme) {
                ArrayList<Method> differentArgs = new ArrayList<Method>();
                ArrayList<Method> differentCase = new ArrayList<Method>();
                for (Method method : beanClass.getMethods()) {
                    if (method.getName().equals(name)) {
                        differentArgs.add(method);
                        continue;
                    }
                    if (!method.getName().equalsIgnoreCase(name)) continue;
                    differentCase.add(method);
                }
                if (differentArgs.size() > 0) {
                    this.fail((org.apache.openejb.jee.EnterpriseBean)b, "no.busines.method.args", interfaceMethods[i].getName(), interfaceMethods[i].toString(), "local", intrface.getName(), beanClass.getName(), differentArgs.size());
                }
                if (differentCase.size() > 0) {
                    this.fail((org.apache.openejb.jee.EnterpriseBean)b, "no.busines.method.case", interfaceMethods[i].getName(), interfaceMethods[i].toString(), "local", intrface.getName(), beanClass.getName(), differentCase.size());
                }
                if (differentArgs.size() != 0 || differentCase.size() != 0) continue;
                this.fail((org.apache.openejb.jee.EnterpriseBean)b, "no.busines.method", interfaceMethods[i].getName(), interfaceMethods[i].toString(), "local", intrface.getName(), beanClass.getName());
            }
        }
    }

    private void check_remoteInterfaceMethods(RemoteBean b) {
        Class intrface = null;
        Class beanClass = null;
        try {
            intrface = this.loadClass(b.getRemote());
            beanClass = this.loadClass(b.getEjbClass());
        }
        catch (OpenEJBException e) {
            return;
        }
        if (!EJBObject.class.isAssignableFrom(intrface)) {
            return;
        }
        Method[] interfaceMethods = intrface.getMethods();
        for (int i = 0; i < interfaceMethods.length; ++i) {
            if (interfaceMethods[i].getDeclaringClass() == EJBObject.class) continue;
            String name = interfaceMethods[i].getName();
            try {
                Class<?>[] params = interfaceMethods[i].getParameterTypes();
                beanClass.getMethod(name, params);
                continue;
            }
            catch (NoSuchMethodException nsme) {
                ArrayList<Method> differentArgs = new ArrayList<Method>();
                ArrayList<Method> differentCase = new ArrayList<Method>();
                for (Method method : beanClass.getMethods()) {
                    if (method.getName().equals(name)) {
                        differentArgs.add(method);
                        continue;
                    }
                    if (!method.getName().equalsIgnoreCase(name)) continue;
                    differentCase.add(method);
                }
                if (differentArgs.size() > 0) {
                    this.fail((org.apache.openejb.jee.EnterpriseBean)b, "no.busines.method.args", interfaceMethods[i].getName(), interfaceMethods[i].toString(), "remote", intrface.getName(), beanClass.getName(), differentArgs.size());
                }
                if (differentCase.size() > 0) {
                    this.fail((org.apache.openejb.jee.EnterpriseBean)b, "no.busines.method.case", interfaceMethods[i].getName(), interfaceMethods[i].toString(), "remote", intrface.getName(), beanClass.getName(), differentCase.size());
                }
                if (differentArgs.size() != 0 || differentCase.size() != 0) continue;
                this.fail((org.apache.openejb.jee.EnterpriseBean)b, "no.busines.method", interfaceMethods[i].getName(), interfaceMethods[i].toString(), "remote", intrface.getName(), beanClass.getName());
            }
        }
    }

    private void check_homeInterfaceMethods(RemoteBean b) {
        Class home = null;
        Class bean = null;
        try {
            home = this.loadClass(b.getHome());
            bean = this.loadClass(b.getEjbClass());
        }
        catch (OpenEJBException e) {
            return;
        }
        if (!EJBHome.class.isAssignableFrom(home)) {
            return;
        }
        if (this.check_hasCreateMethod(b, bean, home)) {
            this.check_createMethodsAreImplemented(b, bean, home);
        }
    }

    public boolean check_hasCreateMethod(RemoteBean b, Class bean, Class home) {
        if (b instanceof org.apache.openejb.jee.SessionBean && !SessionBean.class.isAssignableFrom(bean)) {
            return false;
        }
        Method[] homeMethods = home.getMethods();
        boolean hasCreateMethod = false;
        for (int i = 0; i < homeMethods.length && !hasCreateMethod; ++i) {
            hasCreateMethod = homeMethods[i].getName().startsWith("create");
        }
        if (!hasCreateMethod && !(b instanceof EntityBean)) {
            this.fail((org.apache.openejb.jee.EnterpriseBean)b, "no.home.create", b.getHome(), b.getRemote());
        }
        return hasCreateMethod;
    }

    public boolean check_createMethodsAreImplemented(RemoteBean b, Class bean, Class home) {
        boolean result = true;
        Method[] homeMethods = home.getMethods();
        for (int i = 0; i < homeMethods.length; ++i) {
            if (!homeMethods[i].getName().startsWith("create")) continue;
            Method create = homeMethods[i];
            StringBuilder ejbCreateName = new StringBuilder(create.getName());
            ejbCreateName.replace(0, 1, "ejbC");
            try {
                if (!EnterpriseBean.class.isAssignableFrom(bean)) continue;
                bean.getMethod(ejbCreateName.toString(), create.getParameterTypes());
                continue;
            }
            catch (NoSuchMethodException e) {
                org.apache.openejb.jee.SessionBean sb;
                result = false;
                String paramString = this.getParameters(create);
                if (b instanceof EntityBean) {
                    EntityBean entity = (EntityBean)b;
                    this.fail((org.apache.openejb.jee.EnterpriseBean)b, "entity.no.ejb.create", b.getEjbClass(), entity.getPrimKeyClass(), ejbCreateName.toString(), paramString);
                    continue;
                }
                if (!(b instanceof org.apache.openejb.jee.SessionBean) || (sb = (org.apache.openejb.jee.SessionBean)b).getSessionType().equals((Object)SessionType.STATELESS)) continue;
                this.fail((org.apache.openejb.jee.EnterpriseBean)b, "session.no.ejb.create", b.getEjbClass(), ejbCreateName.toString(), paramString);
            }
        }
        return result;
    }

    public boolean check_postCreateMethodsAreImplemented(RemoteBean b, Class bean, Class home) {
        boolean result = true;
        if (b instanceof org.apache.openejb.jee.SessionBean) {
            return true;
        }
        Method[] homeMethods = home.getMethods();
        Method[] beanMethods = bean.getMethods();
        for (int i = 0; i < homeMethods.length; ++i) {
            if (!homeMethods[i].getName().startsWith("create")) continue;
            Method create = homeMethods[i];
            StringBuilder ejbPostCreateName = new StringBuilder(create.getName());
            ejbPostCreateName.replace(0, 1, "ejbPostC");
            try {
                bean.getMethod(ejbPostCreateName.toString(), create.getParameterTypes());
                continue;
            }
            catch (NoSuchMethodException e) {
                result = false;
                String paramString = this.getParameters(create);
                this.fail((org.apache.openejb.jee.EnterpriseBean)b, "no.ejb.post.create", b.getEjbClass(), ejbPostCreateName.toString(), paramString);
            }
        }
        return result;
    }

    public void check_unusedCreateMethods(RemoteBean b) {
        Class home = null;
        Class localHome = null;
        Class bean = null;
        try {
            if (b.getLocalHome() != null) {
                localHome = this.loadClass(b.getLocalHome());
            }
            if (b.getHome() != null) {
                home = this.loadClass(b.getHome());
            }
            bean = this.loadClass(b.getEjbClass());
        }
        catch (OpenEJBException e) {
            return;
        }
        for (Method ejbCreate : bean.getMethods()) {
            if (!ejbCreate.getName().startsWith("ejbCreate")) continue;
            StringBuilder create = new StringBuilder(ejbCreate.getName());
            create.replace(0, "ejbC".length(), "c");
            boolean inLocalHome = false;
            boolean inHome = false;
            try {
                if (localHome != null) {
                    localHome.getMethod(create.toString(), ejbCreate.getParameterTypes());
                    inLocalHome = true;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            try {
                if (home != null) {
                    home.getMethod(create.toString(), ejbCreate.getParameterTypes());
                    inHome = true;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (inLocalHome || inHome) continue;
            String paramString = this.getParameters(ejbCreate);
            this.warn((org.apache.openejb.jee.EnterpriseBean)b, "unused.ejb.create", b.getEjbClass(), ejbCreate.getName(), paramString, create.toString());
        }
    }

    public void check_unusedPostCreateMethods(RemoteBean b) {
        Class bean = null;
        try {
            bean = this.loadClass(b.getEjbClass());
        }
        catch (OpenEJBException e) {
            return;
        }
        for (Method postCreate : bean.getMethods()) {
            if (!postCreate.getName().startsWith("ejbPostCreate")) continue;
            StringBuilder ejbCreate = new StringBuilder(postCreate.getName());
            ejbCreate.replace(0, "ejbPostCreate".length(), "ejbCreate");
            try {
                bean.getMethod(ejbCreate.toString(), postCreate.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                String paramString = this.getParameters(postCreate);
                this.warn((org.apache.openejb.jee.EnterpriseBean)b, "unused.ejbPostCreate", b.getEjbClass(), postCreate.getName(), paramString, ejbCreate.toString());
            }
        }
    }
}

