/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common.enrichment;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.arquillian.common.mockito.MockitoEnricher;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.AppFinder;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.jboss.arquillian.test.spi.TestClass;

public final class OpenEJBEnricher {
    private static final Logger LOGGER = Logger.getLogger(OpenEJBEnricher.class.getName());

    private OpenEJBEnricher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enrich(Object testInstance, AppContext appCtx) {
        new MockitoEnricher().enrich(testInstance);
        AppContext ctx = appCtx;
        if (ctx == null && (ctx = (AppContext)AppFinder.findAppContextOrWeb((ClassLoader)Thread.currentThread().getContextClassLoader(), (AppFinder.Transformer)AppFinder.AppContextTransformer.INSTANCE)) == null) {
            return;
        }
        BeanContext context = ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getBeanContext((Object)(ctx.getId() + "_" + testInstance.getClass().getName()));
        WebBeansContext appWBC = ctx.getWebBeansContext();
        BeanManagerImpl bm = appWBC.getBeanManagerImpl();
        boolean ok = false;
        for (WebContext web : ctx.getWebContexts()) {
            WebBeansContext webBeansContext = web.getWebBeansContext();
            BeanManagerImpl webAppBm = webBeansContext.getBeanManagerImpl();
            if (webBeansContext == appWBC || !webAppBm.isInUse()) continue;
            try {
                OpenEJBEnricher.doInject(testInstance, context, webAppBm);
                ok = true;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (bm != null && bm.isInUse() && !ok) {
            try {
                OpenEJBEnricher.doInject(testInstance, context, bm);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed injection on: " + testInstance.getClass(), e);
                if (RuntimeException.class.isInstance(e)) {
                    throw (RuntimeException)RuntimeException.class.cast(e);
                }
                throw new OpenEJBRuntimeException(e);
            }
        }
        if (context != null) {
            ThreadContext callContext = new ThreadContext(context, null, Operation.INJECTION);
            ThreadContext oldContext = ThreadContext.enter((ThreadContext)callContext);
            try {
                InjectionProcessor processor = new InjectionProcessor(testInstance, (Collection)context.getInjections(), context.getJndiContext());
                processor.createInstance();
            }
            catch (OpenEJBException openEJBException) {
            }
            finally {
                ThreadContext.exit((ThreadContext)oldContext);
            }
        }
    }

    private static void doInject(Object testInstance, BeanContext context, BeanManagerImpl bm) throws Exception {
        Set beans = bm.getBeans(testInstance.getClass(), new Annotation[0]);
        Bean bean = bm.resolve(beans);
        CreationalContextImpl cc = bm.createCreationalContext((Contextual)bean);
        if (context != null) {
            context.set(CreationalContext.class, (Object)cc);
        }
        OWBInjector.inject((BeanManager)bm, (Object)testInstance, (CreationalContext)cc);
    }

    private static BeanManagerImpl findBeanManager(AppContext ctx) {
        if (ctx != null) {
            return ctx.getWebBeansContext().getBeanManagerImpl();
        }
        try {
            return WebBeansContext.currentInstance().getBeanManagerImpl();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object[] resolve(AppContext appContext, TestClass testClass, Method method) {
        Object[] values = new Object[method.getParameterTypes().length];
        if (appContext == null) {
            return values;
        }
        BeanManagerImpl beanManager = OpenEJBEnricher.findBeanManager(appContext);
        if (beanManager == null) {
            return values;
        }
        Class<?> clazz = testClass != null ? testClass.getJavaClass() : method.getDeclaringClass();
        AnnotatedElementFactory factory = beanManager.getWebBeansContext().getAnnotatedElementFactory();
        AnnotatedMethod am = factory.newAnnotatedMethod(method, factory.newAnnotatedType(clazz));
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            try {
                values[i] = OpenEJBEnricher.getParamInstance(beanManager, i, am);
                continue;
            }
            catch (Exception e) {
                LOGGER.info(e.getMessage());
            }
        }
        return values;
    }

    private static <T> T getParamInstance(BeanManagerImpl manager, int position, AnnotatedMethod<?> am) {
        AnnotationManager annotationManager = manager.getWebBeansContext().getAnnotationManager();
        AnnotatedParameter ap = (AnnotatedParameter)am.getParameters().get(position);
        Type baseType = ap.getBaseType();
        Set beans = manager.getBeans(baseType, annotationManager.getInterceptorBindingMetaAnnotations(ap.getAnnotations()));
        if (beans == null) {
            return null;
        }
        Bean bean = manager.resolve(beans);
        if (bean == null) {
            return null;
        }
        CreationalContextImpl creational = manager.createCreationalContext(null);
        return (T)manager.getReference(bean, baseType, (CreationalContext)creational);
    }
}

