/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.openejb;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.arquillian.openejb.SWClassLoader;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.FinderFactory;
import org.apache.openejb.config.ReadDescriptors;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.WebappAggregatedArchive;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.ManagedBean;
import org.apache.openejb.jee.TransactionType;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.IO;
import org.apache.openejb.util.classloader.URLClassLoaderFirst;
import org.apache.xbean.finder.IAnnotationFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.apache.xbean.finder.archive.CompositeArchive;
import org.apache.xbean.finder.archive.FilteredArchive;
import org.apache.xbean.finder.archive.JarArchive;
import org.apache.xbean.finder.filter.Filter;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.filter.IncludeRegExpPaths;

public class OpenEJBArchiveProcessor {
    private static final Logger LOGGER = Logger.getLogger(OpenEJBArchiveProcessor.class.getName());
    private static final String META_INF = "META-INF/";
    private static final String WEB_INF = "WEB-INF/";
    private static final String EJB_JAR_XML = "ejb-jar.xml";
    private static final String BEANS_XML = "beans.xml";
    private static final String VALIDATION_XML = "validation.xml";
    private static final String RESOURCES_XML = "resources.xml";
    private static final String PERSISTENCE_XML = "persistence.xml";
    private static final String OPENEJB_JAR_XML = "openejb-jar.xml";
    private static final String ENV_ENTRIES_PROPERTIES = "env-entries.properties";
    public static final String WEB_INF_CLASSES = "/WEB-INF/classes/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppModule createModule(Archive<?> archive, TestClass testClass) {
        Node envEntriesProperties;
        Node resourcesXml;
        Node validationXml;
        Node openejbJarXml;
        Node ejbJarXml;
        EjbJar ejbJar;
        String prefix;
        Class javaClass = testClass != null ? testClass.getJavaClass() : null;
        ArrayList<URL> additionalPaths = new ArrayList<URL>();
        if (WebArchive.class.isInstance(archive)) {
            prefix = WEB_INF;
            Map content = archive.getContent((org.jboss.shrinkwrap.api.Filter)new IncludeRegExpPaths("/WEB-INF/lib/.*"));
            for (Map.Entry node : content.entrySet()) {
                Archive nestedArchive;
                Asset asset = ((Node)node.getValue()).getAsset();
                if (UrlAsset.class.isInstance(asset)) {
                    additionalPaths.add(OpenEJBArchiveProcessor.get(URL.class, "url", asset));
                    continue;
                }
                if (FileAsset.class.isInstance(asset)) {
                    try {
                        additionalPaths.add(OpenEJBArchiveProcessor.get(File.class, "file", asset).toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        LOGGER.log(Level.SEVERE, "can't add a library to the deployment", e);
                    }
                    continue;
                }
                if (!ArchiveAsset.class.isInstance(asset) || OpenEJBArchiveProcessor.isExcluded((nestedArchive = ((ArchiveAsset)ArchiveAsset.class.cast(asset)).getArchive()).getName())) continue;
                archive.merge(nestedArchive);
            }
        } else {
            prefix = META_INF;
        }
        ClassLoader parent = javaClass == null ? Thread.currentThread().getContextClassLoader() : javaClass.getClassLoader();
        URL[] urls = additionalPaths.toArray(new URL[additionalPaths.size()]);
        SWClassLoader loader = !WEB_INF.equals(prefix) ? new SWClassLoader("", new URLClassLoader(urls, parent), archive) : new SWClassLoader(WEB_INF_CLASSES, (ClassLoader)new URLClassLoaderFirst(urls, parent), archive);
        URLClassLoader tempClassLoader = ClassLoaderUtil.createTempClassLoader((ClassLoader)loader);
        AppModule appModule = new AppModule((ClassLoader)loader, archive.getName());
        if (WEB_INF.equals(prefix)) {
            appModule.setDelegateFirst(false);
            appModule.setStandloneWebModule();
            WebModule webModule = new WebModule(new WebApp(), OpenEJBArchiveProcessor.contextRoot(archive.getName()), (ClassLoader)loader, "", appModule.getModuleId());
            webModule.setUrls(additionalPaths);
            appModule.getWebModules().add(webModule);
        }
        if (javaClass != null) {
            ejbJar = new EjbJar();
            OpenejbJar openejbJar = new OpenejbJar();
            String ejbName = appModule.getModuleId() + "_" + javaClass.getName();
            ManagedBean bean = (ManagedBean)ejbJar.addEnterpriseBean((EnterpriseBean)new ManagedBean(ejbName, javaClass.getName(), true));
            bean.localBean();
            bean.setTransactionType(TransactionType.BEAN);
            EjbDeployment ejbDeployment = openejbJar.addEjbDeployment((EnterpriseBean)bean);
            ejbDeployment.setDeploymentId(ejbName);
            EjbModule e = new EjbModule(ejbJar, openejbJar);
            e.setClassLoader((ClassLoader)tempClassLoader);
            appModule.getEjbModules().add(e);
        }
        if ((ejbJarXml = archive.get(prefix.concat(EJB_JAR_XML))) != null) {
            try {
                ejbJar = ReadDescriptors.readEjbJar((InputStream)ejbJarXml.getAsset().openStream());
            }
            catch (OpenEJBException e) {
                throw new OpenEJBRuntimeException((Exception)((Object)e));
            }
        } else {
            ejbJar = new EjbJar();
        }
        if (ejbJar.getModuleName() == null) {
            String name = archive.getName();
            if (name.endsWith("ar") && name.length() > 4) {
                ejbJar.setModuleName(name.substring(0, name.length() - ".jar".length()));
            } else {
                ejbJar.setModuleName(name);
            }
        }
        EjbModule ejbModule = new EjbModule(ejbJar);
        ejbModule.setClassLoader((ClassLoader)tempClassLoader);
        Node beansXml = archive.get(prefix.concat(BEANS_XML));
        if (beansXml == null && WEB_INF.equals(prefix)) {
            beansXml = archive.get(WEB_INF_CLASSES.concat(META_INF).concat(BEANS_XML));
        }
        if (beansXml != null) {
            ejbModule.getAltDDs().put(BEANS_XML, new AssetSource(beansXml.getAsset()));
        }
        org.apache.xbean.finder.archive.Archive finderArchive = OpenEJBArchiveProcessor.finderArchive(beansXml, archive, tempClassLoader, additionalPaths);
        ejbModule.setFinder((IAnnotationFinder)new FinderFactory.ModuleLimitedFinder(new FinderFactory.OpenEJBAnnotationFinder(finderArchive)));
        if (appModule.isWebapp()) {
            ((WebModule)appModule.getWebModules().iterator().next()).setFinder(ejbModule.getFinder());
        }
        appModule.getEjbModules().add(ejbModule);
        Node persistenceXml = archive.get(prefix.concat(PERSISTENCE_XML));
        if (persistenceXml == null && WEB_INF.equals(prefix)) {
            persistenceXml = archive.get(WEB_INF_CLASSES.concat(META_INF).concat(PERSISTENCE_XML));
        }
        if (persistenceXml != null) {
            Asset asset = persistenceXml.getAsset();
            if (UrlAsset.class.isInstance(asset)) {
                appModule.getAltDDs().put(PERSISTENCE_XML, Arrays.asList(OpenEJBArchiveProcessor.get(URL.class, "url", asset)));
            } else if (FileAsset.class.isInstance(asset)) {
                try {
                    appModule.getAltDDs().put(PERSISTENCE_XML, Arrays.asList(OpenEJBArchiveProcessor.get(File.class, "file", asset).toURI().toURL()));
                }
                catch (MalformedURLException e) {
                    appModule.getAltDDs().put(PERSISTENCE_XML, Arrays.asList(new AssetSource(persistenceXml.getAsset())));
                }
            } else if (ClassLoaderAsset.class.isInstance(asset)) {
                URL url = OpenEJBArchiveProcessor.get(ClassLoader.class, "classLoader", asset).getResource(OpenEJBArchiveProcessor.get(String.class, "resourceName", asset));
                if (url != null) {
                    appModule.getAltDDs().put(PERSISTENCE_XML, Arrays.asList(url));
                } else {
                    appModule.getAltDDs().put(PERSISTENCE_XML, Arrays.asList(new AssetSource(persistenceXml.getAsset())));
                }
            } else {
                appModule.getAltDDs().put(PERSISTENCE_XML, Arrays.asList(new AssetSource(persistenceXml.getAsset())));
            }
        }
        if ((openejbJarXml = archive.get(prefix.concat(OPENEJB_JAR_XML))) != null) {
            ejbModule.getAltDDs().put(OPENEJB_JAR_XML, new AssetSource(openejbJarXml.getAsset()));
        }
        if ((validationXml = archive.get(prefix.concat(VALIDATION_XML))) != null) {
            ejbModule.getAltDDs().put(VALIDATION_XML, new AssetSource(validationXml.getAsset()));
        }
        if ((resourcesXml = archive.get(prefix.concat(RESOURCES_XML))) != null) {
            ejbModule.getAltDDs().put(RESOURCES_XML, new AssetSource(resourcesXml.getAsset()));
        }
        if ((envEntriesProperties = archive.get(prefix.concat(ENV_ENTRIES_PROPERTIES))) != null) {
            InputStream is = null;
            Properties properties = new Properties();
            try {
                is = envEntriesProperties.getAsset().openStream();
                properties.load(is);
                ejbModule.getAltDDs().put(ENV_ENTRIES_PROPERTIES, properties);
                ((EjbModule)appModule.getEjbModules().iterator().next()).getAltDDs().put(ENV_ENTRIES_PROPERTIES, properties);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "can't read env-entries.properties", e);
            }
            finally {
                IO.close((Closeable)is);
            }
        }
        if (!appModule.isWebapp()) {
            appModule.getAdditionalLibraries().addAll(additionalPaths);
        }
        return appModule;
    }

    private static String contextRoot(String name) {
        if (name.endsWith(".war")) {
            return name.substring(0, name.length() - ".war".length());
        }
        return name;
    }

    private static <T> T get(Class<T> fileClass, String attr, Asset asset) {
        try {
            Field field = asset.getClass().getDeclaredField(attr);
            field.setAccessible(true);
            return fileClass.cast(field.get(asset));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static org.apache.xbean.finder.archive.Archive finderArchive(Node beansXml, Archive<?> archive, ClassLoader cl, Collection<URL> additionalPaths) {
        ArrayList classes = new ArrayList();
        Map content = archive.getContent((org.jboss.shrinkwrap.api.Filter)new IncludeRegExpPaths(".*.class"));
        for (Map.Entry node : content.entrySet()) {
            String classname = OpenEJBArchiveProcessor.name(((ArchivePath)node.getKey()).get());
            try {
                classes.add(cl.loadClass(classname));
            }
            catch (ClassNotFoundException e) {
                LOGGER.fine("Can't load class " + classname);
                if (!LOGGER.isLoggable(Level.FINEST)) continue;
                e.printStackTrace(System.err);
            }
            catch (NoClassDefFoundError e) {}
        }
        HashMap<URL, List<String>> classesByUrl = new HashMap<URL, List<String>>();
        ArrayList<Object> archives = new ArrayList<Object>();
        for (URL url : DeploymentLoader.filterWebappUrls((URL[])additionalPaths.toArray(new URL[additionalPaths.size()]), null)) {
            ArrayList arrayList = new ArrayList();
            FilteredArchive newArchive = new FilteredArchive((org.apache.xbean.finder.archive.Archive)new JarArchive(cl, url), (Filter)new WebappAggregatedArchive.ScanXmlSaverFilter(false, null, arrayList));
            classesByUrl.put(url, arrayList);
            archives.add(newArchive);
        }
        archives.add(new ClassesArchive(classes));
        if (beansXml != null) {
            ArrayList<String> mainClasses = new ArrayList<String>();
            for (Class clazz : classes) {
                mainClasses.add(clazz.getName());
            }
            try {
                URL key = new URL("jar:file://!/WEB-INF/classes/");
                classesByUrl.put(key, mainClasses);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return new SimpleWebappAggregatedArchive(new CompositeArchive(archives), classesByUrl);
    }

    private static boolean isExcluded(String archiveName) {
        return "arquillian-junit.jar".equals(archiveName) || "arquillian-protocol.jar".equals(archiveName) || "arquillian-core.jar".equals(archiveName);
    }

    private static String name(String raw) {
        String name = raw;
        if (name.startsWith(WEB_INF_CLASSES)) {
            name = name.substring(WEB_INF_CLASSES.length() - 1);
        }
        name = name.replace('/', '.');
        return name.substring(1, name.length() - 6);
    }

    private static class SimpleWebappAggregatedArchive
    extends WebappAggregatedArchive {
        private final CompositeArchive delegate;
        private final Map<URL, List<String>> classesMap;

        public SimpleWebappAggregatedArchive(CompositeArchive archive, Map<URL, List<String>> map) {
            super(Thread.currentThread().getContextClassLoader(), new HashMap(), new ArrayList());
            this.delegate = archive;
            this.classesMap = map;
        }

        public Map<URL, List<String>> getClassesMap() {
            return this.classesMap;
        }

        public InputStream getBytecode(String s) throws IOException, ClassNotFoundException {
            return this.delegate.getBytecode(s);
        }

        public Class<?> loadClass(String s) throws ClassNotFoundException {
            return this.delegate.loadClass(s);
        }

        public Iterator<Archive.Entry> iterator() {
            return this.delegate.iterator();
        }
    }

    private static final class AssetSource
    implements ReadDescriptors.Source {
        private Asset asset;

        private AssetSource(Asset asset) {
            this.asset = asset;
        }

        public InputStream get() throws IOException {
            return this.asset.openStream();
        }
    }
}

