/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.arquillian.common.BeanDicovererInstaller;
import org.apache.openejb.arquillian.common.Files;
import org.apache.openejb.arquillian.common.IO;
import org.apache.openejb.arquillian.common.MavenCache;
import org.apache.openejb.arquillian.common.TestClassDiscoverer;
import org.apache.openejb.arquillian.common.TomEEConfiguration;
import org.apache.openejb.arquillian.common.Zips;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.JarExtractor;
import org.apache.tomee.util.QuickServerXmlParser;
import org.codehaus.swizzle.stream.ReplaceStringsInputStream;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class Setup {
    private static final Logger LOGGER = Logger.getLogger(Setup.class.getName());
    public static final String TOMEE_BEAN_DISCOVERER_JAR = "lib" + File.separator + "arquillian-tomee-bean-discoverer.jar";
    private static final String DEFAULT_MEM_CONFIG = "-Xmx512m -Xms256m -XX:PermSize=64m -XX:MaxPermSize=256m -XX:ReservedCodeCacheSize=64m";

    public static void exportProperties(File tomeeHome, TomEEConfiguration c, boolean defaultMem) {
        System.setProperty("java.naming.provider.url", "http://" + c.getHost() + ":" + c.getHttpPort() + "/tomee/ejb");
        System.setProperty("connect.tries", "90");
        System.setProperty("server.http.port", String.valueOf(c.getHttpPort()));
        System.setProperty("server.shutdown.port", String.valueOf(c.getStopPort()));
        if (defaultMem) {
            System.setProperty("java.opts", "-Xmx512m -Xms256m -XX:PermSize=64m -XX:MaxPermSize=256m -XX:ReservedCodeCacheSize=64m -Dtomee.httpPort=" + c.getHttpPort());
        } else {
            System.setProperty("java.opts", "-Dtomee.httpPort=" + c.getHttpPort());
        }
        System.setProperty("openejb.home", tomeeHome.getAbsolutePath());
        System.setProperty("tomee.home", tomeeHome.getAbsolutePath());
    }

    public static void updateServerXml(File tomeeHome, TomEEConfiguration configuration) throws IOException {
        File serverXml = Files.path(tomeeHome, "conf", "server.xml");
        QuickServerXmlParser ports = QuickServerXmlParser.parse((File)serverXml);
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put(ports.http(), String.valueOf(configuration.getHttpPort()));
        replacements.put(ports.stop(), String.valueOf(configuration.getStopPort()));
        replacements.put(ports.ajp(), String.valueOf(Setup.ajpPort(configuration)));
        if (configuration.isUnpackWars()) {
            replacements.put("unpackWARs=\"false\"", "unpackWARs=\"true\"");
        } else {
            replacements.put("unpackWARs=\"true\"", "unpackWARs=\"false\"");
        }
        Setup.replace(replacements, serverXml);
    }

    public static File findHome(File directory) {
        File f = Setup.findHomeImpl(directory = directory.getAbsoluteFile());
        if (null == f) {
            LOGGER.log(Level.INFO, "Unable to find home in: " + directory);
        }
        return f;
    }

    public static File findHomeImpl(File directory) {
        File conf = new File(directory, "conf").getAbsoluteFile();
        File webapps = new File(directory, "webapps").getAbsoluteFile();
        if (conf.exists() && conf.isDirectory() && webapps.exists() && webapps.isDirectory()) {
            return directory;
        }
        File[] files = directory.listFiles();
        if (null != files) {
            for (File file : files) {
                File found;
                if (".".equals(file.getName()) || "..".equals(file.getName()) || (found = Setup.findHome(file)) == null) continue;
                return found;
            }
        }
        return null;
    }

    public static File downloadAndUnpack(File dir, String artifactID) throws LifecycleException {
        File zipFile = Setup.downloadFile(artifactID, null);
        Zips.unzip(zipFile, dir);
        return Setup.findHome(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadFile(String artifactName, String altUrl) {
        String cache = SystemInstance.get().getOptions().get("openejb.deployer.cache.folder", (String)null);
        if (cache == null) {
            System.setProperty("openejb.deployer.cache.folder", "target");
        }
        try {
            File artifact = MavenCache.getArtifact(artifactName, altUrl);
            if (artifact == null) {
                throw new NullPointerException(String.format("No such artifact: %s", artifactName));
            }
            File file = artifact.getAbsoluteFile();
            return file;
        }
        finally {
            if (cache == null) {
                System.clearProperty("openejb.deployer.cache.folder");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRunning(String host, int port) {
        Socket socket = null;
        try {
            socket = new Socket(host, port);
            socket.getOutputStream().close();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public static void replace(Map<String, String> replacements, File file) throws IOException {
        InputStream in = IO.read(file);
        in = new ReplaceStringsInputStream(in, replacements);
        String data = IO.slurp(in);
        IO.copy(data.getBytes(), file);
        if (LOGGER.isLoggable(Level.FINE)) {
            IO.copy(data.getBytes(), (OutputStream)System.out);
        }
    }

    public static void removeUselessWebapps(File tomeeHome) {
        File[] files;
        File webapps = new File(tomeeHome, "webapps");
        if (webapps.isDirectory() && (files = webapps.listFiles()) != null) {
            for (File webapp : files) {
                String name = webapp.getName();
                if (!webapp.isDirectory() || name.equals("openejb") || name.equals("tomee")) continue;
                JarExtractor.delete((File)webapp);
            }
        }
    }

    public static void configureServerXml(File tomeeHome, TomEEConfiguration configuration) throws IOException {
        if (configuration.getServerXml() != null) {
            File serverXml = new File(configuration.getServerXml());
            if (!serverXml.exists()) {
                LOGGER.severe("Provided server.xml doesn't exist: '" + serverXml.getPath() + "'");
            } else {
                String data = IO.slurp(serverXml);
                IO.copy(data.getBytes(), Files.path(tomeeHome, "conf", "server.xml"));
                configuration.setStopPort(Integer.parseInt(QuickServerXmlParser.parse((String)data).stop()));
                return;
            }
        }
        Setup.updateServerXml(tomeeHome, configuration);
    }

    private static int ajpPort(TomEEConfiguration config) {
        try {
            Method ajbPort = config.getClass().getMethod("getAjpPort", new Class[0]);
            return (Integer)ajbPort.invoke((Object)config, new Object[0]);
        }
        catch (Exception e) {
            return Integer.parseInt("8009");
        }
    }

    public static void configureSystemProperties(File tomeeHome, TomEEConfiguration configuration) {
        File file = Files.path(tomeeHome, "conf", "system.properties");
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                IO.readProperties(file, properties);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Can't read " + file.getAbsolutePath(), e);
            }
        }
        if (configuration.getProperties() != null) {
            try {
                InputStream bytes = IO.read(configuration.getProperties().getBytes());
                IO.readProperties(bytes, properties);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Can't parse <property name=\"properties\"> value '" + configuration.getProperties() + "'", e);
            }
        }
        if (configuration.isQuickSession()) {
            properties.put("openejb.session.manager", "org.apache.tomee.catalina.session.QuickSessionManager");
        }
        try {
            IO.writeProperties(file, properties);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Can't save system properties " + file.getAbsolutePath(), e);
        }
    }

    public static void synchronizeFolder(File tomeeHome, String src, String dir) {
        if (src != null && !src.isEmpty()) {
            File confSrc = new File(src);
            if (confSrc.exists()) {
                File conf = new File(tomeeHome, dir);
                List files = org.apache.openejb.loader.Files.collect((File)confSrc, (FileFilter)new DirectFileOnlyFilter(confSrc));
                files.remove(confSrc);
                for (File f : files) {
                    try {
                        org.apache.openejb.loader.IO.copy((File)f, (File)new File(conf, Setup.relativize(f, confSrc)));
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Ignoring copy of " + f.getAbsolutePath(), e);
                    }
                }
            } else {
                LOGGER.warning("Can't find " + confSrc.getAbsolutePath());
            }
        }
    }

    private static String relativize(File f, File base) {
        return f.getAbsolutePath().substring(base.getAbsolutePath().length() + 1);
    }

    public static void installArquillianBeanDiscoverer(File home) {
        File destination = new File(home, TOMEE_BEAN_DISCOVERER_JAR);
        ((ZipExporter)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)destination.getName())).addClasses(new Class[]{BeanDicovererInstaller.class, TestClassDiscoverer.class})).addAsManifestResource((Asset)new StringAsset(BeanDicovererInstaller.class.getName()), ArchivePaths.create((String)"org.apache.openejb.extension"))).as(ZipExporter.class)).exportTo(destination, false);
    }

    public static void removeArquillianBeanDiscoverer(File home) {
        File destination = new File(home, TOMEE_BEAN_DISCOVERER_JAR);
        Files.delete(destination);
    }

    private static class DirectFileOnlyFilter
    implements FileFilter {
        private final File accepted;

        public DirectFileOnlyFilter(File confSrc) {
            this.accepted = confSrc;
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getParentFile().equals(this.accepted);
        }
    }
}

