/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.config.RemoteServer;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.JarLocation;
import org.apache.openejb.loader.LoaderRuntimeException;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.Zips;
import org.apache.openejb.maven.plugin.BuildTomEEMojo;
import org.apache.openejb.maven.plugin.runner.ExecRunner;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.Pipe;
import org.apache.tomee.util.QuickServerXmlParser;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="exec", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class ExecMojo
extends BuildTomEEMojo {
    private static final String DEFAULT_SCRIPT = "bin/catalina[.sh|.bat]";
    @Parameter(property="tomee-plugin.exec-file", defaultValue="${project.build.directory}/${project.build.finalName}-exec.jar")
    protected File execFile;
    @Parameter(property="tomee-plugin.runner-class", defaultValue="org.apache.openejb.maven.plugin.runner.ExecRunner")
    private String runnerClass;
    @Parameter(property="tomee-plugin.distribution-name", defaultValue="tomee.zip")
    private String distributionName;
    @Parameter(property="tomee-plugin.runtime-working-dir", defaultValue=".distribution")
    private String runtimeWorkingDir;
    @Parameter(property="tomee-plugin.script", defaultValue="bin/catalina[.sh|.bat]")
    private String script;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean realAttach = this.attach;
        this.attach = false;
        this.zip = true;
        super.execute();
        try {
            this.createExecutableJar();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (realAttach) {
            this.getLog().info((CharSequence)"Attaching Exec TomEE binary");
            if (this.classifier != null) {
                this.projectHelper.attachArtifact(this.project, "jar", this.classifier, this.execFile);
            } else {
                this.projectHelper.attachArtifact(this.project, "jar", this.execFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createExecutableJar() throws Exception {
        Files.mkdirs((File)this.execFile.getParentFile());
        Properties config = new Properties();
        config.put("distribution", this.distributionName);
        config.put("workingDir", this.runtimeWorkingDir);
        config.put("command", DEFAULT_SCRIPT.equals(this.script) ? (this.skipArchiveRootFolder ? "" : this.catalinaBase.getName() + "/") + DEFAULT_SCRIPT : this.script);
        List<String> jvmArgs = this.generateJVMArgs();
        String catalinaOpts = ExecMojo.toString(jvmArgs);
        config.put("catalinaOpts", catalinaOpts);
        config.put("timestamp", Long.toString(System.currentTimeMillis()));
        String cp = this.getAdditionalClasspath();
        if (cp != null) {
            config.put("additionalClasspath", cp);
        }
        config.put("shutdownCommand", this.tomeeShutdownCommand);
        int i = 0;
        boolean encodingSet = catalinaOpts.contains("-Dfile.encoding");
        for (String jvmArg : jvmArgs) {
            config.put("jvmArg." + i++, jvmArg);
            encodingSet = encodingSet || jvmArg.contains("-Dfile.encoding");
        }
        if (!encodingSet) {
            config.put("jvmArg." + i, "-Dfile.encoding=UTF-8");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.execFile);
        ArchiveOutputStream os = new ArchiveStreamFactory().createArchiveOutputStream("jar", (OutputStream)fileOutputStream);
        os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry(this.distributionName));
        FileInputStream in = new FileInputStream(this.zipFile);
        try {
            IOUtils.copy((InputStream)in, (OutputStream)os);
            os.closeArchiveEntry();
        }
        finally {
            IOUtil.close((InputStream)in);
        }
        os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("configuration.properties"));
        StringWriter writer = new StringWriter();
        config.store(writer, "");
        IOUtils.copy((InputStream)new ByteArrayInputStream(writer.toString().getBytes("UTF-8")), (OutputStream)os);
        os.closeArchiveEntry();
        Manifest manifest = new Manifest();
        Manifest.Attribute mainClassAtt = new Manifest.Attribute();
        mainClassAtt.setName("Main-Class");
        mainClassAtt.setValue(this.runnerClass);
        manifest.addConfiguredAttribute(mainClassAtt);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        manifest.write((OutputStream)baos);
        os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("META-INF/MANIFEST.MF"));
        IOUtils.copy((InputStream)new ByteArrayInputStream(baos.toByteArray()), (OutputStream)os);
        os.closeArchiveEntry();
        for (Class clazz : Arrays.asList(ExecRunner.class, Files.class, Files.PatternFileFilter.class, Files.DeleteThread.class, Files.FileRuntimeException.class, Files.FileDoesNotExistException.class, Files.NoopOutputStream.class, LoaderRuntimeException.class, Pipe.class, IO.class, Zips.class, JarLocation.class, RemoteServer.class, RemoteServer.CleanUpThread.class, OpenEJBRuntimeException.class, Join.class, QuickServerXmlParser.class, Options.class, Options.NullLog.class, Options.TomEEPropertyAdapter.class, Options.NullOptions.class, Options.Log.class)) {
            String name = clazz.getName().replace('.', '/') + ".class";
            os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry(name));
            IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream('/' + name), (OutputStream)os);
            os.closeArchiveEntry();
        }
        IOUtil.close((OutputStream)os);
        IOUtil.close((OutputStream)fileOutputStream);
    }

    private static String toString(List<String> strings) {
        StringBuilder builder = new StringBuilder();
        for (String s : strings) {
            builder.append(s).append(" ");
        }
        return builder.toString();
    }
}

