/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Arrays;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import org.apache.openejb.client.ApplicationException;
import org.apache.openejb.client.ArrayEnumeration;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.client.EJBHomeHandler;
import org.apache.openejb.client.EJBHomeProxy;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.EJBObjectHandler;
import org.apache.openejb.client.EJBRequest;
import org.apache.openejb.client.EJBResponse;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.client.SystemError;
import org.apache.openejb.client.SystemException;
import org.apache.openejb.client.ThrowableArtifact;

public class EntityEJBHomeHandler
extends EJBHomeHandler {
    public EntityEJBHomeHandler() {
    }

    public EntityEJBHomeHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client) {
        super(ejb, server, client);
    }

    @Override
    protected Object findX(Method method, Object[] args, Object proxy) throws Throwable {
        EJBRequest req = new EJBRequest(9, this.ejb, method, args, null);
        EJBResponse res = this.request(req);
        Object primKey = null;
        EJBObjectHandler handler = null;
        Object[] primaryKeys = null;
        switch (res.getResponseCode()) {
            case 11: {
                throw new SystemError((ThrowableArtifact)res.getResult());
            }
            case 10: {
                throw new SystemException((ThrowableArtifact)res.getResult());
            }
            case 9: {
                throw new ApplicationException((ThrowableArtifact)res.getResult());
            }
            case 6: {
                primKey = res.getResult();
                if (primKey == null) {
                    return null;
                }
                handler = EJBObjectHandler.createEJBObjectHandler(this.ejb, this.server, this.client, primKey);
                handler.setEJBHomeProxy((EJBHomeProxy)proxy);
                EntityEJBHomeHandler.registerHandler(this.ejb.deploymentID + ":" + primKey, handler);
                return handler.createEJBObjectProxy();
            }
            case 7: {
                primaryKeys = (Object[])res.getResult();
                for (int i = 0; i < primaryKeys.length; ++i) {
                    primKey = primaryKeys[i];
                    if (primKey == null) continue;
                    handler = EJBObjectHandler.createEJBObjectHandler(this.ejb, this.server, this.client, primKey);
                    handler.setEJBHomeProxy((EJBHomeProxy)proxy);
                    EntityEJBHomeHandler.registerHandler(this.ejb.deploymentID + ":" + primKey, handler);
                    primaryKeys[i] = handler.createEJBObjectProxy();
                }
                return Arrays.asList(primaryKeys);
            }
            case 20: {
                primaryKeys = (Object[])res.getResult();
                for (int i = 0; i < primaryKeys.length; ++i) {
                    primKey = primaryKeys[i];
                    if (primKey == null) continue;
                    handler = EJBObjectHandler.createEJBObjectHandler(this.ejb, this.server, this.client, primKey);
                    handler.setEJBHomeProxy((EJBHomeProxy)proxy);
                    EntityEJBHomeHandler.registerHandler(this.ejb.deploymentID + ":" + primKey, handler);
                    primaryKeys[i] = handler.createEJBObjectProxy();
                }
                return new ArrayEnumeration(Arrays.asList(primaryKeys));
            }
        }
        throw new RemoteException("Received invalid response code from server: " + res.getResponseCode());
    }

    @Override
    protected Object removeByPrimaryKey(Method method, Object[] args, Object proxy) throws Throwable {
        Object primKey = args[0];
        if (primKey == null) {
            throw new NullPointerException("The primary key is null.");
        }
        EJBRequest req = new EJBRequest(4, this.ejb, method, args, primKey);
        EJBResponse res = this.request(req);
        switch (res.getResponseCode()) {
            case 11: {
                throw new SystemError((ThrowableArtifact)res.getResult());
            }
            case 10: {
                throw new SystemException((ThrowableArtifact)res.getResult());
            }
            case 9: {
                throw new ApplicationException((ThrowableArtifact)res.getResult());
            }
            case 4: {
                EntityEJBHomeHandler.invalidateAllHandlers(this.ejb.deploymentID + ":" + primKey);
                return null;
            }
        }
        throw new RemoteException("Received invalid response code from server: " + res.getResponseCode());
    }

    @Override
    protected Object removeWithHandle(Method method, Object[] args, Object proxy) throws Throwable {
        if (args[0] == null) {
            throw new RemoteException("Handler is null");
        }
        Handle handle = (Handle)args[0];
        EJBObject ejbObject = handle.getEJBObject();
        if (ejbObject == null) {
            throw new NullPointerException("The handle.getEJBObject() is null.");
        }
        Object primKey = ejbObject.getPrimaryKey();
        if (primKey == null) {
            throw new NullPointerException("The handle.getEJBObject().getPrimaryKey() is null.");
        }
        EJBRequest req = new EJBRequest(3, this.ejb, method, args, primKey);
        EJBResponse res = this.request(req);
        switch (res.getResponseCode()) {
            case 11: {
                throw new SystemError((ThrowableArtifact)res.getResult());
            }
            case 10: {
                throw new SystemException((ThrowableArtifact)res.getResult());
            }
            case 9: {
                throw new ApplicationException((ThrowableArtifact)res.getResult());
            }
            case 4: {
                EntityEJBHomeHandler.invalidateAllHandlers(this.ejb.deploymentID + ":" + primKey);
                return null;
            }
        }
        throw new RemoteException("Received invalid response code from server: " + res.getResponseCode());
    }
}

