/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import org.apache.openejb.client.ApplicationException;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.client.EJBHomeHandler;
import org.apache.openejb.client.EJBHomeProxy;
import org.apache.openejb.client.EJBInvocationHandler;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.EJBObjectHandle;
import org.apache.openejb.client.EJBObjectProxy;
import org.apache.openejb.client.EJBObjectProxyHandle;
import org.apache.openejb.client.EJBRequest;
import org.apache.openejb.client.EJBResponse;
import org.apache.openejb.client.EntityEJBObjectHandler;
import org.apache.openejb.client.RequestMethodCode;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.client.SingletonEJBObjectHandler;
import org.apache.openejb.client.StatefulEJBObjectHandler;
import org.apache.openejb.client.StatelessEJBObjectHandler;
import org.apache.openejb.client.SystemError;
import org.apache.openejb.client.SystemException;
import org.apache.openejb.client.ThrowableArtifact;
import org.apache.openejb.client.proxy.InvocationHandler;
import org.apache.openejb.client.proxy.ProxyManager;
import org.apache.openejb.client.util.ClassLoaderUtil;

public abstract class EJBObjectHandler
extends EJBInvocationHandler {
    protected static final Method GETEJBHOME = EJBObjectHandler.getMethod(EJBObject.class, "getEJBHome", null);
    protected static final Method GETHANDLE = EJBObjectHandler.getMethod(EJBObject.class, "getHandle", null);
    protected static final Method GETPRIMARYKEY = EJBObjectHandler.getMethod(EJBObject.class, "getPrimaryKey", null);
    protected static final Method ISIDENTICAL = EJBObjectHandler.getMethod(EJBObject.class, "isIdentical", EJBObject.class);
    protected static final Method REMOVE = EJBObjectHandler.getMethod(EJBObject.class, "remove", null);
    protected static final Method GETHANDLER = EJBObjectHandler.getMethod(EJBObjectProxy.class, "getEJBObjectHandler", null);
    protected static final Method CANCEL = EJBObjectHandler.getMethod(Future.class, "cancel", Boolean.TYPE);
    private static final int threads = Integer.parseInt(System.getProperty("openejb.client.invoker.threads", "10"));
    private static final int queue = Integer.parseInt(System.getProperty("openejb.client.invoker.queue", "2"));
    private static final LinkedBlockingQueue<Runnable> blockingQueue = new LinkedBlockingQueue(queue < 2 ? 2 : queue);
    protected static final ThreadPoolExecutor executorService = new ThreadPoolExecutor(3, threads < 3 ? 3 : threads, 1L, TimeUnit.MINUTES, blockingQueue);
    public Object registryId;
    EJBHomeProxy ejbHome = null;

    public EJBObjectHandler() {
    }

    public EJBObjectHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client) {
        super(ejb, server, client);
    }

    public EJBObjectHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client, Object primaryKey) {
        super(ejb, server, client, primaryKey);
    }

    protected void setEJBHomeProxy(EJBHomeProxy ejbHome) {
        this.ejbHome = ejbHome;
    }

    public static EJBObjectHandler createEJBObjectHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client, Object primaryKey) {
        switch (ejb.type) {
            case 8: 
            case 9: {
                return new EntityEJBObjectHandler(ejb, server, client, primaryKey);
            }
            case 6: {
                return new StatefulEJBObjectHandler(ejb, server, client, primaryKey);
            }
            case 7: {
                return new StatelessEJBObjectHandler(ejb, server, client, primaryKey);
            }
            case 10: {
                return new SingletonEJBObjectHandler(ejb, server, client, primaryKey);
            }
        }
        throw new IllegalStateException("Uknown bean type code '" + ejb.type + "' : " + ejb.toString());
    }

    public abstract Object getRegistryId();

    public EJBObjectProxy createEJBObjectProxy() {
        EJBObjectProxy ejbObject = null;
        try {
            ArrayList<Class<EJBObjectProxy>> interfaces = new ArrayList<Class<EJBObjectProxy>>();
            if (this.ejb.remoteClass != null) {
                interfaces.add(this.ejb.remoteClass);
            } else if (this.ejb.businessClasses.size() > 0) {
                interfaces.addAll(this.ejb.businessClasses);
            }
            interfaces.add(EJBObjectProxy.class);
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            boolean parent = ClassLoaderUtil.isParent(this.getClass().getClassLoader(), oldCl);
            if (!parent) {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            ejbObject = (EJBObjectProxy)ProxyManager.newProxyInstance(interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)this);
            if (!parent) {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return ejbObject;
    }

    @Override
    public Object _invoke(Object p, Method m, Object[] a) throws Throwable {
        try {
            if (m.getDeclaringClass().equals(Object.class)) {
                if (m.equals(TOSTRING)) {
                    return "proxy=" + this;
                }
                if (m.equals(EQUALS)) {
                    return this.equals(m, a, p);
                }
                if (m.equals(HASHCODE)) {
                    return this.hashCode();
                }
                throw new UnsupportedOperationException("Unkown method: " + m);
            }
            if (m.getDeclaringClass() == EJBObjectProxy.class) {
                if (m.equals(GETHANDLER)) {
                    return this;
                }
                if (m.getName().equals("writeReplace")) {
                    return new EJBObjectProxyHandle(this);
                }
                if (m.getName().equals("readResolve")) {
                    return null;
                }
                throw new UnsupportedOperationException("Unkown method: " + m);
            }
            if (m.getDeclaringClass() == EJBObject.class) {
                if (m.equals(GETHANDLE)) {
                    return this.getHandle(m, a, p);
                }
                if (m.equals(GETPRIMARYKEY)) {
                    return this.getPrimaryKey(m, a, p);
                }
                if (m.equals(ISIDENTICAL)) {
                    return this.isIdentical(m, a, p);
                }
                if (m.equals(GETEJBHOME)) {
                    return this.getEJBHome(m, a, p);
                }
                if (m.equals(REMOVE)) {
                    return this.remove(m, a, p);
                }
                throw new UnsupportedOperationException("Unkown method: " + m);
            }
            return this.businessMethod(m, a, p);
        }
        catch (SystemException e) {
            EJBObjectHandler.invalidateAllHandlers(this.getRegistryId());
            throw this.convertException(EJBObjectHandler.getCause(e), m);
        }
        catch (ApplicationException ae) {
            throw this.convertException(EJBObjectHandler.getCause(ae), m);
        }
        catch (SystemError se) {
            this.invalidateReference();
            if (this.remote) {
                throw new RemoteException("Container has suffered a SystemException", EJBObjectHandler.getCause(se));
            }
            throw new EJBException("Container has suffered a SystemException").initCause(EJBObjectHandler.getCause(se));
        }
        catch (Throwable throwable) {
            if (this.remote) {
                if (throwable instanceof RemoteException) {
                    throw throwable;
                }
                throw new RemoteException("Unknown Container Exception: " + throwable.getClass().getName() + ": " + throwable.getMessage(), EJBObjectHandler.getCause(throwable));
            }
            if (throwable instanceof EJBException) {
                throw throwable;
            }
            throw new EJBException("Unknown Container Exception: " + throwable.getClass().getName() + ": " + throwable.getMessage()).initCause(EJBObjectHandler.getCause(throwable));
        }
    }

    protected Object getEJBHome(Method method, Object[] args, Object proxy) throws Throwable {
        if (this.ejbHome == null) {
            this.ejbHome = EJBHomeHandler.createEJBHomeHandler(this.ejb, this.server, this.client).createEJBHomeProxy();
        }
        return this.ejbHome;
    }

    protected Object getHandle(Method method, Object[] args, Object proxy) throws Throwable {
        return new EJBObjectHandle((EJBObjectProxy)proxy);
    }

    protected abstract Object getPrimaryKey(Method var1, Object[] var2, Object var3) throws Throwable;

    protected abstract Object isIdentical(Method var1, Object[] var2, Object var3) throws Throwable;

    protected abstract Object equals(Method var1, Object[] var2, Object var3) throws Throwable;

    protected abstract Object remove(Method var1, Object[] var2, Object var3) throws Throwable;

    protected Object businessMethod(Method method, Object[] args, Object proxy) throws Throwable {
        if (this.ejb.isAsynchronousMethod(method)) {
            try {
                String requestId = UUID.randomUUID().toString();
                EJBResponse response = new EJBResponse();
                AsynchronousCall asynchronousCall = new AsynchronousCall(method, args, proxy, requestId, response);
                return new FutureAdapter(executorService.submit(asynchronousCall), response, requestId);
            }
            catch (RejectedExecutionException e) {
                throw new EJBException("failed to allocate internal resource to execute the target task", (Exception)e);
            }
        }
        return this._businessMethod(method, args, proxy, null);
    }

    private Object _businessMethod(Method method, Object[] args, Object proxy, String requestId) throws Throwable {
        EJBRequest req = new EJBRequest(RequestMethodCode.EJB_OBJECT_BUSINESS_METHOD, this.ejb, method, args, this.primaryKey);
        req.getBody().setRequestId(requestId);
        EJBResponse res = this.request(req);
        return this._handleBusinessMethodResponse(res);
    }

    private Object _businessMethod(Method method, Object[] args, Object proxy, String requestId, EJBResponse response) throws Throwable {
        EJBRequest req = new EJBRequest(RequestMethodCode.EJB_OBJECT_BUSINESS_METHOD, this.ejb, method, args, this.primaryKey);
        req.getBody().setRequestId(requestId);
        EJBResponse res = this.request(req, response);
        return this._handleBusinessMethodResponse(res);
    }

    private Object _handleBusinessMethodResponse(EJBResponse res) throws Throwable {
        switch (res.getResponseCode()) {
            case 11: {
                throw new SystemError((ThrowableArtifact)res.getResult());
            }
            case 10: {
                throw new SystemException((ThrowableArtifact)res.getResult());
            }
            case 9: {
                throw new ApplicationException((ThrowableArtifact)res.getResult());
            }
            case 4: {
                return res.getResult();
            }
        }
        throw new RemoteException("Received invalid response code from server: " + res.getResponseCode());
    }

    static {
        executorService.setThreadFactory(new ThreadFactory(){
            private final AtomicInteger i = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "OpenEJB.Client." + this.i.incrementAndGet());
                t.setDaemon(true);
                t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        Logger.getLogger(EJBObjectHandler.class.getName()).log(Level.SEVERE, "Uncaught error in: " + t.getName(), e);
                    }
                });
                return t;
            }
        });
        executorService.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor tpe) {
                if (null == r || null == tpe || tpe.isShutdown() || tpe.isTerminated() || tpe.isTerminating()) {
                    return;
                }
                Logger log = Logger.getLogger(EJBObjectHandler.class.getName());
                if (log.isLoggable(Level.WARNING)) {
                    log.log(Level.WARNING, "EJBObjectHandler ExecutorService at capicity for process: " + r);
                }
                boolean offer = false;
                try {
                    offer = tpe.getQueue().offer(r, 10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!offer) {
                    log.log(Level.SEVERE, "EJBObjectHandler ExecutorService failed to run asynchronous process: " + r);
                }
            }
        });
    }

    private class FutureAdapter<T>
    implements Future<T> {
        private Future<T> target;
        private String requestId;
        private EJBResponse response;
        private volatile boolean canceled;
        private AtomicBoolean lastMayInterruptIfRunningValue = new AtomicBoolean(false);

        public FutureAdapter(Future<T> target, EJBResponse response, String requestId) {
            this.target = target;
            this.requestId = requestId;
            this.response = response;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.canceled) {
                return true;
            }
            if (blockingQueue.remove(this.target)) {
                this.canceled = true;
                return true;
            }
            if (this.target.isDone()) return false;
            if (this.lastMayInterruptIfRunningValue.getAndSet(mayInterruptIfRunning) == mayInterruptIfRunning) {
                return false;
            }
            EJBRequest req = new EJBRequest(RequestMethodCode.FUTURE_CANCEL, EJBObjectHandler.this.ejb, CANCEL, new Object[]{mayInterruptIfRunning}, EJBObjectHandler.this.primaryKey);
            req.getBody().setRequestId(this.requestId);
            try {
                EJBResponse res = EJBObjectHandler.this.request(req);
                if (res.getResponseCode() == 4) return false;
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            if (this.canceled) {
                throw new CancellationException();
            }
            return this.target.get();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.canceled) {
                throw new CancellationException();
            }
            return this.target.get(timeout, unit);
        }

        @Override
        public boolean isCancelled() {
            return this.canceled;
        }

        @Override
        public boolean isDone() {
            if (this.canceled) {
                return false;
            }
            return this.target.isDone();
        }
    }

    private class AsynchronousCall
    implements Callable {
        private Method method;
        private Object[] args;
        private Object proxy;
        private String requestId;
        private EJBResponse response;

        public AsynchronousCall(Method method, Object[] args, Object proxy, String requestId, EJBResponse response) {
            this.method = method;
            this.args = args;
            this.proxy = proxy;
            this.requestId = requestId;
            this.response = response;
        }

        public Object call() throws Exception {
            try {
                return EJBObjectHandler.this._businessMethod(this.method, this.args, this.proxy, this.requestId, this.response);
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable error) {
                throw new SystemException(error);
            }
        }
    }
}

