/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf;

import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.naming.Context;
import org.apache.cxf.Bus;
import org.apache.openejb.BeanContext;
import org.apache.openejb.assembler.classic.util.ServiceConfiguration;
import org.apache.openejb.core.webservices.PortData;
import org.apache.openejb.server.cxf.CxfCatalogUtils;
import org.apache.openejb.server.cxf.CxfWsContainer;
import org.apache.openejb.server.cxf.client.SaajInterceptor;
import org.apache.openejb.server.cxf.ejb.EjbWsContainer;
import org.apache.openejb.server.cxf.pojo.PojoWsContainer;
import org.apache.openejb.server.cxf.transport.util.CxfUtil;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.webservices.WsService;

public class CxfService
extends WsService {
    public static final String OPENEJB_JAXWS_CXF_FEATURES = "features";
    private final Map<String, CxfWsContainer> wsContainers = new TreeMap<String, CxfWsContainer>();

    public CxfService() {
        SaajInterceptor.registerInterceptors();
    }

    public String getName() {
        return "cxf";
    }

    public void init(Properties props) throws Exception {
        super.init(props);
        CxfUtil.configureBus();
    }

    protected HttpListener createEjbWsContainer(URL moduleBaseUrl, PortData port, BeanContext beanContext, ServiceConfiguration config) {
        Bus bus = CxfUtil.getBus();
        CxfCatalogUtils.loadOASISCatalog(bus, moduleBaseUrl, "META-INF/jax-ws-catalog.xml");
        EjbWsContainer container = new EjbWsContainer(bus, port, beanContext, config);
        container.start();
        this.wsContainers.put(beanContext.getDeploymentID().toString(), container);
        return container;
    }

    protected void destroyEjbWsContainer(String deploymentId) {
        CxfWsContainer container = this.wsContainers.remove(deploymentId);
        if (container != null) {
            container.destroy();
        }
    }

    protected HttpListener createPojoWsContainer(URL moduleBaseUrl, PortData port, String serviceId, Class target, Context context, String contextRoot, Map<String, Object> bdgs, ServiceConfiguration services) {
        Bus bus = CxfUtil.getBus();
        CxfCatalogUtils.loadOASISCatalog(bus, moduleBaseUrl, "META-INF/jax-ws-catalog.xml");
        PojoWsContainer container = new PojoWsContainer(bus, port, context, target, bdgs, services);
        container.start();
        this.wsContainers.put(serviceId, container);
        return container;
    }

    protected void destroyPojoWsContainer(String serviceId) {
        CxfWsContainer container = this.wsContainers.remove(serviceId);
        if (container != null) {
            container.destroy();
        }
    }
}

