/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.openejb.assembler.classic.util.ServiceConfiguration;
import org.apache.openejb.core.webservices.PortData;
import org.apache.openejb.server.cxf.CxfEndpoint;
import org.apache.openejb.server.cxf.transport.HttpTransportFactory;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpResponse;

public abstract class CxfWsContainer
implements HttpListener {
    protected final Bus bus;
    protected final PortData port;
    protected AbstractHTTPDestination destination;
    protected CxfEndpoint endpoint;
    protected final HTTPTransportFactory httpTransportFactory;
    protected final ServiceConfiguration serviceConfiguration;

    public CxfWsContainer(Bus bus, PortData port, ServiceConfiguration config) {
        this.bus = bus;
        this.port = port;
        this.serviceConfiguration = config;
        ArrayList<String> ids = new ArrayList<String>();
        ids.add("http://schemas.xmlsoap.org/wsdl/soap/");
        this.httpTransportFactory = new HttpTransportFactory(bus);
        this.httpTransportFactory.setTransportIds(ids);
    }

    public void start() {
        this.endpoint = this.createEndpoint();
        this.endpoint.publish("http://nopath");
        this.destination = (AbstractHTTPDestination)this.endpoint.getServer().getDestination();
    }

    protected abstract CxfEndpoint createEndpoint();

    public void destroy() {
        if (this.endpoint != null) {
            this.endpoint.stop();
            this.endpoint = null;
        }
    }

    public void onMessage(HttpRequest request, HttpResponse response) throws Exception {
        this.destination.invoke(null, request.getServletContext(), (HttpServletRequest)request, (HttpServletResponse)response);
    }
}

