/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ejbd;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import org.apache.openejb.client.AuthenticationRequest;
import org.apache.openejb.client.AuthenticationResponse;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ejbd.EjbDaemon;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Messages;

class AuthRequestHandler {
    Messages _messages = new Messages("org.apache.openejb.server.util.resources");
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER_REMOTE.createChild("auth"), (String)"org.apache.openejb.server.util.resources");

    AuthRequestHandler(EjbDaemon daemon) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(ObjectInputStream in, ObjectOutputStream out) {
        AuthenticationRequest req = new AuthenticationRequest();
        AuthenticationResponse res = new AuthenticationResponse();
        try {
            req.readExternal((ObjectInput)in);
            String securityRealm = req.getRealm();
            String username = req.getUsername();
            String password = req.getCredentials();
            SecurityService securityService = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
            Object token = securityService.login(securityRealm, username, password);
            ClientMetaData client = new ClientMetaData();
            client.setClientIdentity(token);
            res.setIdentity(client);
            res.setResponseCode(1);
        }
        catch (Throwable t) {
            res.setResponseCode(3);
            res.setDeniedCause(t);
        }
        finally {
            if (logger.isDebugEnabled()) {
                try {
                    logger.debug("AUTH REQUEST: " + req + " -- RESPONSE: " + res);
                }
                catch (Exception justInCase) {}
            }
            try {
                res.writeExternal((ObjectOutput)out);
            }
            catch (IOException ie) {
                logger.fatal("Couldn't write AuthenticationResponse to output stream", (Throwable)ie);
            }
        }
    }
}

