/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.openejb.core.security.jaas.UserPrincipal;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpSession;
import org.apache.openejb.server.httpd.HttpSessionImpl;
import org.apache.openejb.server.httpd.OpenEJBHttpServer;
import org.apache.openejb.server.httpd.ServletByteArrayIntputStream;
import org.apache.openejb.util.ArrayEnumeration;
import org.apache.openejb.util.Logger;

public class HttpRequestImpl
implements HttpRequest {
    private static final String FORM_URL_ENCODED = "application/x-www-form-urlencoded";
    private static final String TRANSFER_ENCODING = "Transfer-Encoding";
    private static final String CHUNKED = "chunked";
    protected static final String EJBSESSIONID = "EJBSESSIONID";
    private String method;
    private URI uri;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Map<String, String> formParams = new HashMap<String, String>();
    private final Map<String, String> queryParams = new HashMap<String, String>();
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final Map<String, Part> parts = new HashMap<String, Part>();
    private Map<String, String> cookies;
    private byte[] body;
    private ServletByteArrayIntputStream in;
    private int length;
    private String contentType;
    private final URI socketURI;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private String path = "/";
    private Locale locale = Locale.getDefault();
    private HttpSession session;
    private String encoding = "UTF-8";

    public HttpRequestImpl(URI socketURI) {
        this.socketURI = socketURI;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Enumeration<String> getHeaderNames() {
        return new ArrayEnumeration(new ArrayList<String>(this.headers.keySet()));
    }

    public Enumeration<String> getHeaders(String s) {
        return new ArrayEnumeration(Arrays.asList(this.headers.get(s)));
    }

    public int getIntHeader(String s) {
        return Integer.parseInt(s);
    }

    public String getFormParameter(String name) {
        return this.formParams.get(name);
    }

    public Map<String, String> getFormParameters() {
        return new HashMap<String, String>(this.formParams);
    }

    public Map<String, String> getQueryParameters() {
        return new HashMap<String, String>(this.queryParams);
    }

    public String getQueryParameter(String name) {
        return this.queryParams.get(name);
    }

    public String getMethod() {
        return this.method;
    }

    public Part getPart(String s) throws IOException, ServletException {
        return this.parts.get(s);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.parts.values();
    }

    public String getPathInfo() {
        return this.path;
    }

    public String getPathTranslated() {
        return this.path;
    }

    public String getQueryString() {
        StringBuilder str = new StringBuilder("");
        for (Map.Entry<String, String> q : this.queryParams.entrySet()) {
            str.append(q.getKey()).append("=").append(q.getValue()).append("&");
        }
        String out = str.toString();
        if (out.isEmpty()) {
            return out;
        }
        return out.substring(0, out.length() - 1);
    }

    public String getRemoteUser() {
        return null;
    }

    public String getRequestedSessionId() {
        return this.session.getId();
    }

    public String getRequestURI() {
        return this.getURI().toString();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.getRequestURI());
    }

    public String getServletPath() {
        return this.getPathInfo();
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public int getContentLength() {
        return this.length;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.REQUEST;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.in;
    }

    public String getLocalAddr() {
        return this.getURI().getHost();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration<Locale> getLocales() {
        return new ArrayEnumeration(Arrays.asList(Locale.getAvailableLocales()));
    }

    public String getLocalName() {
        return this.locale.getLanguage();
    }

    public int getLocalPort() {
        return this.getURI().getPort();
    }

    protected void readMessage(InputStream input) throws IOException {
        DataInputStream in = new DataInputStream(input);
        this.readRequestLine(in);
        this.readHeaders(in);
        this.readBody(in);
        this.parameters.putAll(this.getFormParameters());
        this.parameters.putAll(this.getQueryParameters());
    }

    public void print(Logger log, boolean formatXml) {
        if (log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("******************* REQUEST ******************\n");
            builder.append(this.method + " " + this.uri).append("\n");
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                builder.append(entry).append("\n");
            }
            builder.append("\n");
            String text = new String(this.body);
            if (formatXml && OpenEJBHttpServer.isTextXml(this.headers)) {
                builder.append(OpenEJBHttpServer.reformat(text)).append("\n");
            } else {
                builder.append(text).append("\n");
            }
            builder.append("**********************************************").append("\n");
            log.debug(builder.toString());
        }
    }

    private void readRequestLine(DataInput in) throws IOException {
        String line;
        try {
            line = in.readLine();
        }
        catch (Exception e) {
            throw new IOException("Could not read the HTTP Request Line :" + e.getClass().getName() + " : " + e.getMessage());
        }
        StringTokenizer lineParts = new StringTokenizer(line, " ");
        this.parseMethod(lineParts);
        this.parseURI(lineParts);
    }

    private void parseMethod(StringTokenizer lineParts) throws IOException {
        String token;
        try {
            token = lineParts.nextToken();
        }
        catch (Exception e) {
            throw new IOException("Could not parse the HTTP Request Method :" + e.getClass().getName() + " : " + e.getMessage());
        }
        if (token.equalsIgnoreCase("GET")) {
            this.method = HttpRequest.Method.GET.name();
        } else if (token.equalsIgnoreCase("POST")) {
            this.method = HttpRequest.Method.POST.name();
        } else if (token.equalsIgnoreCase("PUT")) {
            this.method = HttpRequest.Method.PUT.name();
        } else if (token.equalsIgnoreCase("DELETE")) {
            this.method = HttpRequest.Method.DELETE.name();
        } else if (token.equalsIgnoreCase("HEAD")) {
            this.method = HttpRequest.Method.HEAD.name();
        } else {
            this.method = HttpRequest.Method.UNSUPPORTED.name();
            throw new IOException("Unsupported HTTP Request Method :" + token);
        }
    }

    private void parseURI(StringTokenizer lineParts) throws IOException {
        String token;
        try {
            token = lineParts.nextToken();
        }
        catch (Exception e) {
            throw new IOException("Could not parse the HTTP Request Method :" + e.getClass().getName() + " : " + e.getMessage());
        }
        try {
            this.uri = new URI(this.socketURI.toString() + token);
        }
        catch (URISyntaxException e) {
            throw new IOException("Malformed URI :" + token + " Exception: " + e.getMessage());
        }
        this.parseQueryParams(this.uri.getQuery());
    }

    private void parseQueryParams(String query) {
        if (query == null) {
            return;
        }
        StringTokenizer parameters = new StringTokenizer(query, "&");
        while (parameters.hasMoreTokens()) {
            String name;
            StringTokenizer param = new StringTokenizer(parameters.nextToken(), "=");
            if (!param.hasMoreTokens() || (name = URLDecoder.decode(param.nextToken())) == null) continue;
            String value = !param.hasMoreTokens() ? "" : URLDecoder.decode(param.nextToken());
            this.queryParams.put(name, value);
        }
    }

    private void readHeaders(DataInput in) throws IOException {
        while (true) {
            String value;
            int colonIndex;
            String name;
            String hf;
            try {
                hf = in.readLine();
            }
            catch (Exception e) {
                throw new IOException("Could not read the HTTP Request Header Field :" + e.getClass().getName() + " : " + e.getMessage());
            }
            if (hf == null || hf.equals("") || (name = hf.substring(0, colonIndex = hf.indexOf(58))) == null || (value = hf.substring(colonIndex + 1, hf.length())) == null) break;
            value = value.trim();
            this.headers.put(name, value);
        }
        String host = this.headers.get("Host");
        if (host != null) {
            String hostName;
            int port = this.uri.getPort();
            int idx = host.indexOf(":");
            if (idx >= 0) {
                hostName = host.substring(0, idx);
                try {
                    port = Integer.parseInt(host.substring(idx + 1));
                }
                catch (NumberFormatException ignore) {}
            } else {
                hostName = host;
            }
            try {
                this.uri = new URI(this.uri.getScheme(), this.uri.getUserInfo(), hostName, port, this.uri.getPath(), this.uri.getQuery(), this.uri.getFragment());
            }
            catch (URISyntaxException ignore) {
                // empty catch block
            }
        }
    }

    private boolean hasBody() {
        return !this.method.equals(HttpRequest.Method.GET.name()) && !this.method.equals(HttpRequest.Method.DELETE.name());
    }

    private void readBody(DataInput in) throws IOException {
        this.length = this.parseContentLength();
        this.contentType = this.getHeader("Content-Type");
        if (this.hasBody() && FORM_URL_ENCODED.equals(this.contentType)) {
            StringTokenizer param;
            String name;
            String rawParams;
            try {
                this.body = this.readContent(in);
                rawParams = new String(this.body);
            }
            catch (Exception e) {
                throw (IOException)new IOException("Could not read the HTTP Request Body: " + e.getMessage()).initCause(e);
            }
            StringTokenizer parameters = new StringTokenizer(rawParams, "&");
            while (parameters.hasMoreTokens() && (name = URLDecoder.decode((param = new StringTokenizer(parameters.nextToken(), "=")).nextToken(), "UTF-8")) != null) {
                String value = param.hasMoreTokens() ? URLDecoder.decode(param.nextToken(), "UTF-8") : "";
                if (value == null) {
                    value = "";
                }
                this.formParams.put(name, value);
            }
        } else if (this.hasBody() && CHUNKED.equals(this.headers.get(TRANSFER_ENCODING))) {
            try {
                String sizeString;
                int size;
                ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
                String line = in.readLine();
                while (line != null && (size = Integer.parseInt(sizeString = line.split(";", 2)[0], 16)) != 0) {
                    byte[] chunk = new byte[size];
                    in.readFully(chunk);
                    out.write(chunk);
                    in.readLine();
                    line = in.readLine();
                }
                this.body = out.toByteArray();
                this.in = new ServletByteArrayIntputStream(this.body);
            }
            catch (Exception e) {
                throw (IOException)new IOException("Unable to read chunked body").initCause(e);
            }
        } else if (this.hasBody()) {
            this.body = this.readContent(in);
            this.in = new ServletByteArrayIntputStream(this.body);
        } else {
            this.body = new byte[0];
            this.in = new ServletByteArrayIntputStream(this.body);
        }
        this.session = new HttpSessionImpl();
    }

    private byte[] readContent(DataInput in) throws IOException {
        if (this.length >= 0) {
            byte[] body = new byte[this.length];
            in.readFully(body);
            return body;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        try {
            boolean atLineStart = true;
            while (true) {
                byte b;
                if ((b = in.readByte()) == 13) {
                    out.write(b);
                    b = in.readByte();
                }
                if (b == 10) {
                    if (atLineStart) break;
                    atLineStart = true;
                } else {
                    atLineStart = false;
                }
                out.write(b);
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
        byte[] body = out.toByteArray();
        return body;
    }

    private int parseContentLength() {
        String len = this.getHeader("Content-Length");
        int length = -1;
        if (len != null) {
            try {
                length = Integer.parseInt(len);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return length;
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        return true;
    }

    public String getAuthType() {
        return "BASIC";
    }

    public String getContextPath() {
        return this.path;
    }

    public Cookie[] getCookies() {
        if (this.cookies != null) {
            return this.toCookies(this.cookies);
        }
        this.cookies = new HashMap<String, String>();
        String cookieHeader = this.getHeader("Cookie");
        if (cookieHeader == null) {
            return this.toCookies(this.cookies);
        }
        StringTokenizer tokens = new StringTokenizer(cookieHeader, ";");
        while (tokens.hasMoreTokens()) {
            StringTokenizer token = new StringTokenizer(tokens.nextToken(), "=");
            String name = token.nextToken();
            String value = token.nextToken();
            this.cookies.put(name, value);
        }
        return this.toCookies(this.cookies);
    }

    protected Map<?, ?> getInternalCookies() {
        if (this.cookies != null) {
            return this.cookies;
        }
        this.cookies = new HashMap<String, String>();
        String cookieHeader = this.getHeader("Cookie");
        if (cookieHeader == null) {
            return this.cookies;
        }
        StringTokenizer tokens = new StringTokenizer(cookieHeader, ";");
        while (tokens.hasMoreTokens()) {
            StringTokenizer token = new StringTokenizer(tokens.nextToken(), "=");
            String name = token.nextToken();
            String value = token.nextToken();
            this.cookies.put(name, value);
        }
        return this.cookies;
    }

    private Cookie[] toCookies(Map<String, String> cookies) {
        Cookie[] out = new Cookie[cookies.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : cookies.entrySet()) {
            out[i++] = new Cookie(entry.getKey(), entry.getValue());
        }
        return out;
    }

    public long getDateHeader(String s) {
        return Long.parseLong(s);
    }

    protected String getCookie(String name) {
        return (String)this.getInternalCookies().get(name);
    }

    public HttpSession getSession(boolean create) {
        return this.session;
    }

    protected URI getSocketURI() {
        return this.socketURI;
    }

    public Principal getUserPrincipal() {
        return new UserPrincipal("");
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isUserInRole(String s) {
        return true;
    }

    public void login(String s, String s1) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new ArrayEnumeration(new ArrayList<String>(this.attributes.keySet()));
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
        this.encoding = s;
    }

    public AsyncContext startAsync() {
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
        return null;
    }

    @Override
    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        for (Map.Entry<String, String> p : this.parameters.entrySet()) {
            params.put(p.getKey(), new String[]{p.getValue()});
        }
        return params;
    }

    public Enumeration<String> getParameterNames() {
        return new ArrayEnumeration(new ArrayList<String>(this.parameters.keySet()));
    }

    public String[] getParameterValues(String s) {
        return new String[]{this.parameters.get(s)};
    }

    public String getProtocol() {
        return this.uri.getScheme();
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRealPath(String s) {
        return this.path;
    }

    @Override
    public Map<String, String> getParameters() {
        return new HashMap<String, String>(this.parameters);
    }

    @Override
    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return this.getURI().getHost();
    }

    public int getRemotePort() {
        return this.getURI().getPort();
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return null;
    }

    public String getScheme() {
        return this.getURI().getScheme();
    }

    public String getServerName() {
        return this.getURI().getHost();
    }

    public int getServerPort() {
        return this.getURI().getPort();
    }

    public ServletContext getServletContext() {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public boolean isSecure() {
        return false;
    }

    public void removeAttribute(String s) {
        this.attributes.remove(s);
    }
}

