/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpListenerRegistry;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpRequestImpl;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.httpd.ServletRequestAdapter;

public class FilterListener
implements HttpListener {
    private final String context;
    private final Filter delegate;

    public FilterListener(Filter filter, String contextRoot) {
        this.delegate = filter;
        this.context = contextRoot;
    }

    @Override
    public void onMessage(HttpRequest request, HttpResponse response) throws Exception {
        HttpServletRequest delegate;
        HttpRequestImpl req = null;
        if (request instanceof HttpRequestImpl) {
            req = (HttpRequestImpl)request;
        } else if (request instanceof ServletRequestAdapter && (delegate = ((ServletRequestAdapter)request).getRequest()) instanceof HttpRequestImpl) {
            req = (HttpRequestImpl)delegate;
        }
        if (req != null) {
            req.initPathFromContext(this.context);
        }
        this.delegate.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)new SimpleFilterChain(this));
    }

    public Filter getDelegate() {
        return this.delegate;
    }

    private static class SimpleFilterChain
    implements FilterChain {
        private final FilterListener origin;

        private SimpleFilterChain(FilterListener origin) {
            this.origin = origin;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            HttpListenerRegistry registry = (HttpListenerRegistry)SystemInstance.get().getComponent(HttpListenerRegistry.class);
            registry.setOrigin(this.origin);
            try {
                registry.onMessage((HttpRequest)request, (HttpResponse)response);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            finally {
                registry.setOrigin(this.origin);
            }
        }
    }
}

