/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.beans;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DatabaseBean
implements SessionBean {
    private static final long serialVersionUID = 1L;
    public SessionContext context;
    public InitialContext jndiContext;

    public DatabaseBean() {
        this.getClass();
    }

    public void ejbCreate() throws CreateException {
        try {
            this.jndiContext = new InitialContext();
        }
        catch (Exception e) {
            throw new EJBException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(String statement) throws SQLException {
        try {
            DataSource ds = (DataSource)this.jndiContext.lookup("java:comp/env/database");
            Connection con = ds.getConnection();
            try {
                PreparedStatement stmt = con.prepareStatement(statement);
                try {
                    stmt.executeQuery();
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                con.close();
            }
        }
        catch (Exception e) {
            throw new EJBException("Cannot execute the statement: " + statement + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String statement) throws SQLException {
        boolean retval;
        Connection con = null;
        try {
            DataSource ds = (DataSource)this.jndiContext.lookup("java:comp/env/database");
            con = ds.getConnection();
            Statement stmt = con.createStatement();
            try {
                retval = stmt.execute(statement);
            }
            finally {
                stmt.close();
            }
        }
        catch (NamingException e) {
            throw new EJBException("Cannot lookup the Database bean." + e.getMessage());
        }
        finally {
            if (con != null) {
                con.close();
            }
        }
        return retval;
    }

    public void ejbPassivate() {
    }

    public void ejbActivate() {
    }

    public void ejbRemove() {
    }

    public void setSessionContext(SessionContext cntx) {
        this.context = cntx;
    }
}

