/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmp;

import java.rmi.RemoteException;
import java.util.StringTokenizer;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import junit.framework.AssertionFailedError;
import org.apache.openejb.test.TestFailureException;
import org.apache.openejb.test.entity.cmp.BasicCmpHome;
import org.apache.openejb.test.entity.cmp.BasicCmpObject;
import org.apache.openejb.test.stateful.BasicStatefulBusinessLocal;
import org.apache.openejb.test.stateful.BasicStatefulBusinessRemote;
import org.apache.openejb.test.stateful.BasicStatefulHome;
import org.apache.openejb.test.stateful.BasicStatefulObject;
import org.apache.openejb.test.stateless.BasicStatelessBusinessLocal;
import org.apache.openejb.test.stateless.BasicStatelessBusinessRemote;
import org.apache.openejb.test.stateless.BasicStatelessHome;
import org.apache.openejb.test.stateless.BasicStatelessObject;
import org.junit.Assert;

public class ContextLookupCmpBean
implements EntityBean {
    private static int nextId;
    public int primaryKey;
    public String firstName;
    public String lastName;
    public EntityContext ejbContext;

    public Integer ejbCreate(String name) throws CreateException {
        this.primaryKey = nextId++;
        StringTokenizer st = new StringTokenizer(name, " ");
        this.firstName = st.nextToken();
        this.lastName = st.nextToken();
        return null;
    }

    public void ejbPostCreate(String name) throws CreateException {
    }

    public void lookupEntityBean() throws TestFailureException {
        try {
            try {
                BasicCmpHome home = (BasicCmpHome)this.ejbContext.lookup("entity/cmp/beanReferences/cmp_entity");
                Assert.assertNotNull((String)"The EJBHome looked up is null", (Object)home);
                BasicCmpObject object = home.createObject("Enc Bean");
                Assert.assertNotNull((String)"The EJBObject is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatefulBean() throws TestFailureException {
        try {
            try {
                BasicStatefulHome home = (BasicStatefulHome)this.ejbContext.lookup("entity/cmp/beanReferences/stateful");
                Assert.assertNotNull((String)"The EJBHome looked up is null", (Object)home);
                BasicStatefulObject object = home.createObject("Enc Bean");
                Assert.assertNotNull((String)"The EJBObject is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatelessBean() throws TestFailureException {
        try {
            try {
                BasicStatelessHome home = (BasicStatelessHome)this.ejbContext.lookup("entity/cmp/beanReferences/stateless");
                Assert.assertNotNull((String)"The EJBHome looked up is null", (Object)home);
                BasicStatelessObject object = home.createObject();
                Assert.assertNotNull((String)"The EJBObject is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatelessBusinessLocal() throws TestFailureException {
        try {
            try {
                BasicStatelessBusinessLocal object = (BasicStatelessBusinessLocal)this.ejbContext.lookup("entity/cmp/beanReferences/stateless-business-local");
                Assert.assertNotNull((String)"The EJB BusinessLocal is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatelessBusinessRemote() throws TestFailureException {
        try {
            try {
                BasicStatelessBusinessRemote object = (BasicStatelessBusinessRemote)this.ejbContext.lookup("entity/cmp/beanReferences/stateless-business-remote");
                Assert.assertNotNull((String)"The EJB BusinessRemote is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatefulBusinessLocal() throws TestFailureException {
        try {
            try {
                BasicStatefulBusinessLocal object = (BasicStatefulBusinessLocal)this.ejbContext.lookup("entity/cmp/beanReferences/stateful-business-local");
                Assert.assertNotNull((String)"The EJB BusinessLocal is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatefulBusinessRemote() throws TestFailureException {
        try {
            try {
                BasicStatefulBusinessRemote object = (BasicStatefulBusinessRemote)this.ejbContext.lookup("entity/cmp/beanReferences/stateful-business-remote");
                Assert.assertNotNull((String)"The EJB BusinessRemote is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStringEntry() throws TestFailureException {
        try {
            try {
                String expected = new String("1");
                String actual = (String)this.ejbContext.lookup("entity/cmp/references/String");
                Assert.assertNotNull((String)"The String looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupDoubleEntry() throws TestFailureException {
        try {
            try {
                Double expected = new Double(1.0);
                Double actual = (Double)this.ejbContext.lookup("entity/cmp/references/Double");
                Assert.assertNotNull((String)"The Double looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupLongEntry() throws TestFailureException {
        try {
            try {
                Long expected = new Long(1L);
                Long actual = (Long)this.ejbContext.lookup("entity/cmp/references/Long");
                Assert.assertNotNull((String)"The Long looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupFloatEntry() throws TestFailureException {
        try {
            try {
                Float expected = new Float(1.0f);
                Float actual = (Float)this.ejbContext.lookup("entity/cmp/references/Float");
                Assert.assertNotNull((String)"The Float looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupIntegerEntry() throws TestFailureException {
        try {
            try {
                Integer expected = new Integer(1);
                Integer actual = (Integer)this.ejbContext.lookup("entity/cmp/references/Integer");
                Assert.assertNotNull((String)"The Integer looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupShortEntry() throws TestFailureException {
        try {
            try {
                Short expected = new Short(1);
                Short actual = (Short)this.ejbContext.lookup("entity/cmp/references/Short");
                Assert.assertNotNull((String)"The Short looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupBooleanEntry() throws TestFailureException {
        try {
            try {
                Boolean expected = new Boolean(true);
                Boolean actual = (Boolean)this.ejbContext.lookup("entity/cmp/references/Boolean");
                Assert.assertNotNull((String)"The Boolean looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupByteEntry() throws TestFailureException {
        try {
            try {
                Byte expected = new Byte(1);
                Byte actual = (Byte)this.ejbContext.lookup("entity/cmp/references/Byte");
                Assert.assertNotNull((String)"The Byte looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupCharacterEntry() throws TestFailureException {
        try {
            try {
                Character expected = new Character('D');
                Character actual = (Character)this.ejbContext.lookup("entity/cmp/references/Character");
                Assert.assertNotNull((String)"The Character looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupResource() throws TestFailureException {
        try {
            try {
                Object obj = this.ejbContext.lookup("datasource");
                Assert.assertNotNull((String)"The DataSource is null", (Object)obj);
                Assert.assertTrue((String)"Not an instance of DataSource", (boolean)(obj instanceof DataSource));
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupJMSConnectionFactory() throws TestFailureException {
        try {
            try {
                Object obj = this.ejbContext.lookup("jms");
                Assert.assertNotNull((String)"The JMS ConnectionFactory is null", (Object)obj);
                Assert.assertTrue((String)"Not an instance of ConnectionFactory", (boolean)(obj instanceof ConnectionFactory));
                ConnectionFactory connectionFactory = (ConnectionFactory)obj;
                this.testJmsConnection(connectionFactory.createConnection());
                obj = this.ejbContext.lookup("TopicCF");
                Assert.assertNotNull((String)"The JMS TopicConnectionFactory is null", (Object)obj);
                Assert.assertTrue((String)"Not an instance of TopicConnectionFactory", (boolean)(obj instanceof TopicConnectionFactory));
                TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)obj;
                this.testJmsConnection(topicConnectionFactory.createConnection());
                obj = this.ejbContext.lookup("QueueCF");
                Assert.assertNotNull((String)"The JMS QueueConnectionFactory is null", (Object)obj);
                Assert.assertTrue((String)"Not an instance of QueueConnectionFactory", (boolean)(obj instanceof QueueConnectionFactory));
                QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)obj;
                this.testJmsConnection(queueConnectionFactory.createConnection());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    private void testJmsConnection(Connection connection) throws JMSException {
        Session session = connection.createSession(false, 3);
        Topic topic = session.createTopic("test");
        MessageProducer producer = session.createProducer((Destination)topic);
        producer.send(session.createMessage());
        producer.close();
        session.close();
        connection.close();
    }

    public void lookupPersistenceUnit() throws TestFailureException {
        try {
            try {
                EntityManagerFactory emf = (EntityManagerFactory)this.ejbContext.lookup("persistence/TestUnit");
                Assert.assertNotNull((String)"The EntityManagerFactory is null", (Object)emf);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupPersistenceContext() throws TestFailureException {
        try {
            try {
                EntityManager em = (EntityManager)this.ejbContext.lookup("persistence/TestContext");
                Assert.assertNotNull((String)"The EntityManager is null", (Object)em);
                em.getFlushMode();
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void ejbLoad() throws EJBException, RemoteException {
    }

    public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
        this.ejbContext = ctx;
    }

    public void unsetEntityContext() throws EJBException, RemoteException {
    }

    public void ejbStore() throws EJBException, RemoteException {
    }

    public void ejbRemove() throws RemoveException, EJBException, RemoteException {
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }
}

