/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.singleton;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.RollbackException;
import org.apache.openejb.test.object.Account;

public class ContainerTxSingletonBean
implements SessionBean {
    private String name;
    private SessionContext ejbContext;
    private InitialContext jndiContext;
    public final String jndiDatabaseEntry = "jdbc/singleton/containerManagedTransaction/database";

    public String txMandatoryMethod(String message) {
        return message;
    }

    public String txNeverMethod(String message) {
        return message;
    }

    public String txNotSupportedMethod(String message) {
        return message;
    }

    public String txRequiredMethod(String message) {
        return message;
    }

    public String txRequiresNewMethod(String message) {
        return message;
    }

    public String txSupportsMethod(String message) {
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openAccount(Account acct, Boolean rollback) throws RollbackException {
        try {
            DataSource ds = (DataSource)this.jndiContext.lookup("java:comp/env/database");
            Connection con = ds.getConnection();
            try {
                PreparedStatement stmt = con.prepareStatement("insert into Account (SSN, First_name, Last_name, Balance) values (?,?,?,?)");
                try {
                    stmt.setString(1, acct.getSsn());
                    stmt.setString(2, acct.getFirstName());
                    stmt.setString(3, acct.getLastName());
                    stmt.setInt(4, acct.getBalance());
                    stmt.executeUpdate();
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                con.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Account retreiveAccount(String ssn) {
        Account acct = new Account();
        try {
            DataSource ds = (DataSource)this.jndiContext.lookup("java:comp/env/database");
            Connection con = ds.getConnection();
            try {
                PreparedStatement stmt = con.prepareStatement("select * from Account where SSN = ?");
                try {
                    stmt.setString(1, ssn);
                    ResultSet rs = stmt.executeQuery();
                    if (!rs.next()) {
                        Account account = null;
                        return account;
                    }
                    acct.setSsn(rs.getString(1));
                    acct.setFirstName(rs.getString(2));
                    acct.setLastName(rs.getString(3));
                    acct.setBalance(rs.getInt(4));
                    return acct;
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                con.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return acct;
    }

    public void ejbCreate() throws CreateException {
        try {
            this.jndiContext = new InitialContext();
        }
        catch (Exception e) {
            throw new CreateException("Can not get the initial context: " + e.getMessage());
        }
    }

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.ejbContext = ctx;
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    public String remove(String arg) {
        return arg;
    }
}

