/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jsf;

import javax.el.ExpressionFactory;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ApplicationWrapper;
import org.apache.openejb.AppContext;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.adaptor.ELAdaptor;

public class CustomApplicationFactory
extends ApplicationFactory {
    private final ApplicationFactory factory;
    private final WebBeansContext webBeansContext;
    private volatile Application wrappedApplication;

    public CustomApplicationFactory(ApplicationFactory applicationFactory) {
        this.factory = applicationFactory;
        this.webBeansContext = WebBeansContext.currentInstance();
    }

    public Application getApplication() {
        if (!this.webBeansContext.getBeanManagerImpl().isInUse()) {
            return this.factory.getApplication();
        }
        if (this.wrappedApplication == null) {
            AppContext appContext = (AppContext)this.webBeansContext.getService(AppContext.class);
            if (appContext != null && !appContext.isCdiEnabled()) {
                this.wrappedApplication = this.factory.getApplication();
            } else {
                final Application application = this.factory.getApplication();
                this.wrappedApplication = new ApplicationWrapper(){
                    private volatile ExpressionFactory expressionFactory;

                    public ExpressionFactory getExpressionFactory() {
                        if (this.expressionFactory == null) {
                            ELAdaptor elAdaptor = (ELAdaptor)CustomApplicationFactory.this.webBeansContext.getService(ELAdaptor.class);
                            this.expressionFactory = elAdaptor.getOwbWrappedExpressionFactory(application.getExpressionFactory());
                        }
                        return this.expressionFactory;
                    }

                    public Application getWrapped() {
                        return application;
                    }
                };
            }
        }
        return this.wrappedApplication;
    }

    public void setApplication(Application application) {
        this.wrappedApplication = application;
        this.factory.setApplication(application);
    }

    public ApplicationFactory getWrapped() {
        return this.factory;
    }
}

