/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.openejb.loader.Embedder;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.LocationResolver;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.loader.Zips;

public class ProvisioningUtil {
    public static final String OPENEJB_DEPLOYER_CACHE_FOLDER = "openejb.deployer.cache.folder";
    public static final String HTTP_PREFIX = "http";
    private static final int CONNECT_TIMEOUT = 10000;
    private static final String ADDITIONAL_LIB_CONFIG = "provisioning.properties";
    private static final String ZIP_KEY = "zip";
    private static final String DESTINATION_KEY = "destination";
    private static final String JAR_KEY = "jar";
    public static final String TEMP_DIR = "temp";

    private ProvisioningUtil() {
    }

    public static String cache() {
        return System.getProperty(OPENEJB_DEPLOYER_CACHE_FOLDER, TEMP_DIR);
    }

    public static File cacheFile(String path) {
        return new File(SystemInstance.get().getBase().getDirectory(), ProvisioningUtil.cache() + File.separator + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String copyTryingProxies(URI source, File destination) throws Exception {
        InputStream is = ProvisioningUtil.inputStreamTryingProxies(source);
        if (is == null) {
            return null;
        }
        try {
            IO.copy(is, destination);
        }
        finally {
            IO.close(is);
        }
        return destination.getAbsolutePath();
    }

    public static InputStream inputStreamTryingProxies(URI source) throws Exception {
        URL url = source.toURL();
        for (Proxy proxy : ProxySelector.getDefault().select(source)) {
            try {
                URLConnection urlConnection = url.openConnection(proxy);
                urlConnection.setConnectTimeout(10000);
                return new BufferedInputStream(urlConnection.getInputStream());
            }
            catch (IOException e) {
            }
        }
        return null;
    }

    public static String lastPart(String location) {
        int idx = location.lastIndexOf(47);
        if (idx <= 0) {
            return location;
        }
        return location.substring(idx + 1, location.length());
    }

    public static String realLocation(String rawLocation) {
        if (rawLocation.startsWith(HTTP_PREFIX)) {
            File file = ProvisioningUtil.cacheFile(ProvisioningUtil.lastPart(rawLocation));
            String path = null;
            try {
                path = ProvisioningUtil.copyTryingProxies(new URI(rawLocation), file);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (path != null) {
                return path;
            }
        }
        try {
            Class<?> clazz = ProvisioningUtil.class.getClassLoader().loadClass("org.apache.openejb.resolver.Resolver");
            LocationResolver instance = (LocationResolver)clazz.newInstance();
            return instance.resolve(rawLocation);
        }
        catch (Exception e) {
            return rawLocation;
        }
    }

    public static void addAdditionalLibraries() throws IOException {
        File destination;
        String toExtract;
        File conf = new File(SystemInstance.get().getBase().getDirectory("conf"), ADDITIONAL_LIB_CONFIG);
        if (!conf.exists()) {
            return;
        }
        Properties additionalLibProperties = IO.readProperties(conf);
        ArrayList<String> libToCopy = new ArrayList<String>();
        String toCopy = additionalLibProperties.getProperty(JAR_KEY);
        if (toCopy != null) {
            for (String lib : toCopy.split(",")) {
                libToCopy.add(ProvisioningUtil.realLocation(lib.trim()));
            }
        }
        if ((toExtract = additionalLibProperties.getProperty(ZIP_KEY)) != null) {
            for (String zip : toExtract.split(",")) {
                libToCopy.addAll(ProvisioningUtil.extract(ProvisioningUtil.realLocation(zip)));
            }
        }
        if (!(destination = additionalLibProperties.containsKey(DESTINATION_KEY) ? new File(additionalLibProperties.getProperty(DESTINATION_KEY)) : new File(SystemInstance.get().getBase().getDirectory(), Embedder.ADDITIONAL_LIB_FOLDER)).exists()) {
            Files.mkdirs(destination);
        }
        for (String lib : libToCopy) {
            ProvisioningUtil.copy(new File(lib), destination);
        }
    }

    private static void copy(File file, File lib) throws IOException {
        File dest = new File(lib, file.getName());
        if (dest.exists()) {
            return;
        }
        IO.copy(file, dest);
    }

    private static Collection<String> extract(String zip) throws IOException {
        File zipFile;
        File extracted;
        File tmp = new File(SystemInstance.get().getBase().getDirectory(), TEMP_DIR);
        if (!tmp.exists()) {
            try {
                Files.mkdirs(tmp);
            }
            catch (Files.FileRuntimeException fre) {
                // empty catch block
            }
        }
        if ((extracted = new File(tmp, (zipFile = new File(ProvisioningUtil.realLocation(zip))).getName().replace(".zip", ""))).exists()) {
            return ProvisioningUtil.list(extracted);
        }
        Files.mkdirs(extracted);
        Zips.unzip(zipFile, extracted);
        return ProvisioningUtil.list(extracted);
    }

    private static Collection<String> list(File dir) {
        if (dir == null) {
            return Collections.emptyList();
        }
        ArrayList<String> libs = new ArrayList<String>();
        File[] files = dir.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        for (File file : files) {
            if (file.isDirectory()) {
                libs.addAll(ProvisioningUtil.list(file));
                continue;
            }
            libs.add(file.getAbsolutePath());
        }
        return libs;
    }
}

