/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.discovery;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.openejb.loader.Options;
import org.apache.openejb.server.DiscoveryAgent;
import org.apache.openejb.server.DiscoveryListener;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.discovery.Tracker;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class MulticastDiscoveryAgent
implements DiscoveryAgent,
ServerService,
SelfManaging {
    private static final Logger log = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER.createChild("discovery"), MulticastDiscoveryAgent.class);
    private AtomicBoolean running = new AtomicBoolean(false);
    private String host = "239.255.3.2";
    private int port = 6142;
    private int timeToLive = 1;
    private boolean loopbackMode = false;
    private InetSocketAddress address;
    private long heartRate = 500L;
    private Tracker tracker;
    private Multicast multicast;

    public void init(Properties props) {
        Options options = new Options(props);
        this.host = props.getProperty("bind", this.host);
        this.loopbackMode = options.get("loopback_mode", this.loopbackMode);
        this.port = options.get("port", this.port);
        this.heartRate = options.get("heart_rate", this.heartRate);
        Tracker.Builder builder = new Tracker.Builder();
        builder.setGroup(props.getProperty("group", builder.getGroup()));
        builder.setMaxMissedHeartbeats(options.get("max_missed_heartbeats", builder.getMaxMissedHeartbeats()));
        builder.setMaxReconnectDelay(options.get("max_reconnect_delay", builder.getMaxReconnectDelay()));
        builder.setReconnectDelay(options.get("reconnect_delay", builder.getReconnectDelay()));
        builder.setExponentialBackoff(options.get("exponential_backoff", builder.getExponentialBackoff()));
        builder.setMaxReconnectAttempts(options.get("max_reconnect_attempts", builder.getMaxReconnectAttempts()));
        this.tracker = builder.build();
    }

    public String getIP() {
        return this.host;
    }

    public String getName() {
        return "multicast";
    }

    public int getPort() {
        return this.port;
    }

    public void setDiscoveryListener(DiscoveryListener listener) {
        this.tracker.setDiscoveryListener(listener);
    }

    public void registerService(URI serviceUri) throws IOException {
        this.tracker.registerService(serviceUri);
    }

    public void unregisterService(URI serviceUri) throws IOException {
        this.tracker.unregisterService(serviceUri);
    }

    public void reportFailed(URI serviceUri) {
        this.tracker.reportFailed(serviceUri);
    }

    public static void main(String[] args) throws Exception {
    }

    public void start() throws ServiceException {
        try {
            if (this.running.compareAndSet(false, true)) {
                InetAddress inetAddress = InetAddress.getByName(this.host);
                this.address = new InetSocketAddress(inetAddress, this.port);
                this.multicast = new Multicast(this.tracker);
            }
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void stop() throws ServiceException {
        if (this.running.compareAndSet(true, false)) {
            this.multicast.close();
        }
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
    }

    public void service(Socket socket) throws ServiceException, IOException {
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean isLoopbackMode() {
        return this.loopbackMode;
    }

    public void setLoopbackMode(boolean loopbackMode) {
        this.loopbackMode = loopbackMode;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    class Multicast {
        private static final int BUFF_SIZE = 8192;
        private final Tracker tracker;
        private final MulticastSocket multicast;
        private Timer timer;
        private Thread listenerThread;

        Multicast(Tracker tracker) throws IOException {
            this.tracker = tracker;
            this.multicast = new MulticastSocket(MulticastDiscoveryAgent.this.port);
            this.multicast.setLoopbackMode(MulticastDiscoveryAgent.this.loopbackMode);
            this.multicast.setTimeToLive(MulticastDiscoveryAgent.this.timeToLive);
            this.multicast.joinGroup(MulticastDiscoveryAgent.this.address.getAddress());
            this.multicast.setSoTimeout((int)MulticastDiscoveryAgent.this.heartRate);
            this.listenerThread = new Thread(new Listener());
            this.listenerThread.setName("MulticastDiscovery: Listener");
            this.listenerThread.setDaemon(true);
            this.listenerThread.start();
            Broadcaster broadcaster = new Broadcaster();
            this.timer = new Timer("MulticastDiscovery: Broadcaster", true);
            this.timer.scheduleAtFixedRate((TimerTask)broadcaster, 0L, MulticastDiscoveryAgent.this.heartRate);
        }

        public void close() {
            this.timer.cancel();
        }

        class Broadcaster
        extends TimerTask {
            private IOException failed;

            Broadcaster() {
            }

            @Override
            public void run() {
                if (MulticastDiscoveryAgent.this.running.get()) {
                    this.heartbeat();
                }
            }

            private void heartbeat() {
                for (String uri : Multicast.this.tracker.getRegisteredServices()) {
                    try {
                        byte[] data = uri.getBytes();
                        DatagramPacket packet = new DatagramPacket(data, 0, data.length, MulticastDiscoveryAgent.this.address);
                        Multicast.this.multicast.send(packet);
                    }
                    catch (IOException e) {
                        if (this.failed != null) continue;
                        this.failed = e;
                        log.error("Failed to advertise our service: " + uri, (Throwable)e);
                        if (!"Operation not permitted".equals(e.getMessage())) continue;
                        log.error("The 'Operation not permitted' error has been know to be caused by improper firewall/network setup.  Please make sure that the OS is properly configured to allow multicast traffic over: " + Multicast.this.multicast.getLocalAddress());
                    }
                }
            }
        }

        class Listener
        implements Runnable {
            Listener() {
            }

            @Override
            public void run() {
                byte[] buf = new byte[8192];
                DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
                while (MulticastDiscoveryAgent.this.running.get()) {
                    Multicast.this.tracker.checkServices();
                    try {
                        Multicast.this.multicast.receive(packet);
                        if (packet.getLength() <= 0) continue;
                        String str = new String(packet.getData(), packet.getOffset(), packet.getLength());
                        Multicast.this.tracker.processData(str);
                    }
                    catch (SocketTimeoutException se) {
                    }
                    catch (IOException e) {
                        if (!MulticastDiscoveryAgent.this.running.get()) continue;
                        log.error("failed to process packet: " + e);
                    }
                }
            }
        }
    }
}

