/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.discovery;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.openejb.server.discovery.Tracker;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class MultipointServer {
    private static final Logger log = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER.createChild("discovery"), MultipointServer.class);
    private static final URI END_LIST = URI.create("end:list");
    private final String host;
    private final int port;
    private final Selector selector;
    private final URI me;
    private final Tracker tracker;
    private final LinkedList<URI> connect = new LinkedList();
    private final Map<URI, Session> connections = new HashMap<URI, Session>();
    private final AtomicBoolean running = new AtomicBoolean();

    public MultipointServer(int port, Tracker tracker) throws IOException {
        this("localhost", port, tracker);
    }

    public MultipointServer(String host, int port, Tracker tracker) throws IOException {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        this.host = host;
        this.tracker = tracker;
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        ServerSocket serverSocket = serverChannel.socket();
        InetSocketAddress address = new InetSocketAddress(host, port);
        serverSocket.bind(address);
        serverChannel.configureBlocking(false);
        this.port = serverSocket.getLocalPort();
        this.me = URI.create("conn://" + this.host + ":" + this.port);
        this.selector = Selector.open();
        serverChannel.register(this.selector, 16);
        this.println("Listening");
    }

    public int getPort() {
        return this.port;
    }

    public MultipointServer start() {
        if (this.running.compareAndSet(false, true)) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    MultipointServer.this._run();
                }
            });
            thread.setName("Server." + this.port);
            thread.start();
        }
        return this;
    }

    public void stop() {
        this.running.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _run() {
        while (this.running.get()) {
            Session session;
            try {
                this.selector.select(1000L);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                break;
            }
            Set<SelectionKey> keys = this.selector.selectedKeys();
            Iterator<SelectionKey> iterator = keys.iterator();
            while (iterator.hasNext()) {
                Session session2;
                Object message;
                SelectionKey key = iterator.next();
                iterator.remove();
                try {
                    Session session3;
                    if (key.isAcceptable()) {
                        ServerSocketChannel server = (ServerSocketChannel)key.channel();
                        SocketChannel client = server.accept();
                        InetSocketAddress address = (InetSocketAddress)client.socket().getRemoteSocketAddress();
                        client.configureBlocking(false);
                        Session session4 = new Session(client, address, null);
                        session4.trace("accept");
                        session4.state(1, State.GREETING);
                    }
                    if (key.isConnectable()) {
                        session3 = (Session)key.attachment();
                        session3.channel.finishConnect();
                        session3.trace("connected");
                        session3.write(this.me);
                        session3.state(4, State.GREETING);
                    }
                    if (key.isReadable()) {
                        session3 = (Session)key.attachment();
                        block11 : switch (session3.state) {
                            case GREETING: {
                                message = session3.read();
                                if (message == null) break;
                                session3.setURI(URI.create((String)message));
                                this.connected(session3);
                                session3.trace("welcome");
                                ArrayList<URI> list = this.connections();
                                list.remove(this.me);
                                list.add(END_LIST);
                                session3.write(list);
                                session3.state(4, State.LISTING);
                                session3.trace("STARTING");
                                break;
                            }
                            case LISTING: {
                                message = null;
                                while ((message = session3.read()) != null) {
                                    session3.trace((String)message);
                                    URI uri = URI.create((String)message);
                                    if (END_LIST.equals(uri)) {
                                        if (session3.client) {
                                            ArrayList<URI> list = this.connections();
                                            for (URI reported : session3.listed) {
                                                list.remove(reported);
                                            }
                                            list.remove(session3.uri);
                                            list.add(END_LIST);
                                            session3.write(list);
                                            session3.state(4, State.LISTING);
                                            break block11;
                                        }
                                        if (session3.hangup) {
                                            session3.state(0, State.CLOSED);
                                            session3.trace("hangup");
                                            this.hangup(key);
                                            break block11;
                                        }
                                        session3.trace("DONE READING");
                                        session3.state(1, State.HEARTBEAT);
                                        break block11;
                                    }
                                    session3.listed.add(uri);
                                    try {
                                        this.connect(uri);
                                    }
                                    catch (Exception e) {
                                        this.println("connect failed " + uri + " - " + e.getMessage());
                                        e.printStackTrace();
                                    }
                                }
                                break;
                            }
                            case HEARTBEAT: {
                                message = null;
                                while ((message = session3.read()) != null) {
                                    this.tracker.processData((String)message);
                                }
                                break;
                            }
                        }
                    }
                    if (!key.isWritable()) continue;
                    session3 = (Session)key.attachment();
                    switch (session3.state) {
                        case GREETING: {
                            if (!session3.drain()) break;
                            session3.state(1, State.LISTING);
                            break;
                        }
                        case LISTING: {
                            if (!session3.drain()) break;
                            if (session3.client) {
                                session3.trace("DONE WRITING");
                                session3.state(1, State.HEARTBEAT);
                                break;
                            }
                            session3.state(1, State.LISTING);
                            break;
                        }
                        case HEARTBEAT: {
                            if (!session3.drain()) break;
                            session3.last = System.currentTimeMillis();
                            session3.trace("ping");
                            session3.state(1, State.HEARTBEAT);
                        }
                    }
                }
                catch (CancelledKeyException ex) {
                    message = this.connect;
                    synchronized (message) {
                        session2 = (Session)key.attachment();
                        if (session2.state != State.CLOSED) {
                            this.close(key);
                        }
                    }
                }
                catch (ClosedChannelException ex) {
                    message = this.connect;
                    synchronized (message) {
                        session2 = (Session)key.attachment();
                        if (session2.state != State.CLOSED) {
                            this.close(key);
                        }
                    }
                }
                catch (IOException ex) {
                    session = (Session)key.attachment();
                    session.trace(ex.getClass().getSimpleName() + ": " + ex.getMessage());
                    this.close(key);
                }
            }
            for (SelectionKey key : this.selector.keys()) {
                session = (Session)key.attachment();
                try {
                    if (session == null || session.state != State.HEARTBEAT) continue;
                    session.tick();
                }
                catch (IOException ex) {
                    this.close(key);
                }
            }
            LinkedList<URI> linkedList = this.connect;
            synchronized (linkedList) {
                while (this.connect.size() > 0) {
                    URI uri = this.connect.removeFirst();
                    if (this.connections.containsKey(uri)) continue;
                    int port = uri.getPort();
                    String host = uri.getHost();
                    try {
                        this.println("open " + uri);
                        SocketChannel socketChannel = SocketChannel.open();
                        socketChannel.configureBlocking(false);
                        InetSocketAddress address = new InetSocketAddress(host, port);
                        socketChannel.connect(address);
                        Session session5 = new Session(socketChannel, address, uri);
                        session5.ops(8);
                        session5.trace("client");
                        this.connections.put(session5.uri, session5);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<URI> connections() {
        LinkedList<URI> linkedList = this.connect;
        synchronized (linkedList) {
            ArrayList<URI> list = new ArrayList<URI>(this.connections.keySet());
            list.addAll(this.connect);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(SelectionKey key) {
        Session session = (Session)key.attachment();
        session.state(0, State.CLOSED);
        if (session.hangup) {
            session.trace("hungup");
        } else {
            session.trace("closed");
            LinkedList<URI> linkedList = this.connect;
            synchronized (linkedList) {
                this.connections.remove(session.uri);
            }
        }
        this.hangup(key);
    }

    private void hangup(SelectionKey key) {
        key.cancel();
        try {
            key.channel().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void connect(MultipointServer s) throws Exception {
        this.connect(s.port);
    }

    public void connect(int port) throws Exception {
        this.connect(URI.create("conn://localhost:" + port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(URI uri) throws Exception {
        if (this.me.equals(uri)) {
            return;
        }
        LinkedList<URI> linkedList = this.connect;
        synchronized (linkedList) {
            if (!this.connections.containsKey(uri) && !this.connect.contains(uri)) {
                this.connect.addLast(uri);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connected(Session session) {
        LinkedList<URI> linkedList = this.connect;
        synchronized (linkedList) {
            Session duplicate = this.connections.get(session.uri);
            if (duplicate != null) {
                session.trace("duplicate");
                Session[] sessions = new Session[]{session, duplicate};
                Arrays.sort(sessions, new Comparator<Session>(){

                    @Override
                    public int compare(Session a, Session b) {
                        int serverRank = this.server(a) - this.server(b);
                        if (serverRank != 0) {
                            return serverRank;
                        }
                        return this.client(a) - this.client(b);
                    }

                    private int server(Session a) {
                        Socket socket = a.channel.socket();
                        return a.client ? socket.getPort() : socket.getLocalPort();
                    }

                    private int client(Session a) {
                        Socket socket = a.channel.socket();
                        return !a.client ? socket.getPort() : socket.getLocalPort();
                    }
                });
                session = sessions[0];
                duplicate = sessions[1];
                session.info(session + "@" + session.hashCode() + " KEEP");
                duplicate.info(duplicate + "@" + duplicate.hashCode() + " KILL");
                duplicate.hangup = true;
            }
            this.connections.put(session.uri, session);
        }
    }

    private void println(String s) {
    }

    private static enum State {
        OPEN,
        GREETING,
        LISTING,
        HEARTBEAT,
        CLOSED;

    }

    public class Session {
        private static final int EOF = 3;
        private final SocketChannel channel;
        private final ByteBuffer read = ByteBuffer.allocate(1024);
        private final SelectionKey key;
        private final List<URI> listed = new ArrayList<URI>();
        private ByteBuffer write;
        private State state = State.OPEN;
        private URI uri;
        public boolean hangup;
        private final boolean client;
        private long last = 0L;

        public Session(SocketChannel channel, InetSocketAddress address, URI uri) throws ClosedChannelException {
            this.channel = channel;
            this.client = uri != null;
            this.uri = uri != null ? uri : URI.create("conn://" + address.getHostName() + ":" + address.getPort());
            this.key = channel.register(MultipointServer.this.selector, 0, this);
        }

        public Session ops(int ops) {
            this.key.interestOps(ops);
            return this;
        }

        public void state(int ops, State state) {
            this.state = state;
            if (ops > 0) {
                this.key.interestOps(ops);
            }
        }

        public void setURI(URI uri) {
            this.uri = uri;
        }

        private void trace(String str) {
            if (log.isDebugEnabled()) {
                log.debug(this.message(str));
            }
        }

        private void info(String str) {
            if (log.isInfoEnabled()) {
                log.info(this.message(str));
            }
        }

        private String message(String str) {
            StringBuilder sb = new StringBuilder();
            sb.append(MultipointServer.this.port);
            sb.append(" ");
            if (this.key.isValid()) {
                if ((this.key.interestOps() & 1) == 1) {
                    sb.append("<");
                }
                if ((this.key.interestOps() & 4) == 4) {
                    sb.append(">");
                }
                if (this.key.interestOps() == 0) {
                    sb.append("-");
                }
            } else {
                sb.append(":");
            }
            sb.append(" ");
            sb.append(this.uri.getPort());
            sb.append(" ");
            sb.append((Object)this.state);
            sb.append(" ");
            sb.append(str);
            String x = sb.toString();
            return x;
        }

        public void write(URI uri) throws IOException {
            this.write(Arrays.asList(uri));
        }

        public void write(Collection<?> uris) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (Object uri : uris) {
                String s = uri.toString();
                byte[] b = s.getBytes("UTF-8");
                baos.write(b);
                baos.write(3);
            }
            this.write = ByteBuffer.wrap(baos.toByteArray());
        }

        public boolean drain() throws IOException {
            this.channel.write(this.write);
            return this.write.remaining() == 0;
        }

        public String read() throws IOException {
            if (this.channel.read(this.read) == -1) {
                throw new EOFException();
            }
            byte[] buf = this.read.array();
            int end = this.endOfText(buf, 0, this.read.position());
            if (end < 0) {
                return null;
            }
            String text = new String(buf, 0, end, "UTF-8");
            int newPos = this.read.position() - end;
            System.arraycopy(buf, end + 1, buf, 0, newPos - 1);
            this.read.position(newPos - 1);
            return text;
        }

        private int endOfText(byte[] data, int offset, int pos) {
            for (int i = offset; i < pos; ++i) {
                if (data[i] != 3) continue;
                return i;
            }
            return -1;
        }

        public String toString() {
            return "Session{uri=" + this.uri + ", state=" + (Object)((Object)this.state) + ", owner=" + MultipointServer.this.port + ", s=" + (this.client ? this.channel.socket().getPort() : this.channel.socket().getLocalPort()) + ", c=" + (!this.client ? this.channel.socket().getPort() : this.channel.socket().getLocalPort()) + ", " + (this.client ? "client" : "server") + '}';
        }

        public void tick() throws IOException {
            if (this.state != State.HEARTBEAT) {
                return;
            }
            long now = System.currentTimeMillis();
            long delay = now - this.last;
            if (delay > MultipointServer.this.tracker.getHeartRate()) {
                this.last = now;
                this.heartbeat();
            }
        }

        private void heartbeat() throws IOException {
            Set<String> strings = MultipointServer.this.tracker.getRegisteredServices();
            for (String string : strings) {
                this.trace(string);
            }
            this.write(strings);
            this.state(5, State.HEARTBEAT);
            MultipointServer.this.tracker.checkServices();
        }
    }
}

