/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.discovery;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.openejb.server.DiscoveryListener;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class Tracker {
    private static final Logger log = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER.createChild("discovery"), Tracker.class);
    private final String group;
    private final String groupPrefix;
    private final long heartRate;
    private final int maxMissedHeartbeats;
    private final long reconnectDelay;
    private final long maxReconnectDelay;
    private final int maxReconnectAttempts;
    private final long exponentialBackoff;
    private final boolean useExponentialBackOff;
    private Map<String, Service> registeredServices = new ConcurrentHashMap<String, Service>();
    private Map<String, ServiceVitals> discoveredServices = new ConcurrentHashMap<String, ServiceVitals>();
    private DiscoveryListener discoveryListener;
    private final Executor executor = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runable) {
            Thread t = new Thread(runable, "Discovery Agent Notifier");
            t.setDaemon(true);
            return t;
        }
    });

    public Tracker(String group, long heartRate, int maxMissedHeartbeats, long reconnectDelay, long maxReconnectDelay, int maxReconnectAttempts, long exponentialBackoff) {
        this.group = group;
        this.groupPrefix = group + ":";
        this.heartRate = heartRate;
        this.maxMissedHeartbeats = maxMissedHeartbeats;
        this.reconnectDelay = reconnectDelay;
        this.maxReconnectDelay = maxReconnectDelay;
        this.maxReconnectAttempts = maxReconnectAttempts;
        this.exponentialBackoff = exponentialBackoff;
        this.useExponentialBackOff = exponentialBackoff > 1L;
    }

    public long getHeartRate() {
        return this.heartRate;
    }

    public void setDiscoveryListener(DiscoveryListener discoveryListener) {
        this.discoveryListener = discoveryListener;
    }

    public Set<String> getRegisteredServices() {
        return this.registeredServices.keySet();
    }

    public void registerService(URI serviceUri) throws IOException {
        Service service = new Service(serviceUri);
        this.registeredServices.put(service.broadcastString, service);
        this.fireServiceAddedEvent(serviceUri);
    }

    public void unregisterService(URI serviceUri) throws IOException {
        Service service = new Service(serviceUri);
        this.registeredServices.remove(service.broadcastString);
        this.fireServiceRemovedEvent(serviceUri);
    }

    private boolean isSelf(Service service) {
        return this.isSelf(service.broadcastString);
    }

    private boolean isSelf(String service) {
        return this.registeredServices.keySet().contains(service);
    }

    public void processData(String uriString) {
        if (this.discoveryListener == null) {
            return;
        }
        if (!uriString.startsWith(this.groupPrefix)) {
            return;
        }
        if (this.isSelf(uriString)) {
            return;
        }
        ServiceVitals vitals = this.discoveredServices.get(uriString);
        if (vitals == null) {
            try {
                vitals = new ServiceVitals(new Service(uriString));
                this.discoveredServices.put(uriString, vitals);
                this.fireServiceAddedEvent(vitals.service.uri);
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            vitals.heartbeat();
            if (vitals.doRecovery()) {
                this.fireServiceAddedEvent(vitals.service.uri);
            }
        }
    }

    public void checkServices() {
        long expireTime = System.currentTimeMillis() - this.heartRate * (long)this.maxMissedHeartbeats;
        for (ServiceVitals serviceVitals : this.discoveredServices.values()) {
            ServiceVitals vitals;
            if (serviceVitals.getLastHeartbeat() >= expireTime || this.isSelf(serviceVitals.service) || (vitals = this.discoveredServices.remove(serviceVitals.service.broadcastString)) == null || vitals.isDead()) continue;
            this.fireServiceRemovedEvent(vitals.service.uri);
        }
    }

    private void fireServiceRemovedEvent(final URI uri) {
        if (this.discoveryListener != null) {
            final DiscoveryListener discoveryListener = this.discoveryListener;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (discoveryListener != null) {
                        discoveryListener.serviceRemoved(uri);
                    }
                }
            });
        }
    }

    private void fireServiceAddedEvent(final URI uri) {
        if (this.discoveryListener != null) {
            final DiscoveryListener discoveryListener = this.discoveryListener;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (discoveryListener != null) {
                        discoveryListener.serviceAdded(uri);
                    }
                }
            });
        }
    }

    public void reportFailed(URI serviceUri) {
        Service service = new Service(serviceUri);
        ServiceVitals serviceVitals = this.discoveredServices.get(service.broadcastString);
        if (serviceVitals != null && serviceVitals.pronounceDead()) {
            this.fireServiceRemovedEvent(service.uri);
        }
    }

    public static class Builder {
        private String group = "default";
        private int maxMissedHeartbeats = 10;
        private long heartRate = 500L;
        private long reconnectDelay = 5000L;
        private long maxReconnectDelay = 30000L;
        private long exponentialBackoff = 0L;
        private int maxReconnectAttempts = 10;

        public long getExponentialBackoff() {
            return this.exponentialBackoff;
        }

        public void setExponentialBackoff(long exponentialBackoff) {
            this.exponentialBackoff = exponentialBackoff;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public long getHeartRate() {
            return this.heartRate;
        }

        public void setHeartRate(long heartRate) {
            this.heartRate = heartRate;
        }

        public long getReconnectDelay() {
            return this.reconnectDelay;
        }

        public void setReconnectDelay(long reconnectDelay) {
            this.reconnectDelay = reconnectDelay;
        }

        public int getMaxMissedHeartbeats() {
            return this.maxMissedHeartbeats;
        }

        public void setMaxMissedHeartbeats(int maxMissedHeartbeats) {
            this.maxMissedHeartbeats = maxMissedHeartbeats;
        }

        public int getMaxReconnectAttempts() {
            return this.maxReconnectAttempts;
        }

        public void setMaxReconnectAttempts(int maxReconnectAttempts) {
            this.maxReconnectAttempts = maxReconnectAttempts;
        }

        public long getMaxReconnectDelay() {
            return this.maxReconnectDelay;
        }

        public void setMaxReconnectDelay(long maxReconnectDelay) {
            this.maxReconnectDelay = maxReconnectDelay;
        }

        public Tracker build() {
            return new Tracker(this.group, this.heartRate, this.maxMissedHeartbeats, this.reconnectDelay, this.maxReconnectDelay, this.maxReconnectAttempts, this.exponentialBackoff);
        }
    }

    private class ServiceVitals {
        private final Service service;
        private long lastHeartBeat;
        private long recoveryTime;
        private int failureCount;
        private boolean dead;

        public ServiceVitals(Service service) {
            this.service = service;
            this.lastHeartBeat = System.currentTimeMillis();
        }

        public synchronized void heartbeat() {
            this.lastHeartBeat = System.currentTimeMillis();
            if (!this.dead && this.failureCount > 0 && this.lastHeartBeat - this.recoveryTime > 60000L) {
                if (log.isDebugEnabled()) {
                    log.debug("I now think that the " + this.service + " service has recovered.");
                }
                this.failureCount = 0;
                this.recoveryTime = 0L;
            }
        }

        public synchronized long getLastHeartbeat() {
            return this.lastHeartBeat;
        }

        public synchronized boolean pronounceDead() {
            if (!this.dead) {
                long delay;
                this.dead = true;
                ++this.failureCount;
                if (Tracker.this.useExponentialBackOff) {
                    delay = (long)Math.pow(Tracker.this.exponentialBackoff, this.failureCount);
                    if (delay > Tracker.this.maxReconnectDelay) {
                        delay = Tracker.this.maxReconnectDelay;
                    }
                } else {
                    delay = Tracker.this.reconnectDelay;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Remote failure of " + this.service + " while still receiving multicast advertisements.  " + "Advertising events will be suppressed for " + delay + " ms, the current failure count is: " + this.failureCount);
                }
                this.recoveryTime = System.currentTimeMillis() + delay;
                return true;
            }
            return false;
        }

        public synchronized boolean doRecovery() {
            if (!this.dead) {
                return false;
            }
            if (Tracker.this.maxReconnectAttempts > 0 && this.failureCount > Tracker.this.maxReconnectAttempts) {
                if (log.isDebugEnabled()) {
                    log.debug("Max reconnect attempts of the " + this.service + " service has been reached.");
                }
                return false;
            }
            if (System.currentTimeMillis() < this.recoveryTime) {
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug("Resuming event advertisement of the " + this.service + " service.");
            }
            this.dead = false;
            return true;
        }

        public boolean isDead() {
            return this.dead;
        }
    }

    public class Service {
        private final URI uri;
        private final String broadcastString;

        public Service(URI uri) {
            this.uri = uri;
            this.broadcastString = Tracker.this.groupPrefix + uri.toString();
        }

        public Service(String uriString) throws URISyntaxException {
            URI uri = new URI(uriString);
            this.uri = uri = new URI(uri.getSchemeSpecificPart());
            this.broadcastString = uriString;
        }
    }
}

