/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.Managed;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServerServiceFilter;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

@Managed
public class ServicePool
extends ServerServiceFilter {
    private static final Logger log = Logger.getInstance((LogCategory)LogCategory.SERVICEPOOL, (String)"org.apache.openejb.util.resources");
    private final ThreadPoolExecutor threadPool;
    private final AtomicBoolean stop = new AtomicBoolean();
    @Managed
    private final Pool pool = new Pool();

    public ServicePool(ServerService next, Properties properties) {
        this(next, new Options(properties).get("threads", 100));
    }

    public ServicePool(ServerService next, int threads) {
        super(next);
        int keepAliveTime = 300000;
        this.threadPool = new ThreadPoolExecutor(threads, threads, 300000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.threadPool.setThreadFactory(new ThreadFactory(){
            private volatile int id = 0;

            @Override
            public Thread newThread(Runnable arg0) {
                return new Thread(arg0, ServicePool.this.getName() + " " + this.getNextID());
            }

            private int getNextID() {
                return this.id++;
            }
        });
        SystemInstance.get().setComponent(ServicePool.class, (Object)this);
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    @Override
    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
    }

    @Override
    public void service(final Socket socket) throws ServiceException, IOException {
        final Runnable service = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (ServicePool.this.stop.get()) {
                        return;
                    }
                    ServicePool.super.service(socket);
                }
                catch (SecurityException e) {
                    log.error("Security error: " + e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    log.debug("Unexpected IO error", (Throwable)e);
                }
                catch (Throwable e) {
                    log.error("Unexpected error", e);
                }
                finally {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (Throwable t) {
                        log.warning("Error while closing connection with client", t);
                    }
                }
            }
        };
        final ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Runnable ctxCL = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(tccl);
                try {
                    service.run();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
        };
        this.threadPool.execute(ctxCL);
    }

    @Managed(append=true)
    public class Pool {
        @Managed
        public boolean isShutdown() {
            return ServicePool.this.threadPool.isShutdown();
        }

        @Managed
        public boolean isTerminating() {
            return ServicePool.this.threadPool.isTerminating();
        }

        @Managed
        public boolean isTerminated() {
            return ServicePool.this.threadPool.isTerminated();
        }

        @Managed
        public int getPoolSize() {
            return ServicePool.this.threadPool.getPoolSize();
        }

        @Managed
        public int getCorePoolSize() {
            return ServicePool.this.threadPool.getCorePoolSize();
        }

        @Managed
        public int getMaximumPoolSize() {
            return ServicePool.this.threadPool.getMaximumPoolSize();
        }

        @Managed
        public long getKeepAliveTime(TimeUnit unit) {
            return ServicePool.this.threadPool.getKeepAliveTime(unit);
        }

        @Managed
        public int getQueueSize() {
            return ServicePool.this.threadPool.getQueue().size();
        }

        @Managed
        public int getActiveCount() {
            return ServicePool.this.threadPool.getActiveCount();
        }

        @Managed
        public int getLargestPoolSize() {
            return ServicePool.this.threadPool.getLargestPoolSize();
        }

        @Managed
        public long getTaskCount() {
            return ServicePool.this.threadPool.getTaskCount();
        }

        @Managed
        public long getCompletedTaskCount() {
            return ServicePool.this.threadPool.getCompletedTaskCount();
        }

        @Managed
        public void setMaximumPoolSize(int maximumPoolSize) {
            ServicePool.this.threadPool.setMaximumPoolSize(maximumPoolSize);
        }

        @Managed
        public void setCorePoolSize(int corePoolSize) {
            ServicePool.this.getThreadPool().setCorePoolSize(corePoolSize);
        }

        @Managed
        public void allowCoreThreadTimeOut(boolean value) {
            ServicePool.this.getThreadPool().allowCoreThreadTimeOut(value);
        }

        @Managed(description="Sets time in nanoseconds")
        public void setKeepAliveTime(long time) {
            ServicePool.this.getThreadPool().setKeepAliveTime(time, TimeUnit.NANOSECONDS);
        }
    }
}

