/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.openejb.server.ServerRuntimeException;
import org.apache.openejb.util.Connect;

public class Start {
    public static void main(String[] args) {
        new Start().start();
    }

    public boolean start() {
        if (!Start.connect()) {
            this.forkServerProcess();
            return Connect.connect((int)10, (String)"localhost", (int)4201);
        }
        System.out.println(":: server already started ::");
        return true;
    }

    private void forkServerProcess() {
        try {
            ArrayList<String> cmd = new ArrayList<String>();
            String s = File.separator;
            String java = System.getProperty("java.home") + s + "bin" + s + "java";
            cmd.add(java);
            this.addSystemProperties(cmd);
            cmd.add("-classpath");
            cmd.add(this.getClasspath());
            cmd.add("org.apache.openejb.server.Main");
            String[] command = cmd.toArray(new String[0]);
            Runtime runtime = Runtime.getRuntime();
            Process server = runtime.exec(command);
            InputStream out = server.getInputStream();
            Thread serverOut = new Thread(new Pipe(out, System.out));
            serverOut.setDaemon(true);
            serverOut.start();
            InputStream err = server.getErrorStream();
            Thread serverErr = new Thread(new Pipe(err, System.err));
            serverErr.setDaemon(true);
            serverErr.start();
        }
        catch (Exception e) {
            throw new ServerRuntimeException("Cannot start the server.");
        }
    }

    private void addSystemProperties(ArrayList cmd) {
        Set<Map.Entry<Object, Object>> set = System.getProperties().entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.matches("^-X.*")) {
                cmd.add(key + value);
                continue;
            }
            if (key.matches("^(java|javax|os|sun|user|file|awt|line|path)\\..*")) continue;
            cmd.add("-D" + key + "=" + value);
        }
    }

    private String getClasspath() {
        String classpath = System.getProperty("java.class.path");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String antLoader = "org.apache.tools.ant.AntClassLoader";
        if (cl.getClass().getName().equals(antLoader)) {
            try {
                Class<?> ant = cl.getClass();
                Method getClasspath = ant.getMethod("getClasspath", new Class[0]);
                classpath = classpath + File.pathSeparator + getClasspath.invoke((Object)cl, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return classpath;
    }

    public static boolean connect() {
        return Connect.connect((int)1, (String)"localhost", (int)4201);
    }

    private static final class Pipe
    implements Runnable {
        private final InputStream is;
        private final OutputStream out;

        private Pipe(InputStream is, OutputStream out) {
            this.is = is;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                int i = this.is.read();
                this.out.write(i);
                while (i != -1) {
                    i = this.is.read();
                    this.out.write(i);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

