/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.identifier.ColumnDefIdentifierRule;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.DBIdentifierRule;
import org.apache.openjpa.jdbc.identifier.DBIdentifierUtil;
import org.apache.openjpa.jdbc.identifier.Normalizer;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.kernel.exps.Null;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.DataSourceFactory;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.NameSet;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.Sequence;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.sql.Calendard;
import org.apache.openjpa.jdbc.sql.DBDictionaryFactory;
import org.apache.openjpa.jdbc.sql.Join;
import org.apache.openjpa.jdbc.sql.JoinSyntaxes;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.SQLErrorCodeReader;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.jdbc.sql.Sized;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.exps.Path;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.identifier.IdentifierConfiguration;
import org.apache.openjpa.lib.identifier.IdentifierRule;
import org.apache.openjpa.lib.jdbc.ConnectionDecorator;
import org.apache.openjpa.lib.jdbc.LoggingConnectionDecorator;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.InvalidStateException;
import org.apache.openjpa.util.LockException;
import org.apache.openjpa.util.ObjectExistsException;
import org.apache.openjpa.util.ObjectNotFoundException;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.OptimisticException;
import org.apache.openjpa.util.ProxyManager;
import org.apache.openjpa.util.QueryException;
import org.apache.openjpa.util.ReferentialIntegrityException;
import org.apache.openjpa.util.Serialization;
import org.apache.openjpa.util.StoreException;
import org.apache.openjpa.util.UnsupportedException;
import org.apache.openjpa.util.UserException;
import serp.util.Strings;

public class DBDictionary
implements Configurable,
ConnectionDecorator,
JoinSyntaxes,
LoggingConnectionDecorator.SQLWarningHandler,
IdentifierConfiguration {
    public static final String VENDOR_OTHER = "other";
    public static final String VENDOR_DATADIRECT = "datadirect";
    public static final String SCHEMA_CASE_UPPER = "upper";
    public static final String SCHEMA_CASE_LOWER = "lower";
    public static final String SCHEMA_CASE_PRESERVE = "preserve";
    public static final String CONS_NAME_BEFORE = "before";
    public static final String CONS_NAME_MID = "mid";
    public static final String CONS_NAME_AFTER = "after";
    public int blobBufferSize = 50000;
    public int clobBufferSize = 50000;
    protected static final int RANGE_POST_SELECT = 0;
    protected static final int RANGE_PRE_DISTINCT = 1;
    protected static final int RANGE_POST_DISTINCT = 2;
    protected static final int RANGE_POST_LOCK = 3;
    protected static final int NANO = 1;
    protected static final int MICRO = 1000;
    protected static final int MILLI = 1000000;
    protected static final int CENTI = 10000000;
    protected static final int DECI = 100000000;
    protected static final int SEC = 1000000000;
    protected static final int NAME_ANY = 0;
    protected static final int NAME_TABLE = 1;
    protected static final int NAME_SEQUENCE = 2;
    protected static final int UNLIMITED = -1;
    protected static final int NO_BATCH = 0;
    private static final String ZERO_DATE_STR = "'" + new java.sql.Date(0L) + "'";
    private static final String ZERO_TIME_STR = "'" + new Time(0L) + "'";
    private static final String ZERO_TIMESTAMP_STR = "'" + new Timestamp(0L) + "'";
    private static final Localizer _loc = Localizer.forPackage(DBDictionary.class);
    public String platform = "Generic";
    public String driverVendor = null;
    public boolean createPrimaryKeys = true;
    public String constraintNameMode = "before";
    public int maxTableNameLength = 128;
    public int maxColumnNameLength = 128;
    public int maxConstraintNameLength = 128;
    public int maxIndexNameLength = 128;
    public int maxIndexesPerTable = Integer.MAX_VALUE;
    public boolean supportsForeignKeys = true;
    public boolean supportsParameterInSelect = true;
    public boolean supportsForeignKeysComposite = true;
    public boolean supportsUniqueConstraints = true;
    public boolean supportsDeferredConstraints = true;
    public boolean supportsRestrictDeleteAction = true;
    public boolean supportsCascadeDeleteAction = true;
    public boolean supportsNullDeleteAction = true;
    public boolean supportsNullUniqueColumn = true;
    public boolean supportsDefaultDeleteAction = true;
    public boolean supportsRestrictUpdateAction = true;
    public boolean supportsCascadeUpdateAction = true;
    public boolean supportsNullUpdateAction = true;
    public boolean supportsDefaultUpdateAction = true;
    public boolean supportsAlterTableWithAddColumn = true;
    public boolean supportsAlterTableWithDropColumn = true;
    public boolean supportsComments = false;
    public Boolean supportsGetGeneratedKeys = null;
    public String reservedWords = null;
    public String systemSchemas = null;
    public String systemTables = null;
    public String selectWords = null;
    public String fixedSizeTypeNames = null;
    public String schemaCase = "upper";
    public boolean setStringRightTruncationOn = true;
    public String validationSQL = null;
    public String closePoolSQL = null;
    public String initializationSQL = null;
    public int joinSyntax = 0;
    public String outerJoinClause = "LEFT OUTER JOIN";
    public String innerJoinClause = "INNER JOIN";
    public String crossJoinClause = "CROSS JOIN";
    public boolean requiresConditionForCrossJoin = false;
    public String forUpdateClause = "FOR UPDATE";
    public String tableForUpdateClause = null;
    public String distinctCountColumnSeparator = null;
    public boolean supportsSelectForUpdate = true;
    public boolean supportsLockingWithDistinctClause = true;
    public boolean supportsLockingWithMultipleTables = true;
    public boolean supportsLockingWithOrderClause = true;
    public boolean supportsLockingWithOuterJoin = true;
    public boolean supportsLockingWithInnerJoin = true;
    public boolean supportsLockingWithSelectRange = true;
    public boolean supportsQueryTimeout = true;
    public boolean simulateLocking = false;
    public boolean supportsSubselect = true;
    public boolean supportsCorrelatedSubselect = true;
    public boolean supportsHaving = true;
    public boolean supportsSelectStartIndex = false;
    public boolean supportsSelectEndIndex = false;
    public int rangePosition = 0;
    public boolean requiresAliasForSubselect = false;
    public boolean requiresTargetForDelete = false;
    public boolean allowsAliasInBulkClause = true;
    public boolean supportsMultipleNontransactionalResultSets = true;
    public boolean requiresSearchStringEscapeForLike = true;
    public String searchStringEscape = "\\";
    public boolean requiresCastForMathFunctions = false;
    public boolean requiresCastForComparisons = false;
    public boolean supportsModOperator = false;
    public boolean supportsXMLColumn = false;
    public boolean supportsCaseConversionForLob = false;
    public boolean reportsSuccessNoInfoOnBatchUpdates = false;
    public boolean supportsSelectFromFinalTable = false;
    public boolean supportsSimpleCaseExpression = true;
    public boolean supportsGeneralCaseExpression = true;
    public boolean useWildCardForCount = false;
    public boolean trimSchemaName = false;
    public String castFunction = "CAST({0} AS {1})";
    public String toLowerCaseFunction = "LOWER({0})";
    public String toUpperCaseFunction = "UPPER({0})";
    public String stringLengthFunction = "CHAR_LENGTH({0})";
    public String bitLengthFunction = "(OCTET_LENGTH({0}) * 8)";
    public String trimLeadingFunction = "TRIM(LEADING {1} FROM {0})";
    public String trimTrailingFunction = "TRIM(TRAILING {1} FROM {0})";
    public String trimBothFunction = "TRIM(BOTH {1} FROM {0})";
    public String concatenateFunction = "({0}||{1})";
    public String concatenateDelimiter = "'OPENJPATOKEN'";
    public String substringFunctionName = "SUBSTRING";
    public String currentDateFunction = "CURRENT_DATE";
    public String currentTimeFunction = "CURRENT_TIME";
    public String currentTimestampFunction = "CURRENT_TIMESTAMP";
    public String dropTableSQL = "DROP TABLE {0}";
    public boolean storageLimitationsFatal = false;
    public boolean storeLargeNumbersAsStrings = false;
    public boolean storeCharsAsNumbers = true;
    public boolean useGetBytesForBlobs = false;
    public boolean useSetBytesForBlobs = false;
    public boolean useGetObjectForBlobs = false;
    public boolean useGetStringForClobs = false;
    public boolean useSetStringForClobs = false;
    public int maxEmbeddedBlobSize = -1;
    public int maxEmbeddedClobSize = -1;
    public int inClauseLimit = -1;
    public int datePrecision = 1000000;
    public int characterColumnSize = 255;
    public String arrayTypeName = "ARRAY";
    public String bigintTypeName = "BIGINT";
    public String binaryTypeName = "BINARY";
    public String bitTypeName = "BIT";
    public String blobTypeName = "BLOB";
    public String booleanTypeName = "BOOLEAN";
    public String charTypeName = "CHAR";
    public String clobTypeName = "CLOB";
    public String dateTypeName = "DATE";
    public String decimalTypeName = "DECIMAL";
    public String distinctTypeName = "DISTINCT";
    public String doubleTypeName = "DOUBLE";
    public String floatTypeName = "FLOAT";
    public String integerTypeName = "INTEGER";
    public String javaObjectTypeName = "JAVA_OBJECT";
    public String longVarbinaryTypeName = "LONGVARBINARY";
    public String longVarcharTypeName = "LONGVARCHAR";
    public String nullTypeName = "NULL";
    public String numericTypeName = "NUMERIC";
    public String otherTypeName = "OTHER";
    public String realTypeName = "REAL";
    public String refTypeName = "REF";
    public String smallintTypeName = "SMALLINT";
    public String structTypeName = "STRUCT";
    public String timeTypeName = "TIME";
    public String timestampTypeName = "TIMESTAMP";
    public String tinyintTypeName = "TINYINT";
    public String varbinaryTypeName = "VARBINARY";
    public String varcharTypeName = "VARCHAR";
    public String xmlTypeName = "XML";
    public String xmlTypeEncoding = "UTF-8";
    public String getStringVal = "";
    public boolean useSchemaName = true;
    public String tableTypes = "TABLE";
    public boolean supportsSchemaForGetTables = true;
    public boolean supportsSchemaForGetColumns = true;
    public boolean supportsNullTableForGetColumns = true;
    public boolean supportsNullTableForGetPrimaryKeys = false;
    public boolean supportsNullTableForGetIndexInfo = false;
    public boolean supportsNullTableForGetImportedKeys = false;
    public boolean useGetBestRowIdentifierForPrimaryKeys = false;
    public boolean requiresAutoCommitForMetaData = false;
    public boolean tableLengthIncludesSchema = false;
    public int maxAutoAssignNameLength = 31;
    public String autoAssignClause = null;
    public String autoAssignTypeName = null;
    public boolean supportsAutoAssign = false;
    public String lastGeneratedKeyQuery = null;
    public String nextSequenceQuery = null;
    public String sequenceSQL = null;
    public String sequenceSchemaSQL = null;
    public String sequenceNameSQL = null;
    public int nativeSequenceType = 3;
    @Deprecated
    public boolean useNativeSequenceCache = true;
    @Deprecated
    private boolean logNativeSequenceCacheWarning = true;
    protected JDBCConfiguration conf = null;
    protected Log log = null;
    protected boolean connected = false;
    protected boolean isJDBC3 = false;
    protected boolean isJDBC4 = false;
    protected final Set<String> reservedWordSet = new HashSet<String>();
    protected Set<String> invalidColumnWordSet = new HashSet<String>();
    protected final Set<String> systemSchemaSet = new HashSet<String>();
    protected final Set<String> systemTableSet = new HashSet<String>();
    protected final Set<String> fixedSizeTypeNameSet = new HashSet<String>();
    protected final Set<String> typeModifierSet = new HashSet<String>();
    private boolean delimitIdentifiers = false;
    public boolean supportsDelimitedIdentifiers = true;
    public String leadingDelimiter = "\"";
    public String trailingDelimiter = "\"";
    public String nameConcatenator = "_";
    public String delimitedCase = "preserve";
    public String catalogSeparator = ".";
    protected String defaultSchemaName = null;
    private String conversionKey = null;
    private DBIdentifierUtil namingUtil = null;
    private Map<String, IdentifierRule> namingRules = new HashMap<String, IdentifierRule>();
    private IdentifierRule defaultNamingRule = null;
    protected final Set selectWordSet = new HashSet();
    private Set _precisionWarnedTypes = null;
    public int batchLimit = 0;
    public final Map<Integer, Set<String>> sqlStateCodes = new HashMap<Integer, Set<String>>();
    protected ProxyManager _proxyManager;

    public DBDictionary() {
        this.fixedSizeTypeNameSet.addAll(Arrays.asList("BIGINT", "BIT", "BLOB", "CLOB", "DATE", "DECIMAL", "DISTINCT", "DOUBLE", "FLOAT", "INTEGER", "JAVA_OBJECT", "NULL", "NUMERIC", "OTHER", "REAL", "REF", "SMALLINT", "STRUCT", "TIME", "TIMESTAMP", "TINYINT"));
        this.selectWordSet.add("SELECT");
    }

    public void connectedConfiguration(Connection conn) throws SQLException {
        if (!this.connected) {
            DatabaseMetaData metaData;
            block8: {
                metaData = null;
                try {
                    metaData = conn.getMetaData();
                    try {
                        int JDBCMajorVersion = metaData.getJDBCMajorVersion();
                        this.isJDBC3 = JDBCMajorVersion >= 3;
                        this.isJDBC4 = JDBCMajorVersion >= 4;
                    }
                    catch (Throwable t) {}
                }
                catch (Exception e) {
                    if (!this.log.isTraceEnabled()) break block8;
                    this.log.trace(e.toString(), e);
                }
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace(DBDictionaryFactory.toString(metaData));
                if (this.isJDBC3) {
                    this.log.trace(_loc.get("connection-defaults", new Object[]{conn.getAutoCommit(), conn.getHoldability(), conn.getTransactionIsolation()}));
                }
            }
            this.configureNamingUtil(metaData);
            if (this.supportsGetGeneratedKeys == null) {
                this.supportsGetGeneratedKeys = this.isJDBC3 ? Boolean.valueOf(metaData.supportsGetGeneratedKeys()) : Boolean.valueOf(false);
            }
        }
        this.connected = true;
    }

    private void configureNamingUtil(DatabaseMetaData metaData) {
        this.setSupportsDelimitedIdentifiers(metaData);
        this.setDelimitedCase(metaData);
    }

    protected void configureNamingRules() {
        DBIdentifierRule defRule = new DBIdentifierRule(DBIdentifier.DBIdentifierType.DEFAULT, this.reservedWordSet);
        this.namingRules.put(defRule.getName(), defRule);
        ColumnDefIdentifierRule cdRule = new ColumnDefIdentifierRule();
        cdRule.setCanDelimit(false);
        this.namingRules.put(cdRule.getName(), cdRule);
    }

    public Array getArray(ResultSet rs, int column) throws SQLException {
        return rs.getArray(column);
    }

    public InputStream getAsciiStream(ResultSet rs, int column) throws SQLException {
        return rs.getAsciiStream(column);
    }

    public BigDecimal getBigDecimal(ResultSet rs, int column) throws SQLException {
        if (this.storeLargeNumbersAsStrings) {
            String str = this.getString(rs, column);
            return str == null ? null : new BigDecimal(str);
        }
        return rs.getBigDecimal(column);
    }

    public Number getNumber(ResultSet rs, int column) throws SQLException {
        try {
            return this.getBigDecimal(rs, column);
        }
        catch (Exception e1) {
            try {
                return this.getDouble(rs, column);
            }
            catch (Exception e2) {
                try {
                    return Float.valueOf(this.getFloat(rs, column));
                }
                catch (Exception e3) {
                    try {
                        return this.getLong(rs, column);
                    }
                    catch (Exception e4) {
                        try {
                            return this.getInt(rs, column);
                        }
                        catch (Exception e5) {
                            if (e1 instanceof RuntimeException) {
                                throw (RuntimeException)e1;
                            }
                            if (e1 instanceof SQLException) {
                                throw (SQLException)e1;
                            }
                            return null;
                        }
                    }
                }
            }
        }
    }

    public BigInteger getBigInteger(ResultSet rs, int column) throws SQLException {
        if (this.storeLargeNumbersAsStrings) {
            String str = this.getString(rs, column);
            return str == null ? null : new BigDecimal(str).toBigInteger();
        }
        BigDecimal bd = this.getBigDecimal(rs, column);
        return bd == null ? null : bd.toBigInteger();
    }

    public InputStream getBinaryStream(ResultSet rs, int column) throws SQLException {
        return rs.getBinaryStream(column);
    }

    public InputStream getLOBStream(JDBCStore store, ResultSet rs, int column) throws SQLException {
        return rs.getBinaryStream(column);
    }

    public Blob getBlob(ResultSet rs, int column) throws SQLException {
        return rs.getBlob(column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getBlobObject(ResultSet rs, int column, JDBCStore store) throws SQLException {
        Object object;
        InputStream in = null;
        if (this.useGetBytesForBlobs || this.useGetObjectForBlobs) {
            byte[] bytes = this.getBytes(rs, column);
            if (bytes != null && bytes.length > 0) {
                in = new ByteArrayInputStream(bytes);
            }
        } else {
            Blob blob = this.getBlob(rs, column);
            if (blob != null && blob.length() > 0L) {
                in = blob.getBinaryStream();
            }
        }
        if (in == null) {
            return null;
        }
        if (store == null) {
            object = Serialization.deserialize(in, null);
            return object;
        }
        object = Serialization.deserialize(in, store.getContext());
        return object;
        finally {
            try {
                in.close();
            }
            catch (IOException ioe) {}
        }
    }

    public boolean getBoolean(ResultSet rs, int column) throws SQLException {
        return rs.getBoolean(column);
    }

    public byte getByte(ResultSet rs, int column) throws SQLException {
        return rs.getByte(column);
    }

    public byte[] getBytes(ResultSet rs, int column) throws SQLException {
        if (this.useGetBytesForBlobs) {
            return rs.getBytes(column);
        }
        if (this.useGetObjectForBlobs) {
            return (byte[])rs.getObject(column);
        }
        Blob blob = this.getBlob(rs, column);
        if (blob == null) {
            return null;
        }
        int length = (int)blob.length();
        if (length == 0) {
            return null;
        }
        return blob.getBytes(1L, length);
    }

    public Calendar getCalendar(ResultSet rs, int column) throws SQLException {
        Date d = this.getDate(rs, column);
        if (d == null) {
            return null;
        }
        Calendar cal = (Calendar)((Object)this.getProxyManager().newCalendarProxy(GregorianCalendar.class, null));
        cal.setTime(d);
        return cal;
    }

    private ProxyManager getProxyManager() {
        if (this._proxyManager == null) {
            this._proxyManager = this.conf.getProxyManagerInstance();
        }
        return this._proxyManager;
    }

    public char getChar(ResultSet rs, int column) throws SQLException {
        if (this.storeCharsAsNumbers) {
            return (char)this.getInt(rs, column);
        }
        String str = this.getString(rs, column);
        return StringUtils.isEmpty((String)str) ? (char)'\u0000' : str.charAt(0);
    }

    public Reader getCharacterStream(ResultSet rs, int column) throws SQLException {
        return rs.getCharacterStream(column);
    }

    public Clob getClob(ResultSet rs, int column) throws SQLException {
        return rs.getClob(column);
    }

    public String getClobString(ResultSet rs, int column) throws SQLException {
        if (this.useGetStringForClobs) {
            return rs.getString(column);
        }
        Clob clob = this.getClob(rs, column);
        if (clob == null) {
            return null;
        }
        if (clob.length() == 0L) {
            return "";
        }
        return clob.getSubString(1L, (int)clob.length());
    }

    public Date getDate(ResultSet rs, int column) throws SQLException {
        Timestamp tstamp = this.getTimestamp(rs, column, null);
        if (tstamp == null) {
            return null;
        }
        int fractional = (int)Math.round((double)tstamp.getNanos() / 1000000.0);
        long millis = tstamp.getTime() / 1000L * 1000L;
        return new Date(millis + (long)fractional);
    }

    public java.sql.Date getDate(ResultSet rs, int column, Calendar cal) throws SQLException {
        if (cal == null) {
            return rs.getDate(column);
        }
        return rs.getDate(column, cal);
    }

    public double getDouble(ResultSet rs, int column) throws SQLException {
        return rs.getDouble(column);
    }

    public float getFloat(ResultSet rs, int column) throws SQLException {
        return rs.getFloat(column);
    }

    public int getInt(ResultSet rs, int column) throws SQLException {
        return rs.getInt(column);
    }

    public Locale getLocale(ResultSet rs, int column) throws SQLException {
        String str = this.getString(rs, column);
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        String[] params = Strings.split((String)str, (String)"_", (int)3);
        if (params.length < 3) {
            return null;
        }
        return new Locale(params[0], params[1], params[2]);
    }

    public long getLong(ResultSet rs, int column) throws SQLException {
        return rs.getLong(column);
    }

    public Object getObject(ResultSet rs, int column, Map map) throws SQLException {
        if (map == null) {
            return rs.getObject(column);
        }
        return rs.getObject(column, map);
    }

    public Ref getRef(ResultSet rs, int column, Map map) throws SQLException {
        return rs.getRef(column);
    }

    public short getShort(ResultSet rs, int column) throws SQLException {
        return rs.getShort(column);
    }

    public String getString(ResultSet rs, int column) throws SQLException {
        return rs.getString(column);
    }

    public Time getTime(ResultSet rs, int column, Calendar cal) throws SQLException {
        if (cal == null) {
            return rs.getTime(column);
        }
        return rs.getTime(column, cal);
    }

    public Timestamp getTimestamp(ResultSet rs, int column, Calendar cal) throws SQLException {
        if (cal == null) {
            return rs.getTimestamp(column);
        }
        return rs.getTimestamp(column, cal);
    }

    public void setArray(PreparedStatement stmnt, int idx, Array val, Column col) throws SQLException {
        stmnt.setArray(idx, val);
    }

    public void setAsciiStream(PreparedStatement stmnt, int idx, InputStream val, int length, Column col) throws SQLException {
        stmnt.setAsciiStream(idx, val, length);
    }

    public void setBigDecimal(PreparedStatement stmnt, int idx, BigDecimal val, Column col) throws SQLException {
        if (col != null && col.isCompatible(12, null, 0, 0) || col == null && this.storeLargeNumbersAsStrings) {
            this.setString(stmnt, idx, val.toString(), col);
        } else {
            stmnt.setBigDecimal(idx, val);
        }
    }

    public void setBigInteger(PreparedStatement stmnt, int idx, BigInteger val, Column col) throws SQLException {
        if (col != null && col.isCompatible(12, null, 0, 0) || col == null && this.storeLargeNumbersAsStrings) {
            this.setString(stmnt, idx, val.toString(), col);
        } else {
            this.setBigDecimal(stmnt, idx, new BigDecimal(val), col);
        }
    }

    public void setBinaryStream(PreparedStatement stmnt, int idx, InputStream val, int length, Column col) throws SQLException {
        stmnt.setBinaryStream(idx, val, length);
    }

    public void setBlob(PreparedStatement stmnt, int idx, Blob val, Column col) throws SQLException {
        stmnt.setBlob(idx, val);
    }

    public void setBlobObject(PreparedStatement stmnt, int idx, Object val, Column col, JDBCStore store) throws SQLException {
        this.setBytes(stmnt, idx, this.serialize(val, store), col);
    }

    public void setBoolean(PreparedStatement stmnt, int idx, boolean val, Column col) throws SQLException {
        stmnt.setInt(idx, val ? 1 : 0);
    }

    public void setByte(PreparedStatement stmnt, int idx, byte val, Column col) throws SQLException {
        stmnt.setByte(idx, val);
    }

    public void setBytes(PreparedStatement stmnt, int idx, byte[] val, Column col) throws SQLException {
        if (this.useSetBytesForBlobs) {
            stmnt.setBytes(idx, val);
        } else {
            this.setBinaryStream(stmnt, idx, new ByteArrayInputStream(val), val.length, col);
        }
    }

    public void setChar(PreparedStatement stmnt, int idx, char val, Column col) throws SQLException {
        if (col != null && col.isCompatible(4, null, 0, 0) || col == null && this.storeCharsAsNumbers) {
            this.setInt(stmnt, idx, val, col);
        } else {
            this.setString(stmnt, idx, String.valueOf(val), col);
        }
    }

    public void setCharacterStream(PreparedStatement stmnt, int idx, Reader val, int length, Column col) throws SQLException {
        stmnt.setCharacterStream(idx, val, length);
    }

    public void setClob(PreparedStatement stmnt, int idx, Clob val, Column col) throws SQLException {
        stmnt.setClob(idx, val);
    }

    public void setClobString(PreparedStatement stmnt, int idx, String val, Column col) throws SQLException {
        if (this.useSetStringForClobs) {
            stmnt.setString(idx, val);
        } else {
            StringReader in = new StringReader(val);
            this.setCharacterStream(stmnt, idx, in, val.length(), col);
        }
    }

    public void setDate(PreparedStatement stmnt, int idx, Date val, Column col) throws SQLException {
        if (col != null && col.getType() == 91) {
            this.setDate(stmnt, idx, new java.sql.Date(val.getTime()), null, col);
        } else if (col != null && col.getType() == 92) {
            this.setTime(stmnt, idx, new Time(val.getTime()), null, col);
        } else if (val instanceof Timestamp) {
            this.setTimestamp(stmnt, idx, (Timestamp)val, null, col);
        } else {
            this.setTimestamp(stmnt, idx, new Timestamp(val.getTime()), null, col);
        }
    }

    public void setDate(PreparedStatement stmnt, int idx, java.sql.Date val, Calendar cal, Column col) throws SQLException {
        if (cal == null) {
            stmnt.setDate(idx, val);
        } else {
            stmnt.setDate(idx, val, cal);
        }
    }

    public void setCalendar(PreparedStatement stmnt, int idx, Calendar val, Column col) throws SQLException {
        this.setDate(stmnt, idx, val.getTime(), col);
    }

    public void setDouble(PreparedStatement stmnt, int idx, double val, Column col) throws SQLException {
        stmnt.setDouble(idx, val);
    }

    public void setFloat(PreparedStatement stmnt, int idx, float val, Column col) throws SQLException {
        stmnt.setFloat(idx, val);
    }

    public void setInt(PreparedStatement stmnt, int idx, int val, Column col) throws SQLException {
        stmnt.setInt(idx, val);
    }

    public void setLong(PreparedStatement stmnt, int idx, long val, Column col) throws SQLException {
        stmnt.setLong(idx, val);
    }

    public void setLocale(PreparedStatement stmnt, int idx, Locale val, Column col) throws SQLException {
        this.setString(stmnt, idx, val.getLanguage() + "_" + val.getCountry() + "_" + val.getVariant(), col);
    }

    public void setNull(PreparedStatement stmnt, int idx, int colType, Column col) throws SQLException {
        stmnt.setNull(idx, colType);
    }

    public void setNumber(PreparedStatement stmnt, int idx, Number num, Column col) throws SQLException {
        if (num instanceof Double) {
            this.setDouble(stmnt, idx, (Double)num, col);
        } else if (num instanceof Float) {
            this.setFloat(stmnt, idx, ((Float)num).floatValue(), col);
        } else {
            this.setBigDecimal(stmnt, idx, new BigDecimal(num.toString()), col);
        }
    }

    public void setObject(PreparedStatement stmnt, int idx, Object val, int colType, Column col) throws SQLException {
        if (colType == -1 || colType == 1111) {
            stmnt.setObject(idx, val);
        } else {
            stmnt.setObject(idx, val, colType);
        }
    }

    public void setRef(PreparedStatement stmnt, int idx, Ref val, Column col) throws SQLException {
        stmnt.setRef(idx, val);
    }

    public void setShort(PreparedStatement stmnt, int idx, short val, Column col) throws SQLException {
        stmnt.setShort(idx, val);
    }

    public void setString(PreparedStatement stmnt, int idx, String val, Column col) throws SQLException {
        stmnt.setString(idx, val);
    }

    public void setTime(PreparedStatement stmnt, int idx, Time val, Calendar cal, Column col) throws SQLException {
        if (cal == null) {
            stmnt.setTime(idx, val);
        } else {
            stmnt.setTime(idx, val, cal);
        }
    }

    public void setTimestamp(PreparedStatement stmnt, int idx, Timestamp val, Calendar cal, Column col) throws SQLException {
        int rounded = (int)Math.round((double)val.getNanos() / (double)this.datePrecision);
        int nanos = rounded * this.datePrecision;
        if (nanos > 999999999) {
            val.setTime(val.getTime() + 1000L);
            nanos = 0;
        }
        val.setNanos(nanos);
        if (cal == null) {
            stmnt.setTimestamp(idx, val);
        } else {
            stmnt.setTimestamp(idx, val, cal);
        }
    }

    public void setTyped(PreparedStatement stmnt, int idx, Object val, Column col, int type, JDBCStore store) throws SQLException {
        if (val == null) {
            this.setNull(stmnt, idx, col == null ? 1111 : col.getType(), col);
            return;
        }
        switch (type) {
            case 0: 
            case 16: {
                this.setBoolean(stmnt, idx, (Boolean)val, col);
                break;
            }
            case 1: 
            case 17: {
                this.setByte(stmnt, idx, ((Number)val).byteValue(), col);
                break;
            }
            case 2: 
            case 18: {
                this.setChar(stmnt, idx, ((Character)val).charValue(), col);
                break;
            }
            case 3: 
            case 19: {
                this.setDouble(stmnt, idx, ((Number)val).doubleValue(), col);
                break;
            }
            case 4: 
            case 20: {
                this.setFloat(stmnt, idx, ((Number)val).floatValue(), col);
                break;
            }
            case 5: 
            case 21: {
                this.setInt(stmnt, idx, ((Number)val).intValue(), col);
                break;
            }
            case 6: 
            case 22: {
                this.setLong(stmnt, idx, ((Number)val).longValue(), col);
                break;
            }
            case 7: 
            case 23: {
                this.setShort(stmnt, idx, ((Number)val).shortValue(), col);
                break;
            }
            case 9: {
                if (col != null && (col.getType() == 2005 || col.getType() == -1)) {
                    this.setClobString(stmnt, idx, (String)val, col);
                    break;
                }
                if (val instanceof String) {
                    this.setString(stmnt, idx, (String)val, col);
                    break;
                }
                this.setString(stmnt, idx, val.toString(), col);
                break;
            }
            case 8: {
                this.setBlobObject(stmnt, idx, val, col, store);
                break;
            }
            case 14: {
                this.setDate(stmnt, idx, (Date)val, col);
                break;
            }
            case 28: {
                this.setCalendar(stmnt, idx, (Calendar)val, col);
                break;
            }
            case 24: {
                this.setBigDecimal(stmnt, idx, (BigDecimal)val, col);
                break;
            }
            case 25: {
                this.setBigInteger(stmnt, idx, (BigInteger)val, col);
                break;
            }
            case 10: {
                this.setNumber(stmnt, idx, (Number)val, col);
                break;
            }
            case 26: {
                this.setLocale(stmnt, idx, (Locale)val, col);
                break;
            }
            case 1000: {
                this.setArray(stmnt, idx, (Array)val, col);
                break;
            }
            case 1001: {
                Sized s = (Sized)val;
                this.setAsciiStream(stmnt, idx, (InputStream)s.value, s.size, col);
                break;
            }
            case 1002: {
                Sized s = (Sized)val;
                this.setBinaryStream(stmnt, idx, (InputStream)s.value, s.size, col);
                break;
            }
            case 1003: {
                this.setBlob(stmnt, idx, (Blob)val, col);
                break;
            }
            case 1004: {
                this.setBytes(stmnt, idx, (byte[])val, col);
                break;
            }
            case 1005: {
                Sized s = (Sized)val;
                this.setCharacterStream(stmnt, idx, (Reader)s.value, s.size, col);
                break;
            }
            case 1006: {
                this.setClob(stmnt, idx, (Clob)val, col);
                break;
            }
            case 1007: {
                if (val instanceof Calendard) {
                    Calendard c = (Calendard)val;
                    this.setDate(stmnt, idx, (java.sql.Date)c.value, c.calendar, col);
                    break;
                }
                this.setDate(stmnt, idx, (java.sql.Date)val, null, col);
                break;
            }
            case 1009: {
                this.setRef(stmnt, idx, (Ref)val, col);
                break;
            }
            case 1010: {
                if (val instanceof Calendard) {
                    Calendard c = (Calendard)val;
                    this.setTime(stmnt, idx, (Time)c.value, c.calendar, col);
                    break;
                }
                this.setTime(stmnt, idx, (Time)val, null, col);
                break;
            }
            case 1011: {
                if (val instanceof Calendard) {
                    Calendard c = (Calendard)val;
                    this.setTimestamp(stmnt, idx, (Timestamp)c.value, c.calendar, col);
                    break;
                }
                this.setTimestamp(stmnt, idx, (Timestamp)val, null, col);
                break;
            }
            default: {
                if (col != null && (col.getType() == 2004 || col.getType() == -3)) {
                    this.setBlobObject(stmnt, idx, val, col, store);
                    break;
                }
                this.setObject(stmnt, idx, val, col.getType(), col);
            }
        }
    }

    public void setUnknown(PreparedStatement stmnt, int idx, Object val, Column col) throws SQLException {
        Sized sized = null;
        Calendard cald = null;
        if (val instanceof Sized) {
            sized = (Sized)val;
            val = sized.value;
        } else if (val instanceof Calendard) {
            cald = (Calendard)val;
            val = cald.value;
        }
        if (val == null) {
            this.setNull(stmnt, idx, col == null ? 1111 : col.getType(), col);
        } else if (val instanceof String) {
            this.setString(stmnt, idx, val.toString(), col);
        } else if (val instanceof Integer) {
            this.setInt(stmnt, idx, (Integer)val, col);
        } else if (val instanceof Boolean) {
            this.setBoolean(stmnt, idx, (Boolean)val, col);
        } else if (val instanceof Long) {
            this.setLong(stmnt, idx, (Long)val, col);
        } else if (val instanceof Float) {
            this.setFloat(stmnt, idx, ((Float)val).floatValue(), col);
        } else if (val instanceof Double) {
            this.setDouble(stmnt, idx, (Double)val, col);
        } else if (val instanceof Byte) {
            this.setByte(stmnt, idx, (Byte)val, col);
        } else if (val instanceof Character) {
            this.setChar(stmnt, idx, ((Character)val).charValue(), col);
        } else if (val instanceof Short) {
            this.setShort(stmnt, idx, (Short)val, col);
        } else if (val instanceof Locale) {
            this.setLocale(stmnt, idx, (Locale)val, col);
        } else if (val instanceof BigDecimal) {
            this.setBigDecimal(stmnt, idx, (BigDecimal)val, col);
        } else if (val instanceof BigInteger) {
            this.setBigInteger(stmnt, idx, (BigInteger)val, col);
        } else if (val instanceof Array) {
            this.setArray(stmnt, idx, (Array)val, col);
        } else if (val instanceof Blob) {
            this.setBlob(stmnt, idx, (Blob)val, col);
        } else if (val instanceof byte[]) {
            this.setBytes(stmnt, idx, (byte[])val, col);
        } else if (val instanceof Clob) {
            this.setClob(stmnt, idx, (Clob)val, col);
        } else if (val instanceof Ref) {
            this.setRef(stmnt, idx, (Ref)val, col);
        } else if (val instanceof java.sql.Date) {
            this.setDate(stmnt, idx, (java.sql.Date)val, cald == null ? null : cald.calendar, col);
        } else if (val instanceof Timestamp) {
            this.setTimestamp(stmnt, idx, (Timestamp)val, cald == null ? null : cald.calendar, col);
        } else if (val instanceof Time) {
            this.setTime(stmnt, idx, (Time)val, cald == null ? null : cald.calendar, col);
        } else if (val instanceof Date) {
            this.setDate(stmnt, idx, (Date)val, col);
        } else if (val instanceof Calendar) {
            this.setDate(stmnt, idx, ((Calendar)val).getTime(), col);
        } else if (val instanceof Reader) {
            this.setCharacterStream(stmnt, idx, (Reader)val, sized == null ? 0 : sized.size, col);
        } else {
            throw new UserException(_loc.get("bad-param", val.getClass()));
        }
    }

    public byte[] serialize(Object val, JDBCStore store) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof SerializedData) {
            return ((SerializedData)val).bytes;
        }
        return Serialization.serialize(val, store.getContext());
    }

    public void putBytes(Blob blob, byte[] data) throws SQLException {
        blob.setBytes(1L, data);
    }

    public void putString(Clob clob, String data) throws SQLException {
        clob.setString(1L, data);
    }

    public void putChars(Clob clob, char[] data) throws SQLException {
        Writer writer = clob.setCharacterStream(1L);
        try {
            writer.write(data);
            writer.flush();
        }
        catch (IOException ioe) {
            throw new SQLException(ioe.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storageWarning(Object orig, Object converted) {
        boolean warn;
        DBDictionary dBDictionary = this;
        synchronized (dBDictionary) {
            if (this._precisionWarnedTypes == null) {
                this._precisionWarnedTypes = new HashSet();
            }
            warn = this._precisionWarnedTypes.add(orig.getClass());
        }
        if (this.storageLimitationsFatal || warn && this.log.isWarnEnabled() || !warn && this.log.isTraceEnabled()) {
            Localizer.Message msg = _loc.get("storage-restriction", new Object[]{this.platform, orig, orig.getClass().getName(), converted});
            if (this.storageLimitationsFatal) {
                throw new StoreException(msg);
            }
            if (warn) {
                this.log.warn(msg);
            } else {
                this.log.trace(msg);
            }
        }
    }

    public int getJDBCType(int metaTypeCode, boolean lob) {
        return this.getJDBCType(metaTypeCode, lob, 0, 0);
    }

    public int getJDBCType(int metaTypeCode, boolean lob, int precis, int scale, boolean xml) {
        return this.getJDBCType(metaTypeCode, lob, precis, scale);
    }

    public int getJDBCType(int metaTypeCode, boolean lob, int precis, int scale) {
        if (lob) {
            switch (metaTypeCode) {
                case 9: 
                case 1001: 
                case 1005: {
                    return this.getPreferredType(2005);
                }
            }
            return this.getPreferredType(2004);
        }
        switch (metaTypeCode) {
            case 0: 
            case 16: {
                return this.getPreferredType(-7);
            }
            case 1: 
            case 17: {
                return this.getPreferredType(-6);
            }
            case 2: 
            case 18: {
                if (this.storeCharsAsNumbers) {
                    return this.getPreferredType(4);
                }
                return this.getPreferredType(1);
            }
            case 3: 
            case 19: {
                if (precis > 0 || scale > 0) {
                    return this.getPreferredType(2);
                }
                return this.getPreferredType(8);
            }
            case 4: 
            case 20: {
                if (precis > 0 || scale > 0) {
                    return this.getPreferredType(2);
                }
                return this.getPreferredType(7);
            }
            case 5: 
            case 21: {
                return this.getPreferredType(4);
            }
            case 6: 
            case 22: {
                return this.getPreferredType(-5);
            }
            case 7: 
            case 23: {
                return this.getPreferredType(5);
            }
            case 9: 
            case 26: 
            case 1001: 
            case 1005: {
                return this.getPreferredType(12);
            }
            case 25: {
                if (this.storeLargeNumbersAsStrings) {
                    return this.getPreferredType(12);
                }
                return this.getPreferredType(-5);
            }
            case 24: {
                if (this.storeLargeNumbersAsStrings) {
                    return this.getPreferredType(12);
                }
                return this.getPreferredType(2);
            }
            case 10: {
                if (this.storeLargeNumbersAsStrings) {
                    return this.getPreferredType(12);
                }
                return this.getPreferredType(2);
            }
            case 14: 
            case 28: {
                return this.getPreferredType(93);
            }
            case 1000: {
                return this.getPreferredType(2003);
            }
            case 1002: 
            case 1003: 
            case 1004: {
                return this.getPreferredType(2004);
            }
            case 1006: {
                return this.getPreferredType(2005);
            }
            case 1007: {
                return this.getPreferredType(91);
            }
            case 1010: {
                return this.getPreferredType(92);
            }
            case 1011: {
                return this.getPreferredType(93);
            }
        }
        return this.getPreferredType(2004);
    }

    public int getPreferredType(int type) {
        return type;
    }

    public String getTypeName(Column col) {
        if (!DBIdentifier.isEmpty(col.getTypeIdentifier())) {
            return this.appendSize(col, this.toDBName(col.getTypeIdentifier()));
        }
        if (col.isAutoAssigned() && this.autoAssignTypeName != null) {
            return this.appendSize(col, this.autoAssignTypeName);
        }
        return this.appendSize(col, this.getTypeName(col.getType()));
    }

    public String getTypeName(int type) {
        switch (type) {
            case 2003: {
                return this.arrayTypeName;
            }
            case -5: {
                return this.bigintTypeName;
            }
            case -2: {
                return this.binaryTypeName;
            }
            case -7: {
                return this.bitTypeName;
            }
            case 2004: {
                return this.blobTypeName;
            }
            case 16: {
                return this.booleanTypeName;
            }
            case 1: {
                return this.charTypeName;
            }
            case 2005: {
                return this.clobTypeName;
            }
            case 91: {
                return this.dateTypeName;
            }
            case 3: {
                return this.decimalTypeName;
            }
            case 2001: {
                return this.distinctTypeName;
            }
            case 8: {
                return this.doubleTypeName;
            }
            case 6: {
                return this.floatTypeName;
            }
            case 4: {
                return this.integerTypeName;
            }
            case 2000: {
                return this.javaObjectTypeName;
            }
            case -4: {
                return this.longVarbinaryTypeName;
            }
            case -1: {
                return this.longVarcharTypeName;
            }
            case 0: {
                return this.nullTypeName;
            }
            case 2: {
                return this.numericTypeName;
            }
            case 1111: {
                return this.otherTypeName;
            }
            case 7: {
                return this.realTypeName;
            }
            case 2006: {
                return this.refTypeName;
            }
            case 5: {
                return this.smallintTypeName;
            }
            case 2002: {
                return this.structTypeName;
            }
            case 92: {
                return this.timeTypeName;
            }
            case 93: {
                return this.timestampTypeName;
            }
            case -6: {
                return this.tinyintTypeName;
            }
            case -3: {
                return this.varbinaryTypeName;
            }
            case 12: {
                return this.varcharTypeName;
            }
        }
        return this.otherTypeName;
    }

    protected String appendSize(Column col, String typeName) {
        if (this.fixedSizeTypeNameSet.contains(typeName.toUpperCase())) {
            return typeName;
        }
        if (typeName.indexOf(40) != -1) {
            return typeName;
        }
        String size = null;
        if (col.getSize() > 0) {
            StringBuilder buf = new StringBuilder(10);
            buf.append("(").append(col.getSize());
            if (col.getDecimalDigits() > 0) {
                buf.append(", ").append(col.getDecimalDigits());
            }
            buf.append(")");
            size = buf.toString();
        }
        return this.insertSize(typeName, size);
    }

    protected String insertSize(String typeName, String size) {
        if (StringUtils.isEmpty((String)size)) {
            int idx = typeName.indexOf("{0}");
            if (idx != -1) {
                return typeName.substring(0, idx);
            }
            return typeName;
        }
        int idx = typeName.indexOf("{0}");
        if (idx != -1) {
            String ret = typeName.substring(0, idx);
            if (size != null) {
                ret = ret + size;
            }
            if (typeName.length() > idx + 3) {
                ret = ret + typeName.substring(idx + 3);
            }
            return ret;
        }
        if (!this.typeModifierSet.isEmpty()) {
            idx = typeName.length();
            int curIdx = -1;
            for (String s : this.typeModifierSet) {
                if (typeName.toUpperCase().indexOf(s) == -1 || (curIdx = typeName.toUpperCase().indexOf(s)) == -1 || curIdx >= idx) continue;
                idx = curIdx;
            }
            if (idx != typeName.length()) {
                String ret = typeName.substring(0, idx);
                ret = ret + size;
                ret = ret + ' ' + typeName.substring(idx);
                return ret;
            }
        }
        return typeName + size;
    }

    public void setJoinSyntax(String syntax) {
        if ("sql92".equals(syntax)) {
            this.joinSyntax = 0;
        } else if ("traditional".equals(syntax)) {
            this.joinSyntax = 1;
        } else if ("database".equals(syntax)) {
            this.joinSyntax = 2;
        } else if (!StringUtils.isEmpty((String)syntax)) {
            throw new IllegalArgumentException(syntax);
        }
    }

    public String getPlaceholderValueString(Column col) {
        switch (col.getType()) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 4: 
            case 5: {
                return "0";
            }
            case 1: {
                return this.storeCharsAsNumbers ? "0" : "' '";
            }
            case -1: 
            case 12: 
            case 2005: {
                return "''";
            }
            case 91: {
                return ZERO_DATE_STR;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return "0.0";
            }
            case 92: {
                return ZERO_TIME_STR;
            }
            case 93: {
                return ZERO_TIMESTAMP_STR;
            }
        }
        return "NULL";
    }

    public SQLBuffer toSelectCount(Select sel) {
        SQLBuffer selectSQL = new SQLBuffer(this);
        sel.addJoinClassConditions();
        SQLBuffer from = sel.getFromSelect() != null ? this.getFromSelect(sel, false) : this.getFrom(sel, false);
        SQLBuffer where = this.getWhere(sel, false);
        if (sel.getGrouping() == null && sel.getStartIndex() == 0L && sel.getEndIndex() == Long.MAX_VALUE) {
            List aliases;
            List list = aliases = !sel.isDistinct() ? Collections.EMPTY_LIST : sel.getIdentifierAliases();
            if (this.useWildCardForCount || aliases.isEmpty()) {
                selectSQL.append("COUNT(*)");
                return this.toSelect(selectSQL, null, from, where, null, null, null, false, false, 0L, Long.MAX_VALUE);
            }
            if (aliases.size() == 1) {
                selectSQL.append("COUNT(DISTINCT ").append(aliases.get(0).toString()).append(")");
                return this.toSelect(selectSQL, null, from, where, null, null, null, false, false, 0L, Long.MAX_VALUE);
            }
            if (this.distinctCountColumnSeparator != null) {
                selectSQL.append("COUNT(DISTINCT ");
                for (int i = 0; i < aliases.size(); ++i) {
                    if (i > 0) {
                        selectSQL.append(" ");
                        selectSQL.append(this.distinctCountColumnSeparator);
                        selectSQL.append(" ");
                    }
                    selectSQL.append(aliases.get(i).toString());
                }
                selectSQL.append(")");
                return this.toSelect(selectSQL, null, from, where, null, null, null, false, false, 0L, Long.MAX_VALUE);
            }
        }
        this.assertSupport(this.supportsSubselect, "SupportsSubselect");
        SQLBuffer subSelect = this.getSelects(sel, true, false);
        SQLBuffer subFrom = from;
        from = new SQLBuffer(this);
        from.append("(");
        from.append(this.toSelect(subSelect, null, subFrom, where, sel.getGrouping(), sel.getHaving(), null, sel.isDistinct(), false, sel.getStartIndex(), sel.getEndIndex(), true, sel));
        from.append(")");
        if (this.requiresAliasForSubselect) {
            from.append(" ").append("s");
        }
        selectSQL.append("COUNT(*)");
        return this.toSelect(selectSQL, null, from, null, null, null, null, false, false, 0L, Long.MAX_VALUE);
    }

    public SQLBuffer toDelete(ClassMapping mapping, Select sel, Object[] params) {
        return this.toBulkOperation(mapping, sel, null, params, null);
    }

    public SQLBuffer toUpdate(ClassMapping mapping, Select sel, JDBCStore store, Object[] params, Map updates) {
        return this.toBulkOperation(mapping, sel, store, params, updates);
    }

    protected SQLBuffer toBulkOperation(ClassMapping mapping, Select sel, JDBCStore store, Object[] params, Map updateParams) {
        SQLBuffer sql2 = new SQLBuffer(this);
        if (updateParams == null) {
            if (this.requiresTargetForDelete) {
                sql2.append("DELETE ");
                SQLBuffer deleteTargets = this.getDeleteTargets(sel);
                sql2.append(deleteTargets);
                sql2.append(" FROM ");
            } else {
                sql2.append("DELETE FROM ");
            }
        } else {
            sql2.append("UPDATE ");
        }
        sel.addJoinClassConditions();
        Collection<String> selectedTables = this.getSelectTableAliases(sel);
        if (selectedTables.size() == 1 && this.supportsSubselect && this.allowsAliasInBulkClause) {
            SQLBuffer from = sel.getFromSelect() != null ? this.getFromSelect(sel, false) : this.getFrom(sel, false);
            sql2.append(from);
            this.appendUpdates(sel, store, sql2, params, updateParams, this.allowsAliasInBulkClause);
            SQLBuffer where = sel.getWhere();
            if (where != null && !where.isEmpty()) {
                sql2.append(" WHERE ");
                sql2.append(where);
            }
            return sql2;
        }
        Table table = mapping.getTable();
        String tableName = this.getFullName(table, false);
        if (sel.getWhere() == null || sel.getWhere().isEmpty()) {
            sql2.append(tableName);
            this.appendUpdates(sel, store, sql2, params, updateParams, false);
            return sql2;
        }
        if (!this.supportsSubselect || !this.supportsCorrelatedSubselect) {
            return null;
        }
        Column[] pks = mapping.getPrimaryKeyColumns();
        sel.clearSelects();
        sel.setDistinct(true);
        if (pks.length == 1) {
            sel.select(pks[0]);
            sql2.append(tableName);
            this.appendUpdates(sel, store, sql2, params, updateParams, false);
            sql2.append(" WHERE ").append(pks[0]).append(" IN (").append(sel.toSelect(false, null)).append(")");
        } else {
            sel.clearSelects();
            sel.setDistinct(false);
            sel.select("1", null);
            Column[] cols = table.getPrimaryKey().getColumns();
            SQLBuffer buf = new SQLBuffer(this);
            buf.append("(");
            for (int i = 0; i < cols.length; ++i) {
                if (i > 0) {
                    buf.append(" AND ");
                }
                buf.append(sel.getColumnAlias(cols[i])).append(" = ").append(table).append(this.catalogSeparator).append(cols[i]);
            }
            buf.append(")");
            sel.where(buf, null);
            sql2.append(tableName);
            this.appendUpdates(sel, store, sql2, params, updateParams, false);
            sql2.append(" WHERE EXISTS (").append(sel.toSelect(false, null)).append(")");
        }
        return sql2;
    }

    protected Collection<String> getSelectTableAliases(Select sel) {
        return sel.getTableAliases();
    }

    protected SQLBuffer getDeleteTargets(Select sel) {
        SQLBuffer deleteTargets = new SQLBuffer(this);
        Collection aliases = sel.getTableAliases();
        Iterator itr = aliases.iterator();
        while (itr.hasNext()) {
            String tableAlias = (String)itr.next();
            String[] names = Normalizer.splitName(tableAlias, " ");
            if (names.length > 1) {
                if (this.allowsAliasInBulkClause) {
                    deleteTargets.append(names[1]);
                } else {
                    deleteTargets.append(this.toDBName(DBIdentifier.newTable(names[0])));
                }
            } else {
                deleteTargets.append(this.toDBName(DBIdentifier.newTable(tableAlias)));
            }
            if (!itr.hasNext()) continue;
            deleteTargets.append(", ");
        }
        return deleteTargets;
    }

    protected void appendUpdates(Select sel, JDBCStore store, SQLBuffer sql2, Object[] params, Map updateParams, boolean allowAlias) {
        if (updateParams == null || updateParams.size() == 0) {
            return;
        }
        sql2.append(" SET ");
        ExpContext ctx = new ExpContext(store, params, store.getFetchConfiguration());
        boolean augmentUpdates = true;
        Iterator i = updateParams.entrySet().iterator();
        while (i.hasNext()) {
            Val val;
            Map.Entry next = i.next();
            Path path = (Path)next.getKey();
            FieldMapping fmd = (FieldMapping)path.last();
            if (fmd.isVersion()) {
                augmentUpdates = false;
            }
            if ((val = (Val)next.getValue()) == null) {
                val = new Null();
            }
            Column col = fmd.getColumns()[0];
            if (allowAlias) {
                sql2.append(sel.getColumnAlias(col));
            } else {
                sql2.append(this.toDBName(col.getIdentifier()));
            }
            sql2.append(" = ");
            ExpState state = val.initialize(sel, ctx, 0);
            ExpState pathState = ((Val)((Object)path)).initialize(sel, ctx, 0);
            this.calculateValue(val, sel, ctx, state, path, pathState);
            int length = val.length(sel, ctx, state);
            for (int j = 0; j < length; ++j) {
                val.appendTo(allowAlias ? sel : null, ctx, state, sql2, j);
            }
            if (!i.hasNext()) continue;
            sql2.append(", ");
        }
        if (augmentUpdates) {
            Path path = (Path)updateParams.keySet().iterator().next();
            FieldMapping fm = (FieldMapping)path.last();
            ClassMapping meta = fm.getDefiningMapping();
            Map<Column, ?> updates = meta.getVersion().getBulkUpdateValues();
            for (Map.Entry<Column, ?> e : updates.entrySet()) {
                Column col = e.getKey();
                Object val = e.getValue();
                sql2.append(", ").append(this.toDBName(col.getIdentifier())).append(" = ");
                if (val instanceof String) {
                    sql2.append((String)val);
                    continue;
                }
                sql2.appendValue(val);
            }
        }
    }

    public String[] getDeleteTableContentsSQL(Table[] tables, Connection conn) {
        ArrayList<String> sql2 = new ArrayList<String>();
        ArrayList<String> deleteSQL = new ArrayList<String>(tables.length);
        LinkedHashSet<ForeignKey> restrictConstraints = new LinkedHashSet<ForeignKey>();
        for (int i = 0; i < tables.length; ++i) {
            ForeignKey[] fks = tables[i].getForeignKeys();
            for (int j = 0; j < fks.length; ++j) {
                if (fks[j].isLogical() || fks[j].isDeferred() || fks[j].getDeleteAction() != 2) continue;
                restrictConstraints.add(fks[j]);
            }
            deleteSQL.add("DELETE FROM " + this.toDBName(tables[i].getFullIdentifier()));
        }
        for (ForeignKey fk : restrictConstraints) {
            String[] constraintSQL = this.getDropForeignKeySQL(fk, conn);
            sql2.addAll(Arrays.asList(constraintSQL));
        }
        sql2.addAll(deleteSQL);
        for (ForeignKey fk : restrictConstraints) {
            String[] constraintSQL = this.getAddForeignKeySQL(fk);
            sql2.addAll(Arrays.asList(constraintSQL));
        }
        return sql2.toArray(new String[sql2.size()]);
    }

    public SQLBuffer toSelect(Select sel, boolean forUpdate, JDBCFetchConfiguration fetch) {
        sel.addJoinClassConditions();
        boolean update = forUpdate && sel.getFromSelect() == null;
        SQLBuffer select = this.getSelects(sel, false, update);
        SQLBuffer ordering = null;
        if (!sel.isAggregate() || sel.getGrouping() != null) {
            ordering = sel.getOrdering();
        }
        SQLBuffer from = sel.getFromSelect() != null ? this.getFromSelect(sel, forUpdate) : this.getFrom(sel, update);
        SQLBuffer where = this.getWhere(sel, update);
        return this.toSelect(select, fetch, from, where, sel.getGrouping(), sel.getHaving(), ordering, sel.isDistinct(), forUpdate, sel.getStartIndex(), sel.getEndIndex(), sel);
    }

    protected SQLBuffer getFrom(Select sel, boolean forUpdate) {
        SQLBuffer fromSQL;
        block11: {
            Collection aliases;
            block10: {
                fromSQL = new SQLBuffer(this);
                aliases = sel.getTableAliases();
                if (aliases.size() >= 2 && sel.getJoinSyntax() == 0) break block10;
                Iterator itr = aliases.iterator();
                while (itr.hasNext()) {
                    fromSQL.append(itr.next().toString());
                    if (forUpdate && this.tableForUpdateClause != null) {
                        fromSQL.append(" ").append(this.tableForUpdateClause);
                    }
                    if (!itr.hasNext()) continue;
                    fromSQL.append(", ");
                }
                if (aliases.size() >= 2 || sel.getParent() == null) break block11;
                itr = sel.getJoinIterator();
                while (itr.hasNext()) {
                    Join join = (Join)itr.next();
                    if (!join.isCorrelated() || join.getForeignKey() == null) continue;
                    SQLBuffer where = new SQLBuffer(this);
                    where.append("(").append(this.toTraditionalJoin(join)).append(")");
                    sel.where(where.getSQL());
                }
                break block11;
            }
            Iterator itr = sel.getJoinIterator();
            boolean first = true;
            while (itr.hasNext()) {
                Join join = (Join)itr.next();
                if (this.correlatedJoinCondition(join, sel)) continue;
                if (join.isCorrelated()) {
                    this.toCorrelatedJoin(sel, join, forUpdate, first);
                } else {
                    fromSQL.append(this.toSQL92Join(sel, join, forUpdate, first));
                }
                first = false;
                if (!itr.hasNext() || !join.isCorrelated()) continue;
                if (fromSQL.getSQL().length() > 0) {
                    fromSQL.append(", ");
                }
                first = true;
            }
            Iterator itr2 = aliases.iterator();
            while (itr2.hasNext()) {
                String tableAlias = itr2.next().toString();
                if (fromSQL.getSQL().indexOf(tableAlias) != -1) continue;
                if (!first && fromSQL.getSQL().length() > 0) {
                    fromSQL.append(", ");
                }
                fromSQL.append(tableAlias);
                if (forUpdate && this.tableForUpdateClause != null) {
                    fromSQL.append(" ").append(this.tableForUpdateClause);
                }
                first = false;
            }
        }
        return fromSQL;
    }

    private boolean correlatedJoinCondition(Join join, Select sel) {
        if (!join.isCorrelated()) {
            return false;
        }
        Iterator itr = sel.getJoinIterator();
        boolean skip = false;
        while (itr.hasNext()) {
            Join join1 = (Join)itr.next();
            if (join == join1 && !join.isForeignKeyInversed() || join.getIndex2() != join1.getIndex1() && join.getIndex2() != join1.getIndex2()) continue;
            skip = true;
            if (join.getForeignKey() == null) break;
            SQLBuffer where = new SQLBuffer(this);
            where.append("(").append(this.toTraditionalJoin(join)).append(")");
            sel.where(where.getSQL());
            break;
        }
        return skip;
    }

    protected SQLBuffer getFromSelect(Select sel, boolean forUpdate) {
        SQLBuffer fromSQL = new SQLBuffer(this);
        fromSQL.append("(");
        fromSQL.append(this.toSelect(sel.getFromSelect(), forUpdate, null));
        fromSQL.append(")");
        if (this.requiresAliasForSubselect) {
            fromSQL.append(" ").append("s");
        }
        return fromSQL;
    }

    protected SQLBuffer getWhere(Select sel, boolean forUpdate) {
        Joins joins = sel.getJoins();
        if (sel.getJoinSyntax() == 0 || joins == null || joins.isEmpty()) {
            return sel.getWhere();
        }
        SQLBuffer where = new SQLBuffer(this);
        if (sel.getWhere() != null) {
            where.append(sel.getWhere());
        }
        if (joins != null) {
            sel.append(where, joins);
        }
        return where;
    }

    public SQLBuffer toTraditionalJoin(Join join) {
        ForeignKey fk = join.getForeignKey();
        if (fk == null) {
            return null;
        }
        boolean inverse = join.isForeignKeyInversed();
        Column[] from = inverse ? fk.getPrimaryKeyColumns() : fk.getColumns();
        Column[] to = inverse ? fk.getColumns() : fk.getPrimaryKeyColumns();
        SQLBuffer buf = new SQLBuffer(this);
        int count = 0;
        int i = 0;
        while (i < from.length) {
            if (count > 0) {
                buf.append(" AND ");
            }
            buf.append(join.getAlias1()).append(".").append(from[i]);
            buf.append(" = ");
            buf.append(join.getAlias2()).append(".").append(to[i]);
            ++i;
            ++count;
        }
        Column[] constCols = fk.getConstantColumns();
        int i2 = 0;
        while (i2 < constCols.length) {
            if (count > 0) {
                buf.append(" AND ");
            }
            if (inverse) {
                buf.appendValue(fk.getConstant(constCols[i2]), constCols[i2]);
            } else {
                buf.append(join.getAlias1()).append(".").append(constCols[i2]);
            }
            buf.append(" = ");
            if (inverse) {
                buf.append(join.getAlias2()).append(".").append(constCols[i2]);
            } else {
                buf.appendValue(fk.getConstant(constCols[i2]), constCols[i2]);
            }
            ++i2;
            ++count;
        }
        Column[] constColsPK = fk.getConstantPrimaryKeyColumns();
        int i3 = 0;
        while (i3 < constColsPK.length) {
            if (count > 0) {
                buf.append(" AND ");
            }
            if (inverse) {
                buf.append(join.getAlias1()).append(".").append(constColsPK[i3]);
            } else {
                buf.appendValue(fk.getPrimaryKeyConstant(constColsPK[i3]), constColsPK[i3]);
            }
            buf.append(" = ");
            if (inverse) {
                buf.appendValue(fk.getPrimaryKeyConstant(constColsPK[i3]), constColsPK[i3]);
            } else {
                buf.append(join.getAlias2()).append(".").append(constColsPK[i3]);
            }
            ++i3;
            ++count;
        }
        return buf;
    }

    public SQLBuffer toSQL92Join(Select sel, Join join, boolean forUpdate, boolean first) {
        SQLBuffer buf = new SQLBuffer(this);
        if (first) {
            buf.append(join.getTable1()).append(" ").append(join.getAlias1());
            if (forUpdate && this.tableForUpdateClause != null) {
                buf.append(" ").append(this.tableForUpdateClause);
            }
        }
        buf.append(" ");
        if (join.getType() == 1) {
            buf.append(this.outerJoinClause);
        } else if (join.getType() == 0) {
            buf.append(this.innerJoinClause);
        } else {
            buf.append(this.crossJoinClause);
        }
        buf.append(" ");
        buf.append(join.getTable2()).append(" ").append(join.getAlias2());
        if (forUpdate && this.tableForUpdateClause != null) {
            buf.append(" ").append(this.tableForUpdateClause);
        }
        if (join.getForeignKey() != null) {
            buf.append(" ON ").append(this.toTraditionalJoin(join));
        } else if (this.requiresConditionForCrossJoin && join.getType() == 2) {
            buf.append(" ON (1 = 1)");
        }
        return buf;
    }

    private SQLBuffer toCorrelatedJoin(Select sel, Join join, boolean forUpdate, boolean first) {
        if (join.getForeignKey() != null) {
            SQLBuffer where = new SQLBuffer(this);
            where.append("(").append(this.toTraditionalJoin(join)).append(")");
            sel.where(where.getSQL());
        }
        return null;
    }

    public SQLBuffer toNativeJoin(Join join) {
        throw new UnsupportedException();
    }

    public boolean canOuterJoin(int syntax, ForeignKey fk) {
        return syntax != 1;
    }

    public SQLBuffer toSelect(SQLBuffer selects, JDBCFetchConfiguration fetch, SQLBuffer from, SQLBuffer where, SQLBuffer group, SQLBuffer having, SQLBuffer order, boolean distinct, boolean forUpdate, long start, long end) {
        return this.toOperation(this.getSelectOperation(fetch), selects, from, where, group, having, order, distinct, start, end, this.getForUpdateClause(fetch, forUpdate, null));
    }

    protected SQLBuffer toSelect(SQLBuffer selects, JDBCFetchConfiguration fetch, SQLBuffer from, SQLBuffer where, SQLBuffer group, SQLBuffer having, SQLBuffer order, boolean distinct, boolean forUpdate, long start, long end, boolean subselect, Select sel) {
        return this.toOperation(this.getSelectOperation(fetch), selects, from, where, group, having, order, distinct, start, end, this.getForUpdateClause(fetch, forUpdate, null), subselect);
    }

    public SQLBuffer toSelect(SQLBuffer selects, JDBCFetchConfiguration fetch, SQLBuffer from, SQLBuffer where, SQLBuffer group, SQLBuffer having, SQLBuffer order, boolean distinct, boolean forUpdate, long start, long end, boolean subselect, boolean checkTableForUpdate) {
        return this.toOperation(this.getSelectOperation(fetch), selects, from, where, group, having, order, distinct, start, end, this.getForUpdateClause(fetch, forUpdate, null), subselect, checkTableForUpdate);
    }

    protected SQLBuffer toSelect(SQLBuffer selects, JDBCFetchConfiguration fetch, SQLBuffer from, SQLBuffer where, SQLBuffer group, SQLBuffer having, SQLBuffer order, boolean distinct, boolean forUpdate, long start, long end, Select sel) {
        return this.toOperation(this.getSelectOperation(fetch), selects, from, where, group, having, order, distinct, start, end, this.getForUpdateClause(fetch, forUpdate, sel));
    }

    protected String getForUpdateClause(JDBCFetchConfiguration fetch, boolean isForUpdate, Select sel) {
        if (fetch != null && fetch.getIsolation() != -1) {
            throw new InvalidStateException(_loc.get("isolation-level-config-not-supported", this.getClass().getName()));
        }
        if (isForUpdate && !this.simulateLocking) {
            this.assertSupport(this.supportsSelectForUpdate, "SupportsSelectForUpdate");
            return this.forUpdateClause;
        }
        return null;
    }

    public boolean supportsIsolationForUpdate() {
        return false;
    }

    public String getSelectOperation(JDBCFetchConfiguration fetch) {
        return "SELECT";
    }

    public SQLBuffer toOperation(String op, SQLBuffer selects, SQLBuffer from, SQLBuffer where, SQLBuffer group, SQLBuffer having, SQLBuffer order, boolean distinct, long start, long end, String forUpdateClause) {
        return this.toOperation(op, selects, from, where, group, having, order, distinct, start, end, forUpdateClause, false);
    }

    public SQLBuffer toOperation(String op, SQLBuffer selects, SQLBuffer from, SQLBuffer where, SQLBuffer group, SQLBuffer having, SQLBuffer order, boolean distinct, long start, long end, String forUpdateClause, boolean subselect) {
        return this.toOperation(op, selects, from, where, group, having, order, distinct, start, end, forUpdateClause, subselect, false);
    }

    private SQLBuffer toOperation(String op, SQLBuffer selects, SQLBuffer from, SQLBuffer where, SQLBuffer group, SQLBuffer having, SQLBuffer order, boolean distinct, long start, long end, String forUpdateClause, boolean subselect, boolean checkTableForUpdate) {
        boolean range;
        SQLBuffer buf = new SQLBuffer(this);
        buf.append(op);
        boolean bl = range = start != 0L || end != Long.MAX_VALUE;
        if (range && this.rangePosition == 1) {
            this.appendSelectRange(buf, start, end, subselect);
        }
        if (distinct) {
            buf.append(" DISTINCT");
        }
        if (range && this.rangePosition == 2) {
            this.appendSelectRange(buf, start, end, subselect);
        }
        buf.append(" ").append(selects).append(" FROM ").append(from);
        if (checkTableForUpdate && StringUtils.isEmpty((String)forUpdateClause) && !StringUtils.isEmpty((String)this.tableForUpdateClause)) {
            buf.append(" ").append(this.tableForUpdateClause);
        }
        if (where != null && !where.isEmpty()) {
            buf.append(" WHERE ").append(where);
        }
        if (group != null && !group.isEmpty()) {
            buf.append(" GROUP BY ").append(group);
        }
        if (having != null && !having.isEmpty()) {
            this.assertSupport(this.supportsHaving, "SupportsHaving");
            buf.append(" HAVING ").append(having);
        }
        if (order != null && !order.isEmpty()) {
            buf.append(" ORDER BY ").append(order);
        }
        if (range && this.rangePosition == 0) {
            this.appendSelectRange(buf, start, end, subselect);
        }
        if (forUpdateClause != null) {
            buf.append(" ").append(forUpdateClause);
        }
        if (range && this.rangePosition == 3) {
            this.appendSelectRange(buf, start, end, subselect);
        }
        return buf;
    }

    protected void appendSelectRange(SQLBuffer buf, long start, long end, boolean subselect) {
    }

    protected SQLBuffer getSelects(Select sel, boolean distinctIdentifiers, boolean forUpdate) {
        SQLBuffer selectSQL = new SQLBuffer(this);
        List aliases = distinctIdentifiers ? sel.getIdentifierAliases() : sel.getSelectAliases();
        for (int i = 0; i < aliases.size(); ++i) {
            Object alias = aliases.get(i);
            if (alias instanceof String) {
                alias = this.getNamingUtil().convertAlias((String)alias);
            }
            this.appendSelect(selectSQL, alias, sel, i);
            if (i >= aliases.size() - 1) continue;
            selectSQL.append(", ");
        }
        return selectSQL;
    }

    protected void appendSelect(SQLBuffer selectSQL, Object elem, Select sel, int idx) {
        if (elem instanceof SQLBuffer) {
            selectSQL.append((SQLBuffer)elem);
        } else {
            selectSQL.append(elem.toString());
        }
    }

    public boolean supportsLocking(Select sel) {
        if (sel.isAggregate()) {
            return false;
        }
        if (!this.supportsSelectForUpdate) {
            return false;
        }
        if (!(this.supportsLockingWithSelectRange || sel.getStartIndex() == 0L && sel.getEndIndex() == Long.MAX_VALUE)) {
            return false;
        }
        if (sel.getFromSelect() != null) {
            sel = sel.getFromSelect();
        }
        if (!this.supportsLockingWithDistinctClause && sel.isDistinct()) {
            return false;
        }
        if (!this.supportsLockingWithMultipleTables && sel.getTableAliases().size() > 1) {
            return false;
        }
        if (!this.supportsLockingWithOrderClause && sel.getOrdering() != null) {
            return false;
        }
        if (!this.supportsLockingWithOuterJoin || !this.supportsLockingWithInnerJoin) {
            Iterator itr = sel.getJoinIterator();
            while (itr.hasNext()) {
                Join join = (Join)itr.next();
                if (!this.supportsLockingWithOuterJoin && join.getType() == 1) {
                    return false;
                }
                if (this.supportsLockingWithInnerJoin || join.getType() != 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean supportsRandomAccessResultSet(Select sel, boolean forUpdate) {
        return !sel.isAggregate();
    }

    public void assertSupport(boolean feature, String property) {
        if (!feature) {
            throw new UnsupportedException(_loc.get("feature-not-supported", this.getClass(), property));
        }
    }

    public void substring(SQLBuffer buf, FilterValue str, FilterValue start, FilterValue length) {
        buf.append(this.substringFunctionName).append("(");
        str.appendTo(buf);
        buf.append(", ");
        if (start.getValue() instanceof Number) {
            buf.append(Long.toString(this.toLong(start)));
        } else {
            start.appendTo(buf);
        }
        if (length != null) {
            buf.append(", ");
            if (length.getValue() instanceof Number) {
                buf.append(Long.toString(this.toLong(length)));
            } else {
                length.appendTo(buf);
            }
        }
        buf.append(")");
    }

    long toLong(FilterValue litValue) {
        return ((Number)litValue.getValue()).longValue();
    }

    public void indexOf(SQLBuffer buf, FilterValue str, FilterValue find, FilterValue start) {
        buf.append("(INSTR((");
        if (start != null) {
            this.substring(buf, str, start, null);
        } else {
            str.appendTo(buf);
        }
        buf.append("), (");
        find.appendTo(buf);
        buf.append("))");
        if (start != null) {
            buf.append(" - 1  + ");
            start.appendTo(buf);
        }
        buf.append(")");
    }

    public void mathFunction(SQLBuffer buf, String op, FilterValue lhs, FilterValue rhs) {
        boolean mod;
        Class<?> c;
        boolean castlhs = false;
        boolean castrhs = false;
        Class<?> lc = Filters.wrap(lhs.getType());
        Class<?> rc = Filters.wrap(rhs.getType());
        int type = 0;
        if (this.requiresCastForMathFunctions && (lc != rc || lhs.isConstant() || rhs.isConstant()) && (type = this.getJDBCType(JavaTypes.getTypeCode(c = Filters.promote(lc, rc)), false)) != -3 && type != 2004) {
            castlhs = lhs.isConstant() && rhs.isConstant() || lc != c;
            boolean bl = castrhs = lhs.isConstant() && rhs.isConstant() || rc != c;
        }
        if (mod = "MOD".equals(op)) {
            if (this.supportsModOperator) {
                op = "%";
            } else {
                buf.append(op);
            }
        }
        buf.append("(");
        if (castlhs) {
            this.appendCast(buf, lhs, type);
        } else {
            lhs.appendTo(buf);
        }
        if (mod && !this.supportsModOperator) {
            buf.append(", ");
        } else {
            buf.append(" ").append(op).append(" ");
        }
        if (castrhs) {
            this.appendCast(buf, rhs, type);
        } else {
            rhs.appendTo(buf);
        }
        buf.append(")");
    }

    public void comparison(SQLBuffer buf, String op, FilterValue lhs, FilterValue rhs) {
        Class<?> c;
        Class<?> rc;
        boolean rhsxml;
        boolean lhsxml = lhs.getXPath() != null;
        boolean bl = rhsxml = rhs.getXPath() != null;
        if (lhsxml || rhsxml) {
            this.appendXmlComparison(buf, op, lhs, rhs, lhsxml, rhsxml);
            return;
        }
        boolean castlhs = false;
        boolean castrhs = false;
        Class<?> lc = Filters.wrap(lhs.getType());
        if (lc == (rc = Filters.wrap(rhs.getType())) && lc == Boolean.class && lhs.isConstant() && rhs.isConstant()) {
            String lvalue = Boolean.TRUE.equals(lhs.getValue()) ? "1" : "0";
            String rvalue = Boolean.TRUE.equals(rhs.getValue()) ? "1" : "0";
            buf.append(lvalue).append(op).append(rvalue);
            return;
        }
        int type = 0;
        if (this.requiresCastForComparisons && (lc != rc || lhs.isConstant() && rhs.isConstant()) && (type = this.getJDBCType(JavaTypes.getTypeCode(c = Filters.promote(lc, rc)), false)) != -3 && type != 2004) {
            castlhs = lhs.isConstant() && rhs.isConstant() || lc != c;
            castrhs = lhs.isConstant() && rhs.isConstant() || rc != c;
            castlhs = castlhs && lhs.requiresCast();
            boolean bl2 = castrhs = castrhs && rhs.requiresCast();
        }
        if (castlhs) {
            this.appendCast(buf, lhs, type);
        } else {
            lhs.appendTo(buf);
        }
        buf.append(" ").append(op).append(" ");
        if (castrhs) {
            this.appendCast(buf, rhs, type);
        } else {
            rhs.appendTo(buf);
        }
    }

    public void appendXmlComparison(SQLBuffer buf, String op, FilterValue lhs, FilterValue rhs, boolean lhsxml, boolean rhsxml) {
        this.assertSupport(this.supportsXMLColumn, "SupportsXMLColumn");
    }

    protected void appendNumericCast(SQLBuffer buf, FilterValue val) {
        if (val.isConstant()) {
            this.appendCast(buf, val, 2);
        } else {
            val.appendTo(buf);
        }
    }

    public void appendCast(SQLBuffer buf, Object val, int type) {
        String post;
        int firstParam = this.castFunction.indexOf("{0}");
        String pre = this.castFunction.substring(0, firstParam);
        String mid = this.castFunction.substring(firstParam + 3);
        int secondParam = mid.indexOf("{1}");
        if (secondParam > -1) {
            post = mid.substring(secondParam + 3);
            mid = mid.substring(0, secondParam);
        } else {
            post = "";
        }
        buf.append(pre);
        if (val instanceof FilterValue) {
            ((FilterValue)val).appendTo(buf);
        } else if (val instanceof SQLBuffer) {
            buf.append((SQLBuffer)val);
        } else {
            buf.append(val.toString());
        }
        buf.append(mid);
        buf.append(this.getTypeName(type));
        this.appendLength(buf, type);
        buf.append(post);
    }

    protected void appendLength(SQLBuffer buf, int type) {
    }

    public String addCastAsType(String func, Val val) {
        return null;
    }

    public void refSchemaComponents(Table table) {
    }

    public DBIdentifier getColumnIdentifier(Column column) {
        if (column == null) {
            return DBIdentifier.NULL;
        }
        return column.getIdentifier();
    }

    public String getColumnDBName(Column column) {
        return this.toDBName(this.getColumnIdentifier(column));
    }

    public DBIdentifier getFullIdentifier(Table table, boolean logical) {
        if (!this.useSchemaName || DBIdentifier.isNull(table.getSchemaIdentifier())) {
            return table.getIdentifier();
        }
        return table.getFullIdentifier();
    }

    public String getFullName(Table table, boolean logical) {
        if (!this.useSchemaName || DBIdentifier.isNull(table.getSchemaIdentifier())) {
            return this.toDBName(table.getIdentifier());
        }
        return this.toDBName(table.getFullIdentifier());
    }

    public String getFullName(Index index) {
        if (!this.useSchemaName || DBIdentifier.isNull(index.getSchemaIdentifier())) {
            return this.toDBName(index.getIdentifier());
        }
        return this.toDBName(index.getFullIdentifier());
    }

    public String getFullName(Sequence seq) {
        if (!this.useSchemaName || DBIdentifier.isNull(seq.getSchemaIdentifier())) {
            return this.toDBName(seq.getIdentifier());
        }
        return this.toDBName(seq.getFullIdentifier());
    }

    public final Set<String> getInvalidColumnWordSet() {
        return this.invalidColumnWordSet;
    }

    public String getValidTableName(String name, Schema schema) {
        return this.getValidTableName(DBIdentifier.newTable(name), schema).getName();
    }

    public DBIdentifier getValidTableName(DBIdentifier name, Schema schema) {
        return this.namingUtil.getValidTableIdentifier(name, schema, this.maxTableNameLength);
    }

    public String getValidSequenceName(String name, Schema schema) {
        return this.getValidSequenceName(DBIdentifier.newSequence(name), schema).getName();
    }

    public DBIdentifier getValidSequenceName(DBIdentifier name, Schema schema) {
        return this.namingUtil.getValidSequenceIdentifier(name, schema, this.maxTableNameLength);
    }

    public String getValidColumnName(String name, Table table) {
        return this.getValidColumnName(DBIdentifier.newColumn(name), table, true).getName();
    }

    public DBIdentifier getValidColumnName(DBIdentifier name, Table table) {
        return this.getValidColumnName(name, table, true);
    }

    public String getValidColumnName(String name, Table table, boolean checkForUniqueness) {
        return this.getValidColumnName(DBIdentifier.newColumn(name), table, checkForUniqueness).toString();
    }

    public DBIdentifier getValidColumnName(DBIdentifier name, Table table, boolean checkForUniqueness) {
        return this.getNamingUtil().getValidColumnIdentifier(name, table, this.maxColumnNameLength, checkForUniqueness);
    }

    public String getValidPrimaryKeyName(String name, Table table) {
        while (name.startsWith("_")) {
            name = name.substring(1);
        }
        return this.makeNameValid("P_" + name, (NameSet)table.getSchema().getSchemaGroup(), this.maxConstraintNameLength, 0);
    }

    public String getValidForeignKeyName(String name, Table table, Table toTable) {
        return this.getValidForeignKeyName(DBIdentifier.newForeignKey(name), table, toTable).getName();
    }

    public DBIdentifier getValidForeignKeyName(DBIdentifier name, Table table, Table toTable) {
        return this.namingUtil.getValidForeignKeyIdentifier(name, table, toTable, this.maxConstraintNameLength);
    }

    public String getValidIndexName(String name, Table table) {
        return this.getValidIndexName(DBIdentifier.newIndex(name), table).getName();
    }

    public DBIdentifier getValidIndexName(DBIdentifier name, Table table) {
        return this.getNamingUtil().getValidIndexIdentifier(name, table, this.maxIndexNameLength);
    }

    public String getValidUniqueName(String name, Table table) {
        return this.getValidUniqueName(DBIdentifier.newConstraint(name), table).getName();
    }

    public DBIdentifier getValidUniqueName(DBIdentifier name, Table table) {
        return this.namingUtil.getValidUniqueIdentifier(name, table, this.maxConstraintNameLength);
    }

    public static String shorten(String name, int targetLength) {
        if (name == null || name.length() <= targetLength) {
            return name;
        }
        StringBuilder nm = new StringBuilder(name);
        while (nm.length() > targetLength) {
            if (DBDictionary.stripVowel(nm)) continue;
            nm.replace(nm.length() / 2, nm.length() / 2 + 1, "");
        }
        return nm.toString();
    }

    private static boolean stripVowel(StringBuilder name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        char[] vowels = new char[]{'A', 'E', 'I', 'O', 'U'};
        for (int i = 0; i < vowels.length; ++i) {
            int index = name.toString().toUpperCase().indexOf(vowels[i]);
            if (index == -1) continue;
            name.replace(index, index + 1, "");
            return true;
        }
        return false;
    }

    protected String makeNameValid(String name, NameSet set, int maxLen, int nameType) {
        return this.makeNameValid(name, set, maxLen, nameType, true);
    }

    protected DBIdentifier makeNameValid(DBIdentifier name, NameSet set, int maxLen, int nameType) {
        return this.makeNameValid(name, set, maxLen, nameType, true);
    }

    protected String makeNameValid(String name, NameSet set, int maxLen, int nameType, boolean checkForUniqueness) {
        return this.namingUtil.makeNameValid(name, set, maxLen, nameType, checkForUniqueness).toString();
    }

    protected DBIdentifier makeNameValid(DBIdentifier name, NameSet set, int maxLen, int nameType, boolean checkForUniqueness) {
        return this.namingUtil.makeIdentifierValid(name, set, maxLen, checkForUniqueness);
    }

    public String[] getCreateTableSQL(Table table, SchemaGroup group) {
        return this.getCreateTableSQL(table);
    }

    public String[] getCreateTableSQL(Table table) {
        String pkStr;
        StringBuilder buf = new StringBuilder();
        String tableName = this.checkNameLength(this.getFullIdentifier(table, false), this.maxTableNameLength, "long-table-name", this.tableLengthIncludesSchema);
        buf.append("CREATE TABLE ").append(tableName);
        if (this.supportsComments && table.hasComment()) {
            buf.append(" ");
            this.comment(buf, table.getComment());
            buf.append("\n    (");
        } else {
            buf.append(" (");
        }
        StringBuilder endBuf = new StringBuilder();
        PrimaryKey pk = table.getPrimaryKey();
        if (pk != null && (pkStr = this.getPrimaryKeyConstraintSQL(pk)) != null) {
            endBuf.append(pkStr);
        }
        Unique[] unqs = table.getUniques();
        for (int i = 0; i < unqs.length; ++i) {
            String unqStr = this.getUniqueConstraintSQL(unqs[i]);
            if (unqStr == null) continue;
            if (endBuf.length() > 0) {
                endBuf.append(", ");
            }
            endBuf.append(unqStr);
        }
        Column[] cols = table.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            buf.append(this.getDeclareColumnSQL(cols[i], false));
            if (i < cols.length - 1 || endBuf.length() > 0) {
                buf.append(", ");
            }
            if (!this.supportsComments || !cols[i].hasComment()) continue;
            this.comment(buf, cols[i].getComment());
            buf.append("\n    ");
        }
        buf.append(endBuf.toString());
        buf.append(")");
        return new String[]{buf.toString()};
    }

    public int getBatchFetchSize(int batchFetchSize) {
        return batchFetchSize;
    }

    protected StringBuilder comment(StringBuilder buf, String comment) {
        return buf.append("-- ").append(comment);
    }

    public String[] getDropTableSQL(Table table) {
        String drop = MessageFormat.format(this.dropTableSQL, this.getFullName(table, false));
        return new String[]{drop};
    }

    public String[] getCreateSequenceSQL(Sequence seq) {
        return this.commonCreateAlterSequenceSQL(seq, true);
    }

    public String getAlterSequenceSQL(Sequence seq) {
        return this.commonCreateAlterSequenceSQL(seq, false)[0];
    }

    private String[] commonCreateAlterSequenceSQL(Sequence seq, boolean create) {
        if (this.nextSequenceQuery == null) {
            return null;
        }
        if (!this.useNativeSequenceCache && this.logNativeSequenceCacheWarning) {
            this.log.warn(_loc.get("sequence-cache-warning"));
            this.logNativeSequenceCacheWarning = false;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(create ? "CREATE" : "ALTER").append(" SEQUENCE ");
        String seqName = this.checkNameLength(this.getFullName(seq), this.maxTableNameLength, "long-seq-name");
        buf.append(seqName);
        if (create && seq.getInitialValue() != 0) {
            buf.append(" START WITH ").append(seq.getInitialValue());
        }
        if (seq.getIncrement() > 1 || seq.getAllocate() > 1) {
            buf.append(" INCREMENT BY ").append(seq.getIncrement() * seq.getAllocate());
        }
        return new String[]{buf.toString()};
    }

    public String[] getDropSequenceSQL(Sequence seq) {
        return new String[]{"DROP SEQUENCE " + this.getFullName(seq)};
    }

    public String[] getCreateIndexSQL(Index index) {
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE ");
        if (index.isUnique()) {
            buf.append("UNIQUE ");
        }
        DBIdentifier fullIdxName = index.getIdentifier();
        DBIdentifier unQualifiedName = fullIdxName.getUnqualifiedName();
        this.checkNameLength(this.toDBName(unQualifiedName), this.maxIndexNameLength, "long-index-name");
        String indexName = this.toDBName(fullIdxName);
        buf.append("INDEX ").append(indexName);
        buf.append(" ON ").append(this.getFullName(index.getTable(), false));
        buf.append(" (").append(this.namingUtil.appendColumns(index.getColumns())).append(")");
        return new String[]{buf.toString()};
    }

    public String[] getDropIndexSQL(Index index) {
        return new String[]{"DROP INDEX " + this.getFullName(index)};
    }

    public String[] getAddColumnSQL(Column column) {
        if (!this.supportsAlterTableWithAddColumn) {
            return new String[0];
        }
        String dec = this.getDeclareColumnSQL(column, true);
        if (dec == null) {
            return new String[0];
        }
        return new String[]{"ALTER TABLE " + this.getFullName(column.getTable(), false) + " ADD " + dec};
    }

    public String[] getDropColumnSQL(Column column) {
        if (!this.supportsAlterTableWithDropColumn) {
            return new String[0];
        }
        return new String[]{"ALTER TABLE " + this.getFullName(column.getTable(), false) + " DROP COLUMN " + column};
    }

    public String[] getAddPrimaryKeySQL(PrimaryKey pk) {
        String pksql = this.getPrimaryKeyConstraintSQL(pk);
        if (pksql == null) {
            return new String[0];
        }
        return new String[]{"ALTER TABLE " + this.getFullName(pk.getTable(), false) + " ADD " + pksql};
    }

    public String[] getDropPrimaryKeySQL(PrimaryKey pk) {
        if (DBIdentifier.isNull(pk.getIdentifier())) {
            return new String[0];
        }
        return new String[]{"ALTER TABLE " + this.getFullName(pk.getTable(), false) + " DROP CONSTRAINT " + this.toDBName(pk.getIdentifier())};
    }

    public String[] getAddForeignKeySQL(ForeignKey fk) {
        String fkSQL = this.getForeignKeyConstraintSQL(fk);
        if (fkSQL == null) {
            return new String[0];
        }
        return new String[]{"ALTER TABLE " + this.getFullName(fk.getTable(), false) + " ADD " + fkSQL};
    }

    public String[] getDropForeignKeySQL(ForeignKey fk, Connection conn) {
        if (DBIdentifier.isNull(fk.getIdentifier())) {
            String[] stringArray;
            DBIdentifier fkName = fk.loadIdentifierFromDB(this, conn);
            if (fkName == null || fkName.getName() == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "ALTER TABLE " + this.getFullName(fk.getTable(), false) + " DROP CONSTRAINT " + this.toDBName(fkName);
            }
            String[] retVal = stringArray;
            return retVal;
        }
        return new String[]{"ALTER TABLE " + this.getFullName(fk.getTable(), false) + " DROP CONSTRAINT " + this.toDBName(fk.getIdentifier())};
    }

    protected String getDeclareColumnSQL(Column col, boolean alter) {
        StringBuilder buf = new StringBuilder();
        String columnName = this.checkNameLength(this.toDBName(col.getIdentifier()), this.maxColumnNameLength, "long-column-name");
        buf.append(columnName).append(" ");
        buf.append(this.getTypeName(col));
        if (!alter) {
            if (col.getDefaultString() != null && !col.isAutoAssigned()) {
                buf.append(" DEFAULT ").append(col.getDefaultString());
            }
            if (col.isNotNull() || !this.supportsNullUniqueColumn && col.hasConstraint(Unique.class)) {
                buf.append(" NOT NULL");
            }
        }
        if (col.isAutoAssigned()) {
            if (!this.supportsAutoAssign) {
                this.log.warn(_loc.get("invalid-autoassign", this.platform, col));
            } else if (this.autoAssignClause != null) {
                buf.append(" ").append(this.autoAssignClause);
            }
        }
        return buf.toString();
    }

    protected String getPrimaryKeyConstraintSQL(PrimaryKey pk) {
        if (!this.createPrimaryKeys) {
            return null;
        }
        String name = this.toDBName(pk.getIdentifier());
        if (name != null && this.reservedWordSet.contains(name.toUpperCase())) {
            name = null;
        }
        StringBuilder buf = new StringBuilder();
        if (name != null && CONS_NAME_BEFORE.equals(this.constraintNameMode)) {
            buf.append("CONSTRAINT ").append(name).append(" ");
        }
        buf.append("PRIMARY KEY ");
        if (name != null && CONS_NAME_MID.equals(this.constraintNameMode)) {
            buf.append(name).append(" ");
        }
        buf.append("(").append(this.namingUtil.appendColumns(pk.getColumns())).append(")");
        if (name != null && CONS_NAME_AFTER.equals(this.constraintNameMode)) {
            buf.append(" CONSTRAINT ").append(name);
        }
        return buf.toString();
    }

    protected String getForeignKeyConstraintSQL(ForeignKey fk) {
        if (!this.supportsForeignKeys) {
            return null;
        }
        if (fk.getColumns().length > 0 && !this.supportsForeignKeysComposite) {
            return null;
        }
        if (fk.getDeleteAction() == 1) {
            return null;
        }
        if (fk.isDeferred() && !this.supportsDeferredForeignKeyConstraints()) {
            return null;
        }
        if (!this.supportsDeleteAction(fk.getDeleteAction()) || !this.supportsUpdateAction(fk.getUpdateAction())) {
            return null;
        }
        Column[] locals = fk.getColumns();
        Column[] foreigns = fk.getPrimaryKeyColumns();
        int delActionId = fk.getDeleteAction();
        if (delActionId == 4) {
            for (int i = 0; i < locals.length; ++i) {
                if (!locals[i].isNotNull()) continue;
                delActionId = 1;
            }
        }
        String delAction = this.getActionName(delActionId);
        String upAction = this.getActionName(fk.getUpdateAction());
        StringBuilder buf = new StringBuilder();
        if (!DBIdentifier.isNull(fk.getIdentifier()) && CONS_NAME_BEFORE.equals(this.constraintNameMode)) {
            buf.append("CONSTRAINT ").append(this.toDBName(fk.getIdentifier())).append(" ");
        }
        buf.append("FOREIGN KEY ");
        if (!DBIdentifier.isNull(fk.getIdentifier()) && CONS_NAME_MID.equals(this.constraintNameMode)) {
            buf.append(this.toDBName(fk.getIdentifier())).append(" ");
        }
        buf.append("(").append(this.namingUtil.appendColumns(locals)).append(")");
        buf.append(" REFERENCES ");
        buf.append(this.getFullName(foreigns[0].getTable(), false));
        buf.append(" (").append(this.namingUtil.appendColumns(foreigns)).append(")");
        if (delAction != null) {
            buf.append(" ON DELETE ").append(delAction);
        }
        if (upAction != null) {
            buf.append(" ON UPDATE ").append(upAction);
        }
        if (fk.isDeferred()) {
            buf.append(" INITIALLY DEFERRED");
        }
        if (this.supportsDeferredForeignKeyConstraints()) {
            buf.append(" DEFERRABLE");
        }
        if (!DBIdentifier.isNull(fk.getIdentifier()) && CONS_NAME_AFTER.equals(this.constraintNameMode)) {
            buf.append(" CONSTRAINT ").append(this.toDBName(fk.getIdentifier()));
        }
        return buf.toString();
    }

    protected boolean supportsDeferredForeignKeyConstraints() {
        return this.supportsDeferredConstraints;
    }

    private String getActionName(int action) {
        switch (action) {
            case 3: {
                return "CASCADE";
            }
            case 4: {
                return "SET NULL";
            }
            case 5: {
                return "SET DEFAULT";
            }
        }
        return null;
    }

    public boolean supportsDeleteAction(int action) {
        if (action == 1) {
            return true;
        }
        if (!this.supportsForeignKeys) {
            return false;
        }
        switch (action) {
            case 2: {
                return this.supportsRestrictDeleteAction;
            }
            case 3: {
                return this.supportsCascadeDeleteAction;
            }
            case 4: {
                return this.supportsNullDeleteAction;
            }
            case 5: {
                return this.supportsDefaultDeleteAction;
            }
        }
        return false;
    }

    public boolean supportsUpdateAction(int action) {
        if (action == 1) {
            return true;
        }
        if (!this.supportsForeignKeys) {
            return false;
        }
        switch (action) {
            case 2: {
                return this.supportsRestrictUpdateAction;
            }
            case 3: {
                return this.supportsCascadeUpdateAction;
            }
            case 4: {
                return this.supportsNullUpdateAction;
            }
            case 5: {
                return this.supportsDefaultUpdateAction;
            }
        }
        return false;
    }

    protected String getUniqueConstraintSQL(Unique unq) {
        if (!this.supportsUniqueConstraints || unq.isDeferred() && !this.supportsDeferredUniqueConstraints()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (!DBIdentifier.isNull(unq.getIdentifier()) && CONS_NAME_BEFORE.equals(this.constraintNameMode)) {
            buf.append("CONSTRAINT ").append(this.checkNameLength(this.toDBName(unq.getIdentifier()), this.maxConstraintNameLength, "long-constraint-name")).append(" ");
        }
        buf.append("UNIQUE ");
        if (!DBIdentifier.isNull(unq.getIdentifier()) && CONS_NAME_MID.equals(this.constraintNameMode)) {
            buf.append(this.toDBName(unq.getIdentifier())).append(" ");
        }
        buf.append("(").append(this.namingUtil.appendColumns(unq.getColumns())).append(")");
        if (unq.isDeferred()) {
            buf.append(" INITIALLY DEFERRED");
        }
        if (this.supportsDeferredUniqueConstraints()) {
            buf.append(" DEFERRABLE");
        }
        if (!DBIdentifier.isNull(unq.getIdentifier()) && CONS_NAME_AFTER.equals(this.constraintNameMode)) {
            buf.append(" CONSTRAINT ").append(this.toDBName(unq.getIdentifier()));
        }
        return buf.toString();
    }

    protected boolean supportsDeferredUniqueConstraints() {
        return this.supportsDeferredConstraints;
    }

    public boolean isSystemTable(String name, String schema, boolean targetSchema) {
        return this.isSystemTable(DBIdentifier.newTable(name), DBIdentifier.newSchema(schema), targetSchema);
    }

    public boolean isSystemTable(DBIdentifier name, DBIdentifier schema, boolean targetSchema) {
        DBIdentifier sName = DBIdentifier.toUpper(name);
        if (this.systemTableSet.contains(sName.getName())) {
            return true;
        }
        DBIdentifier schName = DBIdentifier.toUpper(schema);
        return !targetSchema && schema != null && this.systemSchemaSet.contains(schName.getName());
    }

    public boolean isSystemIndex(String name, Table table) {
        return false;
    }

    public boolean isSystemIndex(DBIdentifier name, Table table) {
        return false;
    }

    public boolean isSystemSequence(String name, String schema, boolean targetSchema) {
        return this.isSystemSequence(DBIdentifier.newSequence(name), DBIdentifier.newSchema(schema), targetSchema);
    }

    public boolean isSystemSequence(DBIdentifier name, DBIdentifier schema, boolean targetSchema) {
        return !targetSchema && !DBIdentifier.isNull(schema) && this.systemSchemaSet.contains(DBIdentifier.toUpper(schema).getName());
    }

    public boolean isSystemSequence(DBIdentifier name, DBIdentifier schema, boolean targetSchema, Connection conn) {
        return this.isSystemSequence(name, schema, targetSchema);
    }

    public Table[] getTables(DatabaseMetaData meta, String catalog, String schemaName, String tableName, Connection conn) throws SQLException {
        return this.getTables(meta, DBIdentifier.newCatalog(catalog), DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(tableName), conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table[] getTables(DatabaseMetaData meta, DBIdentifier sqlCatalog, DBIdentifier sqlSchemaName, DBIdentifier sqlTableName, Connection conn) throws SQLException {
        String schemaName = DBIdentifier.isNull(sqlSchemaName) ? null : sqlSchemaName.getName();
        schemaName = !this.supportsSchemaForGetTables ? null : this.getSchemaNameForMetadata(sqlSchemaName);
        String[] types = Strings.split((String)this.tableTypes, (String)",", (int)0);
        for (int i = 0; i < types.length; ++i) {
            types[i] = types[i].trim();
        }
        this.beforeMetadataOperation(conn);
        ResultSet tables = null;
        try {
            tables = meta.getTables(this.getCatalogNameForMetadata(sqlCatalog), schemaName, this.getTableNameForMetadata(sqlTableName), types);
            ArrayList<Table> tableList = new ArrayList<Table>();
            while (tables != null && tables.next()) {
                tableList.add(this.newTable(tables));
            }
            Table[] tableArray = tableList.toArray(new Table[tableList.size()]);
            return tableArray;
        }
        finally {
            if (tables != null) {
                try {
                    tables.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected Table newTable(ResultSet tableMeta) throws SQLException {
        Table t = new Table();
        t.setIdentifier(this.fromDBName(tableMeta.getString("TABLE_NAME"), DBIdentifier.DBIdentifierType.TABLE));
        return t;
    }

    public Sequence[] getSequences(DatabaseMetaData meta, String catalog, String schemaName, String sequenceName, Connection conn) throws SQLException {
        return this.getSequences(meta, DBIdentifier.newCatalog(catalog), DBIdentifier.newSchema(schemaName), DBIdentifier.newSequence(sequenceName), conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence[] getSequences(DatabaseMetaData meta, DBIdentifier catalog, DBIdentifier schemaName, DBIdentifier sequenceName, Connection conn) throws SQLException {
        String str = this.getSequencesSQL(schemaName, sequenceName);
        if (str == null) {
            return new Sequence[0];
        }
        PreparedStatement stmnt = this.prepareStatement(conn, str);
        ResultSet rs = null;
        try {
            int idx = 1;
            if (!DBIdentifier.isNull(schemaName)) {
                stmnt.setString(idx++, DBIdentifier.toUpper(schemaName).getName());
            }
            if (!DBIdentifier.isNull(sequenceName)) {
                stmnt.setString(idx++, sequenceName.getName());
            }
            this.setQueryTimeout(stmnt, this.conf.getQueryTimeout());
            rs = this.executeQuery(conn, stmnt, str);
            Sequence[] sequenceArray = this.getSequence(rs);
            return sequenceArray;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException se) {}
            }
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException se) {}
            }
        }
    }

    protected Sequence newSequence(ResultSet sequenceMeta) throws SQLException {
        Sequence seq = new Sequence();
        seq.setSchemaIdentifier(this.fromDBName(StringUtils.stripEnd((String)sequenceMeta.getString("SEQUENCE_SCHEMA"), null), DBIdentifier.DBIdentifierType.SCHEMA));
        seq.setIdentifier(this.fromDBName(StringUtils.stripEnd((String)sequenceMeta.getString("SEQUENCE_NAME"), null), DBIdentifier.DBIdentifierType.SEQUENCE));
        return seq;
    }

    protected String getSequencesSQL(String schemaName, String sequenceName) {
        return null;
    }

    protected String getSequencesSQL(DBIdentifier schemaName, DBIdentifier sequenceName) {
        return null;
    }

    public Column[] getColumns(DatabaseMetaData meta, String catalog, String schemaName, String tableName, String columnName, Connection conn) throws SQLException {
        return this.getColumns(meta, DBIdentifier.newCatalog(catalog), DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(tableName), DBIdentifier.newColumn(columnName), conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Column[] getColumns(DatabaseMetaData meta, DBIdentifier catalog, DBIdentifier schemaName, DBIdentifier tableName, DBIdentifier columnName, Connection conn) throws SQLException {
        if (DBIdentifier.isNull(tableName) && !this.supportsNullTableForGetColumns) {
            return null;
        }
        String sqlSchemaName = null;
        if (!DBIdentifier.isNull(schemaName)) {
            sqlSchemaName = schemaName.getName();
        }
        sqlSchemaName = !this.supportsSchemaForGetColumns ? null : this.getSchemaNameForMetadata(schemaName);
        this.beforeMetadataOperation(conn);
        ResultSet cols = null;
        try {
            cols = meta.getColumns(this.getCatalogNameForMetadata(catalog), sqlSchemaName, this.getTableNameForMetadata(tableName), this.getColumnNameForMetadata(columnName));
            ArrayList<Column> columnList = new ArrayList<Column>();
            while (cols != null && cols.next()) {
                columnList.add(this.newColumn(cols));
            }
            Column[] columnArray = columnList.toArray(new Column[columnList.size()]);
            return columnArray;
        }
        finally {
            if (cols != null) {
                try {
                    cols.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected Column newColumn(ResultSet colMeta) throws SQLException {
        Column c = new Column();
        c.setSchemaIdentifier(this.fromDBName(colMeta.getString("TABLE_SCHEM"), DBIdentifier.DBIdentifierType.SCHEMA));
        c.setTableIdentifier(this.fromDBName(colMeta.getString("TABLE_NAME"), DBIdentifier.DBIdentifierType.TABLE));
        c.setIdentifier(this.fromDBName(colMeta.getString("COLUMN_NAME"), DBIdentifier.DBIdentifierType.COLUMN));
        c.setType(colMeta.getInt("DATA_TYPE"));
        c.setTypeIdentifier(this.fromDBName(colMeta.getString("TYPE_NAME"), DBIdentifier.DBIdentifierType.COLUMN_DEFINITION));
        c.setSize(colMeta.getInt("COLUMN_SIZE"));
        c.setDecimalDigits(colMeta.getInt("DECIMAL_DIGITS"));
        c.setNotNull(colMeta.getInt("NULLABLE") == 0);
        String def = colMeta.getString("COLUMN_DEF");
        if (!StringUtils.isEmpty((String)def) && !"null".equalsIgnoreCase(def)) {
            c.setDefaultString(def);
        }
        return c;
    }

    public PrimaryKey[] getPrimaryKeys(DatabaseMetaData meta, String catalog, String schemaName, String tableName, Connection conn) throws SQLException {
        return this.getPrimaryKeys(meta, DBIdentifier.newCatalog(catalog), DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(tableName), conn);
    }

    public PrimaryKey[] getPrimaryKeys(DatabaseMetaData meta, DBIdentifier catalog, DBIdentifier schemaName, DBIdentifier tableName, Connection conn) throws SQLException {
        if (this.useGetBestRowIdentifierForPrimaryKeys) {
            return this.getPrimaryKeysFromBestRowIdentifier(meta, catalog, schemaName, tableName, conn);
        }
        return this.getPrimaryKeysFromGetPrimaryKeys(meta, catalog, schemaName, tableName, conn);
    }

    protected PrimaryKey[] getPrimaryKeysFromGetPrimaryKeys(DatabaseMetaData meta, String catalog, String schemaName, String tableName, Connection conn) throws SQLException {
        return this.getPrimaryKeysFromGetPrimaryKeys(meta, DBIdentifier.newCatalog(catalog), DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(tableName), conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PrimaryKey[] getPrimaryKeysFromGetPrimaryKeys(DatabaseMetaData meta, DBIdentifier catalog, DBIdentifier schemaName, DBIdentifier tableName, Connection conn) throws SQLException {
        if (tableName == null && !this.supportsNullTableForGetPrimaryKeys) {
            return null;
        }
        this.beforeMetadataOperation(conn);
        ResultSet pks = null;
        try {
            pks = meta.getPrimaryKeys(this.getCatalogNameForMetadata(catalog), this.getSchemaNameForMetadata(schemaName), this.getTableNameForMetadata(tableName));
            ArrayList<PrimaryKey> pkList = new ArrayList<PrimaryKey>();
            while (pks != null && pks.next()) {
                pkList.add(this.newPrimaryKey(pks));
            }
            PrimaryKey[] primaryKeyArray = pkList.toArray(new PrimaryKey[pkList.size()]);
            return primaryKeyArray;
        }
        finally {
            if (pks != null) {
                try {
                    pks.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected PrimaryKey newPrimaryKey(ResultSet pkMeta) throws SQLException {
        PrimaryKey pk = new PrimaryKey();
        pk.setSchemaIdentifier(this.fromDBName(pkMeta.getString("TABLE_SCHEM"), DBIdentifier.DBIdentifierType.SCHEMA));
        pk.setTableIdentifier(this.fromDBName(pkMeta.getString("TABLE_NAME"), DBIdentifier.DBIdentifierType.TABLE));
        pk.setColumnIdentifier(this.fromDBName(pkMeta.getString("COLUMN_NAME"), DBIdentifier.DBIdentifierType.COLUMN));
        pk.setIdentifier(this.fromDBName(pkMeta.getString("PK_NAME"), DBIdentifier.DBIdentifierType.CONSTRAINT));
        return pk;
    }

    protected PrimaryKey[] getPrimaryKeysFromBestRowIdentifier(DatabaseMetaData meta, String catalog, String schemaName, String tableName, Connection conn) throws SQLException {
        return this.getPrimaryKeysFromBestRowIdentifier(meta, DBIdentifier.newCatalog(catalog), DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(tableName), conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PrimaryKey[] getPrimaryKeysFromBestRowIdentifier(DatabaseMetaData meta, DBIdentifier catalog, DBIdentifier schemaName, DBIdentifier tableName, Connection conn) throws SQLException {
        if (tableName == null) {
            return null;
        }
        this.beforeMetadataOperation(conn);
        ResultSet pks = null;
        try {
            pks = meta.getBestRowIdentifier(this.toDBName(catalog), this.toDBName(schemaName), this.toDBName(tableName), 0, false);
            ArrayList<PrimaryKey> pkList = new ArrayList<PrimaryKey>();
            while (pks != null && pks.next()) {
                PrimaryKey pk = new PrimaryKey();
                pk.setSchemaIdentifier(schemaName);
                pk.setTableIdentifier(tableName);
                pk.setColumnIdentifier(this.fromDBName(pks.getString("COLUMN_NAME"), DBIdentifier.DBIdentifierType.COLUMN));
                pkList.add(pk);
            }
            PrimaryKey[] primaryKeyArray = pkList.toArray(new PrimaryKey[pkList.size()]);
            return primaryKeyArray;
        }
        finally {
            if (pks != null) {
                try {
                    pks.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public Index[] getIndexInfo(DatabaseMetaData meta, String catalog, String schemaName, String tableName, boolean unique, boolean approx, Connection conn) throws SQLException {
        return this.getIndexInfo(meta, DBIdentifier.newCatalog(catalog), DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(tableName), unique, approx, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index[] getIndexInfo(DatabaseMetaData meta, DBIdentifier catalog, DBIdentifier schemaName, DBIdentifier tableName, boolean unique, boolean approx, Connection conn) throws SQLException {
        if (tableName == null && !this.supportsNullTableForGetIndexInfo) {
            return null;
        }
        this.beforeMetadataOperation(conn);
        ResultSet indexes = null;
        try {
            indexes = meta.getIndexInfo(this.getCatalogNameForMetadata(catalog), this.getSchemaNameForMetadata(schemaName), this.getTableNameForMetadata(tableName), unique, approx);
            ArrayList<Index> indexList = new ArrayList<Index>();
            while (indexes != null && indexes.next()) {
                indexList.add(this.newIndex(indexes));
            }
            Index[] indexArray = indexList.toArray(new Index[indexList.size()]);
            return indexArray;
        }
        finally {
            if (indexes != null) {
                try {
                    indexes.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected Index newIndex(ResultSet idxMeta) throws SQLException {
        Index idx = new Index();
        idx.setSchemaIdentifier(this.fromDBName(idxMeta.getString("TABLE_SCHEM"), DBIdentifier.DBIdentifierType.SCHEMA));
        idx.setTableIdentifier(this.fromDBName(idxMeta.getString("TABLE_NAME"), DBIdentifier.DBIdentifierType.TABLE));
        idx.setColumnIdentifier(this.fromDBName(idxMeta.getString("COLUMN_NAME"), DBIdentifier.DBIdentifierType.COLUMN));
        idx.setIdentifier(this.fromDBName(idxMeta.getString("INDEX_NAME"), DBIdentifier.DBIdentifierType.INDEX));
        idx.setUnique(!idxMeta.getBoolean("NON_UNIQUE"));
        return idx;
    }

    public ForeignKey[] getImportedKeys(DatabaseMetaData meta, String catalog, String schemaName, String tableName, Connection conn) throws SQLException {
        return this.getImportedKeys(meta, catalog, schemaName, tableName, conn, true);
    }

    public ForeignKey[] getImportedKeys(DatabaseMetaData meta, DBIdentifier catalog, DBIdentifier schemaName, DBIdentifier tableName, Connection conn) throws SQLException {
        return this.getImportedKeys(meta, catalog, schemaName, tableName, conn, true);
    }

    public ForeignKey[] getImportedKeys(DatabaseMetaData meta, String catalog, String schemaName, String tableName, Connection conn, boolean partialKeys) throws SQLException {
        return this.getImportedKeys(meta, DBIdentifier.newCatalog(catalog), DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(tableName), conn, partialKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForeignKey[] getImportedKeys(DatabaseMetaData meta, DBIdentifier catalog, DBIdentifier schemaName, DBIdentifier tableName, Connection conn, boolean partialKeys) throws SQLException {
        if (!this.supportsForeignKeys) {
            return null;
        }
        if (tableName == null && !this.supportsNullTableForGetImportedKeys) {
            return null;
        }
        this.beforeMetadataOperation(conn);
        ResultSet keys = null;
        try {
            keys = meta.getImportedKeys(this.getCatalogNameForMetadata(catalog), this.getSchemaNameForMetadata(schemaName), this.getTableNameForMetadata(tableName));
            ArrayList<ForeignKey> importedKeyList = new ArrayList<ForeignKey>();
            HashMap<ForeignKey.FKMapKey, ForeignKey> fkMap = new HashMap<ForeignKey.FKMapKey, ForeignKey>();
            while (keys != null && keys.next()) {
                ForeignKey fk;
                ForeignKey nfk = this.newForeignKey(keys);
                if (!partialKeys && (fk = this.combineForeignKey(fkMap, nfk)) != nfk) continue;
                importedKeyList.add(nfk);
            }
            ForeignKey[] foreignKeyArray = importedKeyList.toArray(new ForeignKey[importedKeyList.size()]);
            return foreignKeyArray;
        }
        finally {
            if (keys != null) {
                try {
                    keys.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected ForeignKey combineForeignKey(Map<ForeignKey.FKMapKey, ForeignKey> fkMap, ForeignKey fk) {
        ForeignKey.FKMapKey fkmk = new ForeignKey.FKMapKey(fk);
        ForeignKey baseKey = fkMap.get(fkmk);
        if (baseKey != null) {
            baseKey.addColumn(fk);
            return baseKey;
        }
        fkMap.put(fkmk, fk);
        return fk;
    }

    protected ForeignKey newForeignKey(ResultSet fkMeta) throws SQLException {
        ForeignKey fk = new ForeignKey();
        fk.setSchemaIdentifier(this.fromDBName(fkMeta.getString("FKTABLE_SCHEM"), DBIdentifier.DBIdentifierType.SCHEMA));
        fk.setTableIdentifier(this.fromDBName(fkMeta.getString("FKTABLE_NAME"), DBIdentifier.DBIdentifierType.TABLE));
        fk.setColumnIdentifier(this.fromDBName(fkMeta.getString("FKCOLUMN_NAME"), DBIdentifier.DBIdentifierType.COLUMN));
        fk.setIdentifier(this.fromDBName(fkMeta.getString("FK_NAME"), DBIdentifier.DBIdentifierType.FOREIGN_KEY));
        fk.setPrimaryKeySchemaIdentifier(this.fromDBName(fkMeta.getString("PKTABLE_SCHEM"), DBIdentifier.DBIdentifierType.SCHEMA));
        fk.setPrimaryKeyTableIdentifier(this.fromDBName(fkMeta.getString("PKTABLE_NAME"), DBIdentifier.DBIdentifierType.TABLE));
        fk.setPrimaryKeyColumnIdentifier(this.fromDBName(fkMeta.getString("PKCOLUMN_NAME"), DBIdentifier.DBIdentifierType.COLUMN));
        fk.setKeySequence(fkMeta.getShort("KEY_SEQ"));
        fk.setDeferred(fkMeta.getShort("DEFERRABILITY") == 5);
        short del = fkMeta.getShort("DELETE_RULE");
        switch (del) {
            case 2: {
                fk.setDeleteAction(4);
                break;
            }
            case 4: {
                fk.setDeleteAction(5);
                break;
            }
            case 0: {
                fk.setDeleteAction(3);
                break;
            }
            default: {
                fk.setDeleteAction(2);
            }
        }
        return fk;
    }

    protected String getTableNameForMetadata(String tableName) {
        return this.convertSchemaCase(DBIdentifier.newTable(tableName));
    }

    protected String getTableNameForMetadata(DBIdentifier tableName) {
        return this.convertSchemaCase(tableName.getUnqualifiedName());
    }

    protected String getSchemaNameForMetadata(String schemaName) {
        if (schemaName == null) {
            schemaName = this.conf.getSchema();
        }
        return this.convertSchemaCase(DBIdentifier.newSchema(schemaName));
    }

    protected String getSchemaNameForMetadata(DBIdentifier schemaName) {
        if (DBIdentifier.isNull(schemaName)) {
            schemaName = DBIdentifier.newSchema(this.conf.getSchema());
        }
        return this.convertSchemaCase(schemaName);
    }

    protected String getCatalogNameForMetadata(String catalogName) {
        return this.convertSchemaCase(DBIdentifier.newCatalog(catalogName));
    }

    protected String getCatalogNameForMetadata(DBIdentifier catalogName) {
        return this.convertSchemaCase(catalogName);
    }

    protected String getColumnNameForMetadata(String columnName) {
        return this.convertSchemaCase(DBIdentifier.newColumn(columnName));
    }

    protected String getColumnNameForMetadata(DBIdentifier columnName) {
        return this.convertSchemaCase(columnName);
    }

    public String convertSchemaCase(String objectName) {
        return this.convertSchemaCase(DBIdentifier.newIdentifier(objectName, DBIdentifier.DBIdentifierType.DEFAULT, false));
    }

    public String convertSchemaCase(DBIdentifier objectName) {
        return this.toDBName(this.namingUtil.convertSchemaCase(objectName), false);
    }

    @Override
    public String getSchemaCase() {
        return this.schemaCase;
    }

    private void beforeMetadataOperation(Connection c) {
        if (this.requiresAutoCommitForMetaData) {
            try {
                c.rollback();
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            try {
                if (!c.getAutoCommit()) {
                    c.setAutoCommit(true);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getGeneratedKey(Column col, Connection conn) throws SQLException {
        if (this.lastGeneratedKeyQuery == null) {
            throw new StoreException(_loc.get("no-auto-assign"));
        }
        String query = this.lastGeneratedKeyQuery;
        if (query.indexOf(123) != -1) {
            query = this.getGenKeySeqName(query, col);
        }
        PreparedStatement stmnt = this.prepareStatement(conn, query);
        ResultSet rs = null;
        try {
            this.setQueryTimeout(stmnt, this.conf.getQueryTimeout());
            rs = this.executeQuery(conn, stmnt, query);
            Object object = this.getKey(rs, col);
            return object;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException se) {}
            }
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException se) {}
            }
        }
    }

    protected String getGenKeySeqName(String query, Column col) {
        return MessageFormat.format(query, this.toDBName(col.getIdentifier()), this.getFullName(col.getTable(), false), this.getGeneratedKeySequenceName(col));
    }

    protected String getGeneratedKeySequenceName(Column col) {
        return this.toDBName(this.namingUtil.getGeneratedKeySequenceName(col, this.maxAutoAssignNameLength));
    }

    @Override
    public void setConfiguration(Configuration conf) {
        this.conf = (JDBCConfiguration)conf;
        this.log = this.conf.getLog("openjpa.jdbc.JDBC");
        this.namingUtil = this.conf.getIdentifierUtilInstance();
        this.namingUtil.setIdentifierConfiguration(this);
        this.configureNamingRules();
        if (this.log.isWarnEnabled() && !this.isSupported()) {
            this.log.warn(_loc.get("dict-not-supported", this.getClass()));
        }
    }

    private boolean isSupported() {
        Class<?> c = this.getClass();
        while (!c.getName().startsWith("org.apache.openjpa.")) {
            c = c.getSuperclass();
        }
        return c != DBDictionary.class;
    }

    @Override
    public void startConfiguration() {
    }

    @Override
    public void endConfiguration() {
        InputStream in = DBDictionary.class.getResourceAsStream("sql-keywords.rsrc");
        try {
            String keywords = new BufferedReader(new InputStreamReader(in)).readLine();
            this.reservedWordSet.addAll(Arrays.asList(Strings.split((String)keywords, (String)",", (int)0)));
        }
        catch (IOException ioe) {
            throw new GeneralException(ioe);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
        if (this.reservedWords != null) {
            this.reservedWordSet.addAll(Arrays.asList(Strings.split((String)this.reservedWords.toUpperCase(), (String)",", (int)0)));
        }
        if (this.systemSchemas != null) {
            this.systemSchemaSet.addAll(Arrays.asList(Strings.split((String)this.systemSchemas.toUpperCase(), (String)",", (int)0)));
        }
        if (this.systemTables != null) {
            this.systemTableSet.addAll(Arrays.asList(Strings.split((String)this.systemTables.toUpperCase(), (String)",", (int)0)));
        }
        if (this.fixedSizeTypeNames != null) {
            this.fixedSizeTypeNameSet.addAll(Arrays.asList(Strings.split((String)this.fixedSizeTypeNames.toUpperCase(), (String)",", (int)0)));
        }
        this.nextSequenceQuery = StringUtils.trimToNull((String)this.nextSequenceQuery);
        if (this.selectWords != null) {
            this.selectWordSet.addAll(Arrays.asList(Strings.split((String)this.selectWords.toUpperCase(), (String)",", (int)0)));
        }
        SQLErrorCodeReader codeReader = new SQLErrorCodeReader();
        String rsrc = "sql-error-state-codes.xml";
        InputStream stream = this.getClass().getResourceAsStream(rsrc);
        String dictionaryClassName = this.getClass().getName();
        if (stream == null) {
            stream = DBDictionary.class.getResourceAsStream(rsrc);
            dictionaryClassName = this.getClass().getSuperclass().getName();
        }
        codeReader.parse(stream, dictionaryClassName, this);
    }

    public void addErrorCode(int errorType, String errorCode) {
        if (errorCode == null || errorCode.trim().length() == 0) {
            return;
        }
        Set<String> codes = this.sqlStateCodes.get(errorType);
        if (codes == null) {
            codes = new HashSet<String>();
            codes.add(errorCode.trim());
            this.sqlStateCodes.put(errorType, codes);
        } else {
            codes.add(errorCode.trim());
        }
    }

    public void setTimeouts(PreparedStatement stmnt, JDBCFetchConfiguration fetch, boolean forUpdate) throws SQLException {
        if (this.supportsQueryTimeout) {
            int timeout = fetch.getQueryTimeout();
            if (forUpdate) {
                timeout = Math.max(fetch.getQueryTimeout(), fetch.getLockTimeout());
            }
            this.setQueryTimeout(stmnt, timeout);
        }
    }

    public void setTimeouts(PreparedStatement stmnt, JDBCConfiguration conf, boolean forUpdate) throws SQLException {
        if (this.supportsQueryTimeout) {
            int timeout = conf.getQueryTimeout();
            if (forUpdate) {
                timeout = Math.max(conf.getQueryTimeout(), conf.getLockTimeout());
            }
            this.setQueryTimeout(stmnt, timeout);
        }
    }

    public void setQueryTimeout(PreparedStatement stmnt, int timeout) throws SQLException {
        if (this.supportsQueryTimeout) {
            if (timeout == -1) {
                timeout = 0;
            } else {
                if (timeout < 0) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn(_loc.get("invalid-timeout", timeout));
                    }
                    return;
                }
                if (timeout > 0 && timeout < 1000) {
                    timeout = 1000;
                    if (this.log.isWarnEnabled()) {
                        this.log.warn(_loc.get("millis-query-timeout"));
                    }
                }
            }
            this.setStatementQueryTimeout(stmnt, timeout);
        }
    }

    protected void setStatementQueryTimeout(PreparedStatement stmnt, int timeout) throws SQLException {
        stmnt.setQueryTimeout(timeout / 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection decorate(Connection conn) throws SQLException {
        if (!this.connected) {
            this.connectedConfiguration(conn);
        }
        if (!StringUtils.isEmpty((String)this.initializationSQL)) {
            PreparedStatement stmnt = null;
            try {
                stmnt = conn.prepareStatement(this.initializationSQL);
                stmnt.execute();
            }
            catch (Exception e) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace(e.toString(), e);
                }
            }
            finally {
                if (stmnt != null) {
                    try {
                        stmnt.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return conn;
    }

    @Override
    public void handleWarning(SQLWarning warning) throws SQLException {
    }

    public OpenJPAException newStoreException(String msg, SQLException[] causes, Object failed) {
        if (causes != null && causes.length > 0) {
            OpenJPAException ret = this.narrow(msg, causes[0], failed);
            ret.setFailedObject(failed).setNestedThrowables(causes);
            return ret;
        }
        return new StoreException(msg).setFailedObject(failed).setNestedThrowables(causes);
    }

    OpenJPAException narrow(String msg, SQLException ex, Object failed) {
        StoreException storeEx;
        int errorType = this.matchErrorState(this.sqlStateCodes, ex);
        switch (errorType) {
            case 1: {
                storeEx = new LockException(failed);
                break;
            }
            case 5: {
                storeEx = new ObjectExistsException(msg);
                break;
            }
            case 2: {
                storeEx = new ObjectNotFoundException(failed);
                break;
            }
            case 3: {
                storeEx = new OptimisticException(failed);
                break;
            }
            case 4: {
                storeEx = new ReferentialIntegrityException(msg);
                break;
            }
            case 6: {
                storeEx = new QueryException((Object)msg);
                break;
            }
            default: {
                storeEx = new StoreException(msg);
            }
        }
        storeEx.setFatal(this.isFatalException(errorType, ex));
        return storeEx;
    }

    protected int matchErrorState(Map<Integer, Set<String>> errorStates, SQLException ex) {
        String errorState = ex.getSQLState();
        for (Map.Entry<Integer, Set<String>> states : errorStates.entrySet()) {
            if (!states.getValue().contains(errorState)) continue;
            return states.getKey();
        }
        return 0;
    }

    public boolean isFatalException(int subtype, SQLException ex) {
        return true;
    }

    public void closeDataSource(DataSource dataSource) {
        DataSourceFactory.closeDataSource(dataSource);
    }

    public String getVersionColumn(Column column, String tableAlias) {
        return this.getVersionColumn(column, DBIdentifier.newTable(tableAlias)).toString();
    }

    public DBIdentifier getVersionColumn(Column column, DBIdentifier tableAlias) {
        return column.getIdentifier();
    }

    public void insertBlobForStreamingLoad(Row row, Column col, JDBCStore store, Object ob, Select sel) throws SQLException {
        if (ob != null) {
            row.setBinaryStream(col, new ByteArrayInputStream(new byte[0]), 0);
        } else {
            row.setNull(col);
        }
    }

    public void insertClobForStreamingLoad(Row row, Column col, Object ob) throws SQLException {
        if (ob != null) {
            row.setCharacterStream(col, new CharArrayReader(new char[0]), 0);
        } else {
            row.setNull(col);
        }
    }

    public void updateBlob(Select sel, JDBCStore store, InputStream is) throws SQLException {
        SQLBuffer sql2 = sel.toSelect(true, store.getFetchConfiguration());
        ResultSet res = null;
        Connection conn = store.getConnection();
        PreparedStatement stmnt = null;
        try {
            stmnt = sql2.prepareStatement(conn, store.getFetchConfiguration(), 1005, 1008);
            this.setTimeouts(stmnt, store.getFetchConfiguration(), true);
            res = stmnt.executeQuery();
            if (!res.next()) {
                throw new InternalException(_loc.get("stream-exception"));
            }
            Blob blob = res.getBlob(1);
            OutputStream os = blob.setBinaryStream(1L);
            this.copy(is, os);
            os.close();
            res.updateBlob(1, blob);
            res.updateRow();
        }
        catch (IOException ioe) {
            throw new StoreException(ioe);
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException e) {}
            }
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public void updateClob(Select sel, JDBCStore store, Reader reader) throws SQLException {
        SQLBuffer sql2 = sel.toSelect(true, store.getFetchConfiguration());
        ResultSet res = null;
        Connection conn = store.getConnection();
        PreparedStatement stmnt = null;
        try {
            stmnt = sql2.prepareStatement(conn, store.getFetchConfiguration(), 1005, 1008);
            this.setTimeouts(stmnt, store.getFetchConfiguration(), true);
            res = stmnt.executeQuery();
            if (!res.next()) {
                throw new InternalException(_loc.get("stream-exception"));
            }
            Clob clob = res.getClob(1);
            if (clob != null) {
                Writer writer = clob.setCharacterStream(1L);
                this.copy(reader, writer);
                writer.close();
                res.updateClob(1, clob);
                res.updateRow();
            }
        }
        catch (IOException ioe) {
            throw new StoreException(ioe);
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException e) {}
            }
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    protected long copy(InputStream in, OutputStream out) throws IOException {
        byte[] copyBuffer = new byte[this.blobBufferSize];
        long bytesCopied = 0L;
        int read = -1;
        while ((read = in.read(copyBuffer, 0, copyBuffer.length)) != -1) {
            out.write(copyBuffer, 0, read);
            bytesCopied += (long)read;
        }
        return bytesCopied;
    }

    protected long copy(Reader reader, Writer writer) throws IOException {
        char[] copyBuffer = new char[this.clobBufferSize];
        long bytesCopied = 0L;
        int read = -1;
        while ((read = reader.read(copyBuffer, 0, copyBuffer.length)) != -1) {
            writer.write(copyBuffer, 0, read);
            bytesCopied += (long)read;
        }
        return bytesCopied;
    }

    public String getCastFunction(Val val, String func) {
        return func;
    }

    public String getCastFunction(Val val, String func, Column col) {
        return this.getCastFunction(val, func);
    }

    public void createIndexIfNecessary(Schema schema, String table, Column pkColumn) {
    }

    public void createIndexIfNecessary(Schema schema, DBIdentifier table, Column pkColumn) {
    }

    public int getBatchLimit() {
        return this.batchLimit;
    }

    public void setBatchLimit(int limit) {
        this.batchLimit = limit;
    }

    public boolean validateBatchProcess(RowImpl row, Column[] autoAssign, OpenJPAStateManager sm, ClassMapping cmd) {
        boolean disableBatch = false;
        if (this.getBatchLimit() == 0) {
            return false;
        }
        if (autoAssign != null && sm != null) {
            FieldMetaData[] fmd = cmd.getPrimaryKeyFields();
            for (int i = 0; !disableBatch && i < fmd.length; ++i) {
                if (fmd[i].getValueStrategy() != 3) continue;
                disableBatch = true;
            }
        }
        if (!disableBatch) {
            disableBatch = this.validateDBSpecificBatchProcess(disableBatch, row, autoAssign, sm, cmd);
        }
        return disableBatch;
    }

    public boolean validateDBSpecificBatchProcess(boolean disableBatch, RowImpl row, Column[] autoAssign, OpenJPAStateManager sm, ClassMapping cmd) {
        return disableBatch;
    }

    protected ResultSet executeQuery(Connection conn, PreparedStatement stmnt, String sql2) throws SQLException {
        return stmnt.executeQuery();
    }

    protected PreparedStatement prepareStatement(Connection conn, String sql2) throws SQLException {
        return conn.prepareStatement(sql2);
    }

    protected Sequence[] getSequence(ResultSet rs) throws SQLException {
        ArrayList<Sequence> seqList = new ArrayList<Sequence>();
        while (rs != null && rs.next()) {
            seqList.add(this.newSequence(rs));
        }
        return seqList.toArray(new Sequence[seqList.size()]);
    }

    protected Object getKey(ResultSet rs, Column col) throws SQLException {
        if (!rs.next()) {
            throw new StoreException(_loc.get("no-genkey"));
        }
        Object key = rs.getObject(1);
        if (key == null) {
            this.log.warn(_loc.get("invalid-genkey", col));
        }
        return key;
    }

    protected void calculateValue(Val val, Select sel, ExpContext ctx, ExpState state, Path path, ExpState pathState) {
        val.calculateValue(sel, ctx, state, (Val)((Object)path), pathState);
    }

    public boolean isSelect(String sql2) {
        for (String cur : this.selectWordSet) {
            if (sql2.length() < cur.length() || !sql2.substring(0, cur.length()).equalsIgnoreCase(cur)) continue;
            return true;
        }
        return false;
    }

    public boolean needsToCreateIndex(Index idx, Table table, Unique[] uniques) {
        return this.needsToCreateIndex(idx, table);
    }

    public boolean needsToCreateIndex(Index idx, Table table) {
        return true;
    }

    public int getBatchUpdateCount(PreparedStatement ps) throws SQLException {
        return 0;
    }

    public boolean getTrimSchemaName() {
        return this.trimSchemaName;
    }

    public void setTrimSchemaName(boolean trimSchemaName) {
        this.trimSchemaName = trimSchemaName;
    }

    public void deleteStream(JDBCStore store, Select sel) throws SQLException {
    }

    final String checkNameLength(String name, int length, String msgKey) {
        if (name.length() > length) {
            throw new UserException(_loc.get(msgKey, name, name.length(), length));
        }
        return name;
    }

    final String checkNameLength(DBIdentifier identifier, int length, String msgKey) {
        return this.checkNameLength(identifier, length, msgKey, false);
    }

    final String checkNameLength(DBIdentifier identifier, int length, String msgKey, boolean qualified) {
        String compareName;
        String name = this.toDBName(identifier);
        String string = compareName = qualified ? name : this.toDBName(identifier.getUnqualifiedName());
        if (compareName.length() > length) {
            throw new UserException(_loc.get(msgKey, name, name.length(), length));
        }
        return name;
    }

    protected void setDelimitedCase(DatabaseMetaData metaData) {
        block7: {
            try {
                if (metaData.storesMixedCaseQuotedIdentifiers()) {
                    this.delimitedCase = SCHEMA_CASE_PRESERVE;
                } else if (metaData.storesUpperCaseQuotedIdentifiers()) {
                    this.delimitedCase = SCHEMA_CASE_UPPER;
                } else if (metaData.storesLowerCaseQuotedIdentifiers()) {
                    this.delimitedCase = SCHEMA_CASE_LOWER;
                }
            }
            catch (SQLException e) {
                this.getLog().warn("cannot-determine-identifier-case");
                if (!this.getLog().isTraceEnabled()) break block7;
                this.getLog().trace(e.toString(), e);
            }
        }
    }

    @Override
    public boolean getSupportsDelimitedIdentifiers() {
        return this.supportsDelimitedIdentifiers;
    }

    public void setSupportsDelimitedIdentifiers(DatabaseMetaData metaData) {
        try {
            this.supportsDelimitedIdentifiers = metaData.supportsMixedCaseQuotedIdentifiers() || metaData.storesLowerCaseQuotedIdentifiers() || metaData.storesUpperCaseQuotedIdentifiers();
        }
        catch (SQLException e) {
            this.supportsDelimitedIdentifiers = false;
            this.getLog().warn(_loc.get("unknown-delim-support", e));
        }
    }

    public boolean getDelimitIdentifiers() {
        return this.delimitIdentifiers;
    }

    public void setDelimitIdentifiers(boolean delimitIds) {
        this.delimitIdentifiers = delimitIds;
    }

    public boolean getSupportsXMLColumn() {
        return this.supportsXMLColumn;
    }

    public void setSupportsXMLColumn(boolean b) {
        this.supportsXMLColumn = b;
    }

    public String getXMLTypeEncoding() {
        return this.xmlTypeEncoding;
    }

    public void setXMLTypeEncoding(String encoding) {
        this.xmlTypeEncoding = encoding;
    }

    public Log getLog() {
        return this.log;
    }

    @Override
    public boolean delimitAll() {
        return this.delimitIdentifiers;
    }

    @Override
    public String getLeadingDelimiter() {
        return this.leadingDelimiter;
    }

    public void setLeadingDelimiter(String delim) {
        this.leadingDelimiter = delim;
    }

    @Override
    public String getIdentifierDelimiter() {
        return this.catalogSeparator;
    }

    @Override
    public String getIdentifierConcatenator() {
        return this.nameConcatenator;
    }

    @Override
    public String getTrailingDelimiter() {
        return this.trailingDelimiter;
    }

    public void setTrailingDelimiter(String delim) {
        this.trailingDelimiter = delim;
    }

    @Override
    public IdentifierRule getDefaultIdentifierRule() {
        if (this.defaultNamingRule == null) {
            this.defaultNamingRule = this.namingRules.get(DBIdentifier.DBIdentifierType.DEFAULT.name());
        }
        return this.defaultNamingRule;
    }

    @Override
    public <T> IdentifierRule getIdentifierRule(T t) {
        if (t.equals(DBIdentifier.DBIdentifierType.DEFAULT.name())) {
            return this.getDefaultIdentifierRule();
        }
        IdentifierRule nrule = this.namingRules.get(t);
        if (nrule == null) {
            return this.getDefaultIdentifierRule();
        }
        return nrule;
    }

    public Map<String, IdentifierRule> getIdentifierRules() {
        return this.namingRules;
    }

    public DBIdentifierUtil getNamingUtil() {
        return this.namingUtil;
    }

    @Override
    public String getDelimitedCase() {
        return this.delimitedCase;
    }

    public String toDBName(DBIdentifier name) {
        return this.getNamingUtil().toDBName(name);
    }

    public String toDBName(DBIdentifier name, boolean delimit) {
        return this.getNamingUtil().toDBName(name, delimit);
    }

    public DBIdentifier fromDBName(String name, DBIdentifier.DBIdentifierType id) {
        return this.getNamingUtil().fromDBName(name, id);
    }

    public void setDefaultSchemaName(String defaultSchemaName) {
        this.defaultSchemaName = defaultSchemaName;
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    @Override
    public String getConversionKey() {
        if (this.conversionKey == null) {
            this.conversionKey = this.getLeadingDelimiter() + this.getIdentifierDelimiter() + this.getTrailingDelimiter();
        }
        return this.conversionKey;
    }

    public String getMarkerForInsertUpdate(Column col, Object val) {
        return "?";
    }

    public String getIsNullSQL(String colAlias, int colType) {
        return String.format("%s IS NULL", colAlias);
    }

    public String getIsNotNullSQL(String colAlias, int colType) {
        return String.format("%s IS NOT NULL", colAlias);
    }

    public String getIdentityColumnName() {
        return null;
    }

    public static class SerializedData {
        public final byte[] bytes;

        public SerializedData(byte[] bytes) {
            this.bytes = bytes;
        }
    }
}

