/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder.archive;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.xbean.finder.archive.Archive;

public class CompositeArchive
implements Archive {
    private final List<Archive> archives = new ArrayList<Archive>();

    public CompositeArchive(Archive ... archives) {
        this(Arrays.asList(archives));
    }

    public CompositeArchive(Iterable<Archive> archives) {
        for (Archive archive : archives) {
            this.archives.add(archive);
        }
    }

    @Override
    public InputStream getBytecode(String className) throws IOException, ClassNotFoundException {
        for (Archive archive : this.archives) {
            try {
                return archive.getBytecode(className);
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(className);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        for (Archive archive : this.archives) {
            try {
                return archive.loadClass(className);
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(className);
    }

    @Override
    public Iterator<Archive.Entry> iterator() {
        if (this.archives.size() == 1) {
            return this.archives.get(0).iterator();
        }
        return new CompositeIterator(this.archives);
    }

    private static class CompositeIterator
    implements Iterator<Archive.Entry> {
        private Iterator<Archive> archives;
        private Iterator<Archive.Entry> current;

        private CompositeIterator(Iterable<Archive> archives) {
            this.archives = archives.iterator();
            if (this.archives.hasNext()) {
                this.current = this.archives.next().iterator();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.current == null) {
                return false;
            }
            if (this.current.hasNext()) {
                return true;
            }
            if (this.archives.hasNext()) {
                this.current = this.archives.next().iterator();
                return this.hasNext();
            }
            return false;
        }

        @Override
        public Archive.Entry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.current.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

