/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina.cdi;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.spi.Contextual;
import javax.servlet.http.HttpSession;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StandardSessionFacade;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.webbeans.context.SessionContext;
import org.apache.webbeans.context.creational.BeanInstanceBag;
import org.apache.webbeans.util.WebBeansUtil;

public class SessionContextBackedByHttpSession
extends SessionContext {
    private static final String WRAPPER = SystemInstance.get().getProperty("tomee.session-context.wrapper", "direct");
    private HttpSession session;

    public SessionContextBackedByHttpSession(HttpSession session) {
        this.session = session;
        this.setComponentSessionInstanceMap();
    }

    public void setComponentSessionInstanceMap() {
        block9: {
            if (this.session == null) {
                super.setComponentInstanceMap();
                return;
            }
            if (this.session instanceof StandardSessionFacade) {
                try {
                    this.session = (HttpSession)Reflections.get((Object)this.session, (String)"session");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (StandardSession.class.equals(this.session.getClass())) {
                try {
                    ConcurrentHashMap map = (ConcurrentHashMap)Reflections.get((Object)this.session, (String)"attributes");
                    if (WRAPPER.equals("direct")) {
                        this.componentInstanceMap = new DirectSessionMap(map);
                        break block9;
                    }
                    this.componentInstanceMap = new HttpSessionMap(this.session);
                }
                catch (Exception e) {
                    this.componentInstanceMap = new HttpSessionMap(this.session);
                }
            } else {
                this.componentInstanceMap = new HttpSessionMap(this.session);
            }
        }
    }

    public static String key(Object key) {
        if (key instanceof String) {
            return (String)key;
        }
        String id = WebBeansUtil.getPassivationId((Contextual)((Contextual)key));
        if (id != null) {
            return id;
        }
        return key.toString();
    }

    public HttpSession getSession() {
        return this.session;
    }

    private static class HttpSessionMap
    implements ConcurrentMap<Contextual<?>, BeanInstanceBag<?>> {
        private final HttpSession session;

        public HttpSessionMap(HttpSession session) {
            this.session = session;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.session.getAttribute(SessionContextBackedByHttpSession.key(key)) != null;
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Contextual<?>> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<BeanInstanceBag<?>> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean replace(Contextual<?> key, BeanInstanceBag<?> oldValue, BeanInstanceBag<?> newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BeanInstanceBag<?> replace(Contextual<?> key, BeanInstanceBag<?> value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<Map.Entry<Contextual<?>, BeanInstanceBag<?>>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public BeanInstanceBag<?> get(Object key) {
            return (BeanInstanceBag)this.session.getAttribute(SessionContextBackedByHttpSession.key(key));
        }

        @Override
        public BeanInstanceBag<?> put(Contextual<?> key, BeanInstanceBag<?> value) {
            BeanInstanceBag<?> bag = this.get(key);
            this.session.setAttribute(SessionContextBackedByHttpSession.key(key), value);
            return bag;
        }

        @Override
        public BeanInstanceBag<?> remove(Object key) {
            BeanInstanceBag<?> bag = this.get(key);
            this.session.removeAttribute(SessionContextBackedByHttpSession.key(key));
            return bag;
        }

        @Override
        public void putAll(Map<? extends Contextual<?>, ? extends BeanInstanceBag<?>> m) {
            for (Map.Entry<Contextual<?>, BeanInstanceBag<?>> e : m.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }

        @Override
        public BeanInstanceBag<?> putIfAbsent(Contextual<?> key, BeanInstanceBag<?> value) {
            String k = SessionContextBackedByHttpSession.key(key);
            BeanInstanceBag<?> beanInstanceBag = this.get(k);
            if (beanInstanceBag == null) {
                return this.put(key, value);
            }
            return beanInstanceBag;
        }

        @Override
        public boolean remove(Object key, Object value) {
            this.remove(SessionContextBackedByHttpSession.key(key));
            return true;
        }

        public String toString() {
            return "HttpSessionMap{session=" + this.session + '}';
        }
    }

    private static class DirectSessionMap
    implements ConcurrentMap<Contextual<?>, BeanInstanceBag<?>> {
        private final ConcurrentHashMap<String, Object> delegate;

        public DirectSessionMap(ConcurrentHashMap<String, Object> map) {
            this.delegate = map;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Contextual<?>> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<BeanInstanceBag<?>> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<Contextual<?>, BeanInstanceBag<?>>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(SessionContextBackedByHttpSession.key(key));
        }

        @Override
        public BeanInstanceBag<?> get(Object key) {
            return (BeanInstanceBag)this.delegate.get(SessionContextBackedByHttpSession.key(key));
        }

        @Override
        public BeanInstanceBag<?> put(Contextual<?> key, BeanInstanceBag<?> value) {
            return this.delegate.put(SessionContextBackedByHttpSession.key(key), value);
        }

        @Override
        public BeanInstanceBag<?> remove(Object key) {
            return (BeanInstanceBag)this.delegate.remove(SessionContextBackedByHttpSession.key(key));
        }

        @Override
        public void putAll(Map<? extends Contextual<?>, ? extends BeanInstanceBag<?>> m) {
            for (Map.Entry<Contextual<?>, BeanInstanceBag<?>> e : m.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }

        @Override
        public void clear() {
            Iterator it = this.delegate.keySet().iterator();
            while (it.hasNext()) {
                if (!(this.delegate.get(it.next()) instanceof BeanInstanceBag)) continue;
                it.remove();
            }
        }

        @Override
        public BeanInstanceBag<?> putIfAbsent(Contextual<?> key, BeanInstanceBag<?> value) {
            return this.delegate.putIfAbsent(SessionContextBackedByHttpSession.key(key), value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            return this.delegate.remove(SessionContextBackedByHttpSession.key(key), value);
        }

        @Override
        public boolean replace(Contextual<?> key, BeanInstanceBag<?> oldValue, BeanInstanceBag<?> newValue) {
            return this.delegate.replace(SessionContextBackedByHttpSession.key(key), oldValue, newValue);
        }

        @Override
        public BeanInstanceBag<?> replace(Contextual<?> key, BeanInstanceBag<?> value) {
            return this.delegate.replace(SessionContextBackedByHttpSession.key(key), value);
        }
    }
}

