/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina.naming.resources;

import java.io.File;
import java.util.Date;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.naming.resources.FileDirContext;

public class AdditionalDocBase
extends FileDirContext {
    private static final String PREFIX = "/META-INF/resources";
    private static final int PREFIX_LENGTH = "/META-INF/resources".length();
    private static final String WEB_INF_CLASSES = "/WEB-INF/classes";
    private static final boolean RESPECT_HEADERS = Boolean.getBoolean("tomee.AdditionalDocBase.respect-headers");

    protected File file(String name) {
        if (name.startsWith(PREFIX)) {
            return super.file(name.substring(PREFIX_LENGTH));
        }
        if (WEB_INF_CLASSES.equals(name)) {
            return super.file("/");
        }
        return super.file(name);
    }

    protected Attributes doGetAttributes(String name, String[] attrIds) throws NamingException {
        if (RESPECT_HEADERS) {
            return super.doGetAttributes(name, attrIds);
        }
        File file = this.file(name);
        if (file == null) {
            return null;
        }
        return new ForceRefeshAttributes(file);
    }

    private class ForceRefeshAttributes
    extends FileDirContext.FileResourceAttributes {
        public ForceRefeshAttributes(File file) {
            super(file);
        }

        public String getETag() {
            return null;
        }

        public Date getLastModifiedDate() {
            return new Date();
        }

        public long getLastModified() {
            return System.currentTimeMillis();
        }
    }
}

