/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardServer;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.tomee.catalina.TomcatLoader;
import org.apache.tomee.loader.TomcatHelper;

public class ServerListener
implements LifecycleListener {
    private static final Logger LOGGER = Logger.getLogger(ServerListener.class.getName());
    private static boolean listenerInstalled;

    public void lifecycleEvent(LifecycleEvent event) {
        if (listenerInstalled || !"after_init".equals(event.getType())) {
            return;
        }
        if (!(event.getSource() instanceof StandardServer)) {
            return;
        }
        try {
            StandardServer server = (StandardServer)event.getSource();
            TomcatHelper.setServer((StandardServer)server);
            Properties properties = new Properties();
            System.getProperties().setProperty("openejb.embedder.source", this.getClass().getSimpleName());
            properties.setProperty("openejb.embedder.source", this.getClass().getSimpleName());
            if (SystemInstance.isInitialized()) {
                return;
            }
            properties.setProperty("openejb.loader", "tomcat-system");
            String catalinaHome = System.getProperty("catalina.home");
            properties.setProperty("openejb.home", catalinaHome);
            System.setProperty("openejb.home", catalinaHome);
            String catalinaBase = System.getProperty("catalina.base");
            properties.setProperty("openejb.base", catalinaBase);
            System.setProperty("openejb.base", catalinaBase);
            try {
                String serverBuilt;
                String serverInfo;
                ClassLoader classLoader = ServerListener.class.getClassLoader();
                Properties tomcatServerInfo = IO.readProperties((InputStream)classLoader.getResourceAsStream("org/apache/catalina/util/ServerInfo.properties"), (Properties)new Properties());
                String serverNumber = tomcatServerInfo.getProperty("server.number");
                if (serverNumber == null && (serverInfo = tomcatServerInfo.getProperty("server.info")) != null) {
                    int slash = serverInfo.indexOf(47);
                    serverNumber = serverInfo.substring(slash + 1);
                }
                if (serverNumber != null) {
                    System.setProperty("tomcat.version", serverNumber);
                }
                if ((serverBuilt = tomcatServerInfo.getProperty("server.built")) != null) {
                    System.setProperty("tomcat.built", serverBuilt);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            TomcatLoader loader = new TomcatLoader();
            loader.init(properties);
            listenerInstalled = true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "TomEE Listener can't start OpenEJB", e);
        }
    }
}

