/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.naming.ContextBindings;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ThreadContextListener;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.catalina.OpenEJBContext;

public class TomcatThreadContextListener
implements ThreadContextListener {
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB.createChild("tomcat"), (String)"org.apache.openejb.util.resources");
    private static final String OPENEJB_CONTEXT = "OpenEJBContext";
    protected Method method;

    public TomcatThreadContextListener() {
        ContextBindings.bindContext((Object)OPENEJB_CONTEXT, (Context)new OpenEJBContext());
        boolean accessible = false;
        try {
            this.method = ContextBindings.class.getDeclaredMethod("getThreadName", new Class[0]);
            this.method.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            logger.error("Expected ContextBinding to have the method getThreadName()");
        }
    }

    public void contextEntered(ThreadContext oldContext, ThreadContext newContext) {
        try {
            Data data = new Data(this.getThreadName());
            newContext.set(Data.class, (Object)data);
        }
        catch (NamingException ignored) {
            // empty catch block
        }
        try {
            ContextBindings.bindThread((Object)OPENEJB_CONTEXT);
        }
        catch (NamingException e) {
            ContextBindings.unbindContext((Object)OPENEJB_CONTEXT);
            throw new IllegalArgumentException("Unable to bind OpenEJB enc");
        }
    }

    public void contextExited(ThreadContext exitedContext, ThreadContext reenteredContext) {
        ContextBindings.unbindThread((Object)OPENEJB_CONTEXT);
        Data data = (Data)exitedContext.get(Data.class);
        if (data != null && data.oldContextName != null) {
            try {
                ContextBindings.bindThread((Object)data.oldContextName);
            }
            catch (NamingException e) {
                logger.error("Exception in method contextExited", (Throwable)e);
            }
        }
    }

    private Object getThreadName() throws NamingException {
        try {
            Object threadName = this.method.invoke(null, new Object[0]);
            return threadName;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null && e.getCause() instanceof NamingException) {
                throw (NamingException)e.getCause();
            }
            logger.error("Exception in method getThreadName", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            logger.error("Exception in method getThreadName", (Throwable)e);
            return null;
        }
    }

    private static class Data {
        private Object oldContextName;

        public Data(Object oldContextName) {
            this.oldContextName = oldContextName;
        }
    }
}

