/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.ejb.spi.HandleDelegate;
import javax.el.ELResolver;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.servlet.ServletContext;
import javax.servlet.SessionTrackingMode;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextTransaction;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.HostConfig;
import org.apache.catalina.startup.RealmRuleSet;
import org.apache.naming.ContextAccessController;
import org.apache.naming.ContextBindings;
import org.apache.openejb.AppContext;
import org.apache.openejb.Injection;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.ClassListInfo;
import org.apache.openejb.assembler.classic.DeploymentExceptionManager;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.InjectionBuilder;
import org.apache.openejb.assembler.classic.JndiEncBuilder;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.core.CoreContainerSystem;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.core.ivm.naming.SystemComponentReference;
import org.apache.openejb.jee.EnvEntry;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LinkResolver;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.reflection.ReflectionUtil;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.apache.tomee.catalina.BackportUtil;
import org.apache.tomee.catalina.ContextListener;
import org.apache.tomee.catalina.GlobalListenerSupport;
import org.apache.tomee.catalina.JavaeeInstanceManager;
import org.apache.tomee.catalina.LinkageErrorProtection;
import org.apache.tomee.catalina.OpenEJBContextConfig;
import org.apache.tomee.catalina.OpenEJBNamingResource;
import org.apache.tomee.catalina.OpenEJBValve;
import org.apache.tomee.catalina.ProcessAnnotatedListenersListener;
import org.apache.tomee.catalina.ProcessAnnotatedServletsListener;
import org.apache.tomee.catalina.TomEERuntimeException;
import org.apache.tomee.catalina.TomEEWebappLoader;
import org.apache.tomee.catalina.TomcatDeploymentLoader;
import org.apache.tomee.catalina.TomcatJavaJndiBinder;
import org.apache.tomee.catalina.TomcatJndiBuilder;
import org.apache.tomee.catalina.WebBeansListener;
import org.apache.tomee.catalina.WebDeploymentListeners;
import org.apache.tomee.common.LegacyAnnotationProcessor;
import org.apache.tomee.common.TomcatVersion;
import org.apache.tomee.common.UserTransactionFactory;
import org.apache.tomee.loader.TomcatHelper;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.adaptor.ELAdaptor;
import org.omg.CORBA.ORB;

public class TomcatWebAppBuilder
implements WebAppBuilder,
ContextListener {
    public static final String OPENEJB_CROSSCONTEXT_PROPERTY = "openejb.crosscontext";
    public static final String OPENEJB_SESSION_MANAGER_PROPERTY = "openejb.session.manager";
    public static final String OPENEJB_JSESSION_ID_SUPPORT = "openejb.jsessionid-support";
    public static final String OPENEJB_MYFACES_DISABLE_DEFAULT_VALUES = "openejb.myfaces.disable-default-values";
    public static final String IGNORE_CONTEXT = TomcatWebAppBuilder.class.getName() + ".IGNORE";
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB.createChild("tomcat"), (String)"org.apache.openejb.util.resources");
    private static final Digester CONTEXT_DIGESTER = TomcatWebAppBuilder.createDigester();
    public static final String OPENEJB_WEBAPP_MODULE_ID = "openejb.webapp.moduleId";
    public static final String TOMEE_EAT_EXCEPTION_PROP = "tomee.eat-exception";
    public static final String MYFACES_TOMEE_ANNOTATION_FINDER = "org.apache.tomee.myfaces.TomEEAnnotationProvider";
    private final TreeMap<String, ContextInfo> infos = new TreeMap();
    private final GlobalListenerSupport globalListenerSupport;
    private final ConfigurationFactory configurationFactory;
    private final Map<String, HostConfig> deployers = new TreeMap<String, HostConfig>();
    private final Map<String, Host> hosts = new TreeMap<String, Host>();
    private final Map<String, DeployedApplication> deployedApps = new TreeMap<String, DeployedApplication>();
    private final DeploymentLoader deploymentLoader;
    private Assembler assembler;
    private CoreContainerSystem containerSystem;
    private Map<ClassLoader, Map<String, Set<String>>> jsfClasses = new HashMap<ClassLoader, Map<String, Set<String>>>();
    private Class<?> sessionManagerClass = null;
    private static Field HOST_CONFIG_HOST = null;

    public TomcatWebAppBuilder() {
        StandardServer standardServer = TomcatHelper.getServer();
        this.globalListenerSupport = new GlobalListenerSupport(standardServer, this);
        for (Service service : standardServer.findServices()) {
            if (!(service.getContainer() instanceof Engine)) continue;
            Engine engine = (Engine)service.getContainer();
            for (Container engineChild : engine.findChildren()) {
                if (!(engineChild instanceof StandardHost)) continue;
                StandardHost host = (StandardHost)engineChild;
                this.hosts.put(host.getName(), (Host)host);
                for (LifecycleListener listener : host.findLifecycleListeners()) {
                    if (!(listener instanceof HostConfig)) continue;
                    HostConfig hostConfig = (HostConfig)listener;
                    this.deployers.put(host.getName(), hostConfig);
                }
            }
        }
        this.configurationFactory = new ConfigurationFactory();
        this.deploymentLoader = new DeploymentLoader();
    }

    public void start() {
        this.globalListenerSupport.start();
    }

    public void stop() {
        this.globalListenerSupport.stop();
    }

    private static synchronized Digester createDigester() {
        if (CONTEXT_DIGESTER != null) {
            return CONTEXT_DIGESTER;
        }
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("Context", "org.apache.catalina.core.StandardContext", "className");
        digester.addSetProperties("Context");
        digester.addObjectCreate("Context/Loader", "org.apache.catalina.loader.WebappLoader", "className");
        digester.addSetProperties("Context/Loader");
        digester.addSetNext("Context/Loader", "setLoader", "org.apache.catalina.Loader");
        digester.addObjectCreate("Context/Manager", "org.apache.catalina.session.StandardManager", "className");
        digester.addSetProperties("Context/Manager");
        digester.addSetNext("Context/Manager", "setManager", "org.apache.catalina.Manager");
        digester.addObjectCreate("Context/Manager/Store", null, "className");
        digester.addSetProperties("Context/Manager/Store");
        digester.addSetNext("Context/Manager/Store", "setStore", "org.apache.catalina.Store");
        digester.addRuleSet((RuleSet)new RealmRuleSet("Context/"));
        digester.addCallMethod("Context/WatchedResource", "addWatchedResource", 0);
        return digester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployWebApps(AppInfo appInfo, ClassLoader classLoader) throws Exception {
        for (WebAppInfo webApp : appInfo.webApps) {
            HostConfig deployer;
            StandardContext standardContext;
            JarEntry entry;
            File war = new File(webApp.path);
            InputStream contextXml = null;
            if (war.isDirectory()) {
                File cXml = new File(war, "META-INF/context.xml");
                if (cXml.exists()) {
                    contextXml = IO.read((File)cXml);
                    System.out.println("using context file " + cXml.getAbsolutePath());
                }
            } else {
                JarFile warAsJar = new JarFile(war);
                entry = warAsJar.getJarEntry("META-INF/context.xml");
                if (entry != null) {
                    contextXml = warAsJar.getInputStream(entry);
                }
            }
            if (contextXml != null) {
                entry = CONTEXT_DIGESTER;
                synchronized (entry) {
                    try {
                        standardContext = (StandardContext)CONTEXT_DIGESTER.parse(contextXml);
                    }
                    catch (Exception e) {
                        logger.error("can't parse context xml for webapp " + webApp.path, (Throwable)e);
                        standardContext = new StandardContext();
                    }
                    finally {
                        CONTEXT_DIGESTER.reset();
                    }
                }
            }
            standardContext = new StandardContext();
            if (standardContext.getPath() != null) {
                webApp.contextRoot = standardContext.getPath();
            }
            if (webApp.contextRoot.startsWith("/") || webApp.contextRoot.startsWith(File.separator)) {
                webApp.contextRoot = webApp.contextRoot.substring(1);
            }
            if (webApp.contextRoot.startsWith(File.separator)) {
                webApp.contextRoot = webApp.contextRoot.replaceFirst(File.separator, "");
            }
            if (standardContext.getHostname() != null && !"_".equals(standardContext.getHostname())) {
                webApp.host = standardContext.getHostname();
            }
            ApplicationParameter appParam = new ApplicationParameter();
            appParam.setName(OPENEJB_WEBAPP_MODULE_ID);
            appParam.setValue(webApp.moduleId);
            standardContext.addApplicationParameter(appParam);
            if (this.getContextInfo(webApp.host, webApp.contextRoot) != null) continue;
            if (standardContext.getPath() == null) {
                if (webApp.contextRoot != null && webApp.contextRoot.startsWith("/")) {
                    standardContext.setPath(webApp.contextRoot);
                } else {
                    standardContext.setPath("/" + webApp.contextRoot);
                }
            }
            if (standardContext.getDocBase() == null) {
                standardContext.setDocBase(webApp.path);
            }
            if (standardContext.getDocBase() != null && standardContext.getDocBase().endsWith(".war")) {
                standardContext.setDocBase(standardContext.getDocBase().substring(0, standardContext.getDocBase().length() - 4));
            }
            standardContext.setParentClassLoader(classLoader);
            standardContext.setDelegate(true);
            standardContext.setLoader((Loader)new TomEEWebappLoader(appInfo.path, classLoader));
            standardContext.getLoader().setDelegate(true);
            String host = webApp.host;
            if (host == null) {
                host = "localhost";
                logger.warning("using default host: " + host);
            }
            if (TomcatWebAppBuilder.isReady(deployer = this.deployers.get(host))) {
                ContextInfo contextInfo = this.addContextInfo(host, standardContext);
                contextInfo.appInfo = appInfo;
                contextInfo.deployer = deployer;
                deployer.manageApp((Context)standardContext);
                continue;
            }
            if (!this.hosts.containsKey(host)) continue;
            Host theHost = this.hosts.get(host);
            ContextInfo contextInfo = this.addContextInfo(host, standardContext);
            contextInfo.appInfo = appInfo;
            contextInfo.host = theHost;
            theHost.addChild((Container)standardContext);
        }
    }

    private static boolean isReady(HostConfig deployer) {
        if (deployer != null && HOST_CONFIG_HOST != null) {
            try {
                return HOST_CONFIG_HOST.get(deployer) != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static void addMyFacesDefaultParameters(ClassLoader classLoader, ServletContext context) {
        if (!SystemInstance.get().getOptions().get(OPENEJB_MYFACES_DISABLE_DEFAULT_VALUES, false)) {
            if (classLoader != null) {
                try {
                    classLoader.loadClass("org.apache.myfaces.shared.config.MyfacesConfig");
                }
                catch (ClassNotFoundException cnfe) {
                    return;
                }
            }
            TomcatWebAppBuilder.setInitParameter(context, "org.apache.myfaces.LOG_WEB_CONTEXT_PARAMS", "false");
        }
    }

    private static void setInitParameter(ServletContext context, String key, String value) {
        if (context.getInitParameter(key) == null) {
            context.setInitParameter(key, value);
        }
    }

    public void undeployWebApps(AppInfo appInfo) throws Exception {
        for (WebAppInfo webApp : appInfo.webApps) {
            ContextInfo contextInfo = this.getContextInfo(webApp.host, webApp.contextRoot);
            if (contextInfo == null || contextInfo.deployer == null) continue;
            StandardContext standardContext = contextInfo.standardContext;
            HostConfig deployer = contextInfo.deployer;
            if (deployer != null) {
                deployer.unmanageApp(standardContext.getPath());
            } else if (contextInfo.host != null) {
                contextInfo.host.removeChild((Container)standardContext);
            }
            this.deleteDir(new File(standardContext.getServletContext().getRealPath("")));
            this.removeContextInfo(standardContext);
        }
    }

    private void deleteDir(File dir) {
        if (dir == null) {
            return;
        }
        if (dir.isFile()) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.deleteDir(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }

    @Override
    public void init(StandardContext standardContext) {
        LifecycleListener[] listeners;
        TomcatWebAppBuilder.replaceHashSetForJspPropertyGroupsByLinkedHashSet(standardContext);
        standardContext.setCrossContext(SystemInstance.get().getOptions().get(OPENEJB_CROSSCONTEXT_PROPERTY, false));
        standardContext.setNamingResources((NamingResources)new OpenEJBNamingResource());
        String sessionManager = SystemInstance.get().getOptions().get("openejb.session.manager." + standardContext.getName(), (String)null);
        if (sessionManager == null) {
            sessionManager = SystemInstance.get().getOptions().get(OPENEJB_SESSION_MANAGER_PROPERTY, (String)null);
        }
        if (sessionManager != null) {
            if (this.sessionManagerClass == null) {
                try {
                    this.sessionManagerClass = TomcatHelper.getServer().getParentClassLoader().loadClass(sessionManager);
                }
                catch (ClassNotFoundException e) {
                    logger.error("can't find '" + sessionManager + "', StandardManager will be used", (Throwable)e);
                }
            }
            try {
                Manager mgr = (Manager)this.sessionManagerClass.newInstance();
                standardContext.setManager(mgr);
            }
            catch (Exception e) {
                logger.error("can't instantiate '" + sessionManager + "', StandardManager will be used", (Throwable)e);
            }
        }
        if (standardContext.getConfigFile() == null) {
            String s = File.pathSeparator;
            File contextXmlFile = new File(standardContext.getDocBase() + s + "META-INF" + s + "context.xml");
            if (contextXmlFile.exists()) {
                BackportUtil.getAPI().setConfigFile(standardContext, contextXmlFile);
                standardContext.setOverride(true);
            }
        }
        for (LifecycleListener l : listeners = standardContext.findLifecycleListeners()) {
            if (!(l instanceof ContextConfig)) continue;
            standardContext.removeLifecycleListener(l);
        }
        standardContext.addLifecycleListener((LifecycleListener)new OpenEJBContextConfig(new StandardContextInfo(standardContext)));
        NamingContextListener ncl = new NamingContextListener();
        ncl.setName(standardContext.getName());
        standardContext.setNamingContextListener(ncl);
        standardContext.addLifecycleListener((LifecycleListener)ncl);
        standardContext.addLifecycleListener((LifecycleListener)new TomcatJavaJndiBinder());
    }

    private static void replaceHashSetForJspPropertyGroupsByLinkedHashSet(StandardContext standardContext) {
        try {
            ReflectionUtil.set((Object)standardContext.getJspConfigDescriptor(), (String)"jspPropertyGroups", new LinkedHashSet());
        }
        catch (OpenEJBException openEJBException) {
            // empty catch block
        }
    }

    @Override
    public void beforeStart(StandardContext standardContext) {
        Set defaultTrackingModes;
        ServletContext sc = standardContext.getServletContext();
        if (sc != null && !SystemInstance.get().getOptions().get(OPENEJB_JSESSION_ID_SUPPORT, true) && (defaultTrackingModes = sc.getEffectiveSessionTrackingModes()).contains(SessionTrackingMode.URL)) {
            HashSet newModes = new HashSet();
            newModes.remove(SessionTrackingMode.URL);
            sc.setSessionTrackingModes(newModes);
        }
    }

    @Override
    public void configureStart(StandardContext standardContext) {
        if (TomcatHelper.isTomcat7()) {
            TomcatHelper.configureJarScanner((StandardContext)standardContext);
            ContextTransaction contextTransaction = new ContextTransaction();
            contextTransaction.setProperty("factory", (Object)UserTransactionFactory.class.getName());
            standardContext.getNamingResources().setTransaction(contextTransaction);
            this.startInternal(standardContext);
        }
        TomcatWebAppBuilder.addMyFacesDefaultParameters(standardContext.getLoader().getClassLoader(), standardContext.getServletContext());
    }

    @Override
    public void start(StandardContext standardContext) {
        if (!TomcatHelper.isTomcat7()) {
            this.startInternal(standardContext);
        }
    }

    private void startInternal(StandardContext standardContext) {
        String contextRoot;
        AppModule appModule;
        System.out.println("TomcatWebAppBuilder.start " + standardContext.getPath());
        if (TomcatWebAppBuilder.isIgnored(standardContext)) {
            return;
        }
        CoreContainerSystem cs = this.getContainerSystem();
        Assembler a = this.getAssembler();
        if (a == null) {
            logger.warning("OpenEJB has not been initialized so war will not be scanned for nested modules " + standardContext.getPath());
            return;
        }
        AppContext appContext = null;
        ContextInfo contextInfo = this.getContextInfo(standardContext);
        ClassLoader classLoader = standardContext.getLoader().getClassLoader();
        if (contextInfo == null && (appModule = this.loadApplication(standardContext)) != null) {
            try {
                AppInfo appInfo;
                contextInfo = this.addContextInfo(standardContext.getHostname(), standardContext);
                contextInfo.appInfo = appInfo = this.configurationFactory.configureApplication(appModule);
                appContext = a.createApplication(contextInfo.appInfo, classLoader);
            }
            catch (Exception e) {
                TomcatWebAppBuilder.undeploy(standardContext, contextInfo);
                logger.error("Unable to deploy collapsed ear in war " + standardContext.getPath() + ": Exception: " + e.getMessage(), (Throwable)e);
                if (System.getProperty(TOMEE_EAT_EXCEPTION_PROP) == null) {
                    TomEERuntimeException tre = new TomEERuntimeException(e);
                    DeploymentExceptionManager dem = (DeploymentExceptionManager)SystemInstance.get().getComponent(DeploymentExceptionManager.class);
                    dem.saveDeploymentException(contextInfo.appInfo, (Exception)tre);
                    throw tre;
                }
                return;
            }
        }
        if (appContext == null && (contextRoot = standardContext.getName()).startsWith("/")) {
            contextRoot = contextRoot.replaceAll("^/+", "");
        }
        contextInfo.standardContext = standardContext;
        WebAppInfo webAppInfo = null;
        if (contextInfo.appInfo != null) {
            for (WebAppInfo w : contextInfo.appInfo.webApps) {
                if (!("/" + w.contextRoot).equals(standardContext.getPath()) && !this.isRootApplication(standardContext)) continue;
                webAppInfo = w;
                if (appContext != null) break;
                appContext = cs.getAppContext((Object)contextInfo.appInfo.appId);
                break;
            }
        }
        if (webAppInfo != null) {
            if (appContext == null) {
                appContext = this.getContainerSystem().getAppContext((Object)contextInfo.appInfo.appId);
            }
            HashMap<String, Set> scannedJsfClasses = new HashMap<String, Set>();
            for (ClassListInfo info : webAppInfo.jsfAnnotatedClasses) {
                scannedJsfClasses.put(info.name, info.list);
            }
            this.jsfClasses.put(standardContext.getLoader().getClassLoader(), scannedJsfClasses);
            try {
                HashSet<Injection> injections = new HashSet<Injection>();
                injections.addAll(appContext.getInjections());
                injections.addAll(new InjectionBuilder(classLoader).buildInjections(webAppInfo.jndiEnc));
                HashMap bindings = new HashMap();
                bindings.putAll(appContext.getBindings());
                bindings.putAll(this.getJndiBuilder(classLoader, webAppInfo, injections).buildBindings(JndiEncBuilder.JndiScope.comp));
                TomcatJndiBuilder jndiBuilder = new TomcatJndiBuilder(standardContext, webAppInfo, injections);
                jndiBuilder.mergeJndi();
                WebContext webContext = new WebContext(appContext);
                webContext.setClassLoader(classLoader);
                webContext.setId(webAppInfo.moduleId);
                webContext.setBindings(bindings);
                webContext.getInjections().addAll(injections);
                appContext.getWebContexts().add(webContext);
                cs.addWebContext(webContext);
                standardContext.setInstanceManager((InstanceManager)new JavaeeInstanceManager(webContext, standardContext));
                standardContext.getServletContext().setAttribute(InstanceManager.class.getName(), (Object)standardContext.getInstanceManager());
            }
            catch (Exception e) {
                logger.error("Error merging Java EE JNDI entries in to war " + standardContext.getPath() + ": Exception: " + e.getMessage(), (Throwable)e);
            }
            JspFactory factory = JspFactory.getDefaultFactory();
            if (factory != null) {
                JspApplicationContext applicationCtx = factory.getJspApplicationContext(standardContext.getServletContext());
                WebBeansContext context = appContext.getWebBeansContext();
                if (context != null && context.getBeanManagerImpl().isInUse()) {
                    ELAdaptor elAdaptor = (ELAdaptor)context.getService(ELAdaptor.class);
                    ELResolver resolver = elAdaptor.getOwbELResolver();
                    applicationCtx.addELResolver(resolver);
                }
            }
        }
    }

    private static void undeploy(StandardContext standardContext, ContextInfo contextInfo) {
        if (TomcatWebAppBuilder.isReady(contextInfo.deployer)) {
            contextInfo.deployer.unmanageApp(standardContext.getName());
        } else if (contextInfo.host != null) {
            contextInfo.host.removeChild((Container)standardContext);
        }
    }

    private JndiEncBuilder getJndiBuilder(ClassLoader classLoader, WebAppInfo webAppInfo, Set<Injection> injections) throws OpenEJBException {
        return new JndiEncBuilder(webAppInfo.jndiEnc, injections, webAppInfo.moduleId, "Bean", null, webAppInfo.uniqueId, classLoader);
    }

    @Override
    public void afterStart(StandardContext standardContext) {
        String[] valves;
        WebBeansListener webBeansListener;
        if (TomcatWebAppBuilder.isIgnored(standardContext)) {
            return;
        }
        ContextInfo contextInfo = this.getContextInfo(standardContext);
        if (contextInfo != null && contextInfo.appInfo == null) {
            return;
        }
        if (contextInfo == null) {
            return;
        }
        NamingContextListener ncl = BackportUtil.getNamingContextListener(standardContext);
        String listenerName = ncl.getName();
        ContextAccessController.setWritable((Object)listenerName, (Object)standardContext);
        try {
            javax.naming.Context openejbContext = this.getContainerSystem().getJNDIContext();
            openejbContext = (javax.naming.Context)openejbContext.lookup("openejb");
            javax.naming.Context root = (javax.naming.Context)ContextBindings.getClassLoader().lookup("");
            javax.naming.Context comp = (javax.naming.Context)ContextBindings.getClassLoader().lookup("comp");
            this.safeBind(root, "openejb", openejbContext);
            for (WebAppInfo webAppInfo : contextInfo.appInfo.webApps) {
                boolean isRoot = this.isRootApplication(standardContext);
                if (!("/" + webAppInfo.contextRoot).equals(standardContext.getPath()) && !isRoot) continue;
                WebContext webContext = this.getContainerSystem().getWebContext(webAppInfo.moduleId);
                if (webContext != null) {
                    webContext.setJndiEnc(comp);
                }
                try {
                    standardContext.getServletContext().setAttribute("javax.faces.validator.beanValidator.ValidatorFactory", openejbContext.lookup("openejb/ValidatorFactory/".replaceFirst("openejb", "") + webAppInfo.uniqueId));
                }
                catch (NamingException ne) {
                    logger.warning("no validator factory found for webapp " + webAppInfo.moduleId);
                }
                break;
            }
            TransactionManager transactionManager = (TransactionManager)SystemInstance.get().getComponent(TransactionManager.class);
            this.safeBind(comp, "TransactionManager", transactionManager);
            TransactionSynchronizationRegistry synchronizationRegistry = (TransactionSynchronizationRegistry)SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class);
            this.safeBind(comp, "TransactionSynchronizationRegistry", synchronizationRegistry);
            this.safeBind(comp, "ORB", new SystemComponentReference(ORB.class));
            this.safeBind(comp, "HandleDelegate", new SystemComponentReference(HandleDelegate.class));
        }
        catch (NamingException e) {
            // empty catch block
        }
        ContextAccessController.setReadOnly((Object)listenerName);
        WebDeploymentListeners listeners = (WebDeploymentListeners)SystemInstance.get().getComponent(WebDeploymentListeners.class);
        if (listeners != null) {
            for (WebAppInfo webApp : contextInfo.appInfo.webApps) {
                listeners.afterApplicationCreated(contextInfo.appInfo, webApp);
            }
        }
        if (!TomcatVersion.hasAnnotationProcessingSupport()) {
            try {
                javax.naming.Context compEnv = (javax.naming.Context)ContextBindings.getClassLoader().lookup("comp/env");
                LegacyAnnotationProcessor annotationProcessor = new LegacyAnnotationProcessor(compEnv);
                standardContext.addContainerListener((ContainerListener)new ProcessAnnotatedListenersListener(annotationProcessor));
                for (Container container : standardContext.findChildren()) {
                    if (!(container instanceof Wrapper)) continue;
                    Wrapper wrapper = (Wrapper)container;
                    wrapper.addInstanceListener((InstanceListener)new ProcessAnnotatedServletsListener(annotationProcessor));
                }
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
        if ((webBeansListener = this.getWebBeansContext(contextInfo)) != null) {
            standardContext.addApplicationEventListener((Object)webBeansListener);
            standardContext.addApplicationLifecycleListener((Object)webBeansListener);
        }
        LinkageErrorProtection.preload(standardContext);
        Pipeline pipeline = standardContext.getPipeline();
        pipeline.addValve((Valve)new OpenEJBValve());
        for (String className : valves = SystemInstance.get().getOptions().get("tomee.valves", "").split(" *, *")) {
            if ("".equals(className)) continue;
            try {
                Class<?> clazz = standardContext.getLoader().getClassLoader().loadClass(className);
                if (!Valve.class.isAssignableFrom(clazz)) continue;
                Valve valve = (Valve)clazz.newInstance();
                pipeline.addValve(valve);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private WebBeansListener getWebBeansContext(ContextInfo contextInfo) {
        AppContext appContext = this.getContainerSystem().getAppContext((Object)contextInfo.appInfo.appId);
        if (appContext == null) {
            return null;
        }
        WebBeansContext webBeansContext = appContext.getWebBeansContext();
        if (webBeansContext == null) {
            return null;
        }
        return new WebBeansListener(webBeansContext);
    }

    private static boolean isIgnored(StandardContext standardContext) {
        if (standardContext.getServletContext().getAttribute(IGNORE_CONTEXT) != null) {
            return true;
        }
        return standardContext.getServletContext().getInitParameter(IGNORE_CONTEXT) != null;
    }

    @Override
    public void beforeStop(StandardContext standardContext) {
    }

    @Override
    public void stop(StandardContext standardContext) {
    }

    @Override
    public void afterStop(StandardContext standardContext) {
        if (TomcatWebAppBuilder.isIgnored(standardContext)) {
            return;
        }
        ContextInfo contextInfo = this.getContextInfo(standardContext);
        if (contextInfo != null && contextInfo.appInfo != null && contextInfo.deployer == null && this.getAssembler().getDeployedApplications().contains(contextInfo.appInfo)) {
            try {
                this.getAssembler().destroyApplication(contextInfo.appInfo.path);
            }
            catch (Exception e) {
                logger.error("Unable to stop web application " + standardContext.getPath() + ": Exception: " + e.getMessage(), (Throwable)e);
            }
        }
        this.removeContextInfo(standardContext);
    }

    @Override
    public void destroy(StandardContext standardContext) {
    }

    @Override
    public void afterStop(StandardServer standardServer) {
        for (ContextInfo contextInfo : this.infos.values()) {
            if (contextInfo == null || contextInfo.deployer == null) continue;
            StandardContext standardContext = contextInfo.standardContext;
            HostConfig deployer = contextInfo.deployer;
            deployer.unmanageApp(standardContext.getPath());
            String realPath = standardContext.getServletContext().getRealPath("");
            if (realPath == null) continue;
            this.deleteDir(new File(realPath));
        }
    }

    @Override
    public synchronized void checkHost(StandardHost standardHost) {
        if (standardHost.getAutoDeploy()) {
            File[] files;
            Iterator<Map.Entry<String, DeployedApplication>> iterator = this.deployedApps.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, DeployedApplication> entry = iterator.next();
                DeployedApplication deployedApplication = entry.getValue();
                if (!deployedApplication.isModified()) continue;
                try {
                    this.getAssembler().destroyApplication(((DeployedApplication)deployedApplication).appInfo.path);
                }
                catch (Exception e) {
                    logger.error("Unable to application " + ((DeployedApplication)deployedApplication).appInfo.path + ": Exception: " + e.getMessage(), (Throwable)e);
                }
                iterator.remove();
            }
            File appBase = this.appBase(standardHost);
            for (File file : files = appBase.listFiles()) {
                String name = file.getName();
                if (name.toLowerCase().endsWith(".war") || name.equals("ROOT") || name.equalsIgnoreCase("META-INF") || name.equalsIgnoreCase("WEB-INF") || file.isDirectory() && new File(file, "WEB-INF").exists() || file.isDirectory() && (new File(file.getParent(), file.getName() + ".ear").exists() || new File(file.getParent(), file.getName() + ".war").exists() || new File(file.getParent(), file.getName() + ".rar").exists()) || this.isDeployed(file, standardHost)) continue;
                try {
                    ContainerBase context;
                    file = file.getCanonicalFile().getAbsoluteFile();
                    AppModule appModule = this.deploymentLoader.load(file);
                    if (appModule.getDeploymentModule().size() == 1 && appModule.getWebModules().size() == 1) {
                        WebModule webModule = (WebModule)appModule.getWebModules().iterator().next();
                        if (file.getAbsolutePath().equals(webModule.getJarLocation())) continue;
                    }
                    for (WebModule webModule : appModule.getWebModules()) {
                        webModule.setHost(standardHost.getName());
                    }
                    AppInfo appInfo = this.configurationFactory.configureApplication(appModule);
                    if (file.isDirectory() && (context = (ContainerBase)standardHost.findChild("/" + name)) != null) {
                        try {
                            standardHost.removeChild((Container)context);
                        }
                        catch (Throwable t) {
                            logger.warning("Error undeploying wep application from Tomcat  " + name, t);
                        }
                        try {
                            context.destroy();
                        }
                        catch (Throwable t) {
                            logger.warning("Error destroying Tomcat web context " + name, t);
                        }
                    }
                    this.getAssembler().createApplication(appInfo);
                    this.deployedApps.put(file.getAbsolutePath(), new DeployedApplication(file, appInfo));
                }
                catch (Throwable e) {
                    logger.warning("Error deploying application " + file.getAbsolutePath(), e);
                }
            }
        }
    }

    private boolean isDeployed(File file, StandardHost standardHost) {
        if (this.deployedApps.containsKey(file.getAbsolutePath())) {
            return true;
        }
        String name = "/" + file.getName();
        if (name.equals("/ROOT")) {
            name = "";
        }
        return file.isFile() && standardHost.findChild(name) != null;
    }

    private boolean isRootApplication(StandardContext standardContext) {
        return "".equals(standardContext.getPath());
    }

    protected File appBase(StandardHost standardHost) {
        File file = new File(standardHost.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), standardHost.getAppBase());
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    private AppModule loadApplication(StandardContext standardContext) {
        AppModule appModule;
        ServletContext servletContext = standardContext.getServletContext();
        TomcatDeploymentLoader tomcatDeploymentLoader = new TomcatDeploymentLoader(standardContext, this.getId(standardContext));
        try {
            appModule = tomcatDeploymentLoader.load(new File(servletContext.getRealPath(".")).getParentFile());
        }
        catch (OpenEJBException e) {
            throw new TomEERuntimeException(e);
        }
        this.loadWebModule(appModule, standardContext);
        return appModule;
    }

    private void loadWebModule(AppModule appModule, StandardContext standardContext) {
        String name;
        WebModule webModule = (WebModule)appModule.getWebModules().get(0);
        WebApp webApp = webModule.getWebApp();
        String path = standardContext.getPath();
        logger.debug("context path = " + path);
        webModule.setHost(standardContext.getHostname());
        NamingResources naming = standardContext.getNamingResources();
        for (ContextEnvironment contextEnvironment : naming.findEnvironments()) {
            EnvEntry envEntry = (EnvEntry)webApp.getEnvEntryMap().get(contextEnvironment.getName());
            if (envEntry == null) {
                envEntry = new EnvEntry();
                envEntry.setName(contextEnvironment.getName());
                webApp.getEnvEntry().add(envEntry);
            }
            envEntry.setEnvEntryValue(contextEnvironment.getValue());
            envEntry.setEnvEntryType(contextEnvironment.getType());
        }
        for (ContextEnvironment contextEnvironment : naming.findResources()) {
            name = contextEnvironment.getName();
            this.removeRef(webApp, name);
        }
        for (ContextEnvironment contextEnvironment : naming.findResourceLinks()) {
            name = contextEnvironment.getName();
            this.removeRef(webApp, name);
        }
        for (ContextEnvironment contextEnvironment : naming.findEnvironments()) {
            if (contextEnvironment.getOverride()) continue;
            webApp.getEnvEntryMap().remove(contextEnvironment.getName());
        }
    }

    private void removeRef(WebApp webApp, String name) {
        webApp.getEnvEntryMap().remove(name);
        webApp.getEjbRefMap().remove(name);
        webApp.getEjbLocalRefMap().remove(name);
        webApp.getMessageDestinationRefMap().remove(name);
        webApp.getPersistenceContextRefMap().remove(name);
        webApp.getPersistenceUnitRefMap().remove(name);
        webApp.getResourceRefMap().remove(name);
        webApp.getResourceEnvRefMap().remove(name);
    }

    private void safeBind(javax.naming.Context comp, String name, Object value) {
        try {
            comp.lookup(name);
            logger.info(name + " already bound, ignoring");
        }
        catch (Exception e) {
            try {
                comp.bind(name, value);
            }
            catch (NamingException ne) {
                logger.error("Error in safeBind method", (Throwable)e);
            }
        }
    }

    private Assembler getAssembler() {
        if (this.assembler == null) {
            this.assembler = (Assembler)SystemInstance.get().getComponent(org.apache.openejb.spi.Assembler.class);
        }
        return this.assembler;
    }

    private CoreContainerSystem getContainerSystem() {
        if (this.containerSystem == null) {
            this.containerSystem = (CoreContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        }
        return this.containerSystem;
    }

    private String getId(StandardContext standardContext) {
        String contextRoot = standardContext.getName();
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        return standardContext.getHostname() + contextRoot;
    }

    private ContextInfo getContextInfo(StandardContext standardContext) {
        String id = this.getId(standardContext);
        ContextInfo contextInfo = this.infos.get(id);
        return contextInfo;
    }

    private ContextInfo getContextInfo(String webAppHost, String webAppContextRoot) {
        String host = webAppHost;
        if (host == null) {
            host = "localhost";
        }
        String contextRoot = webAppContextRoot;
        String id = host + "/" + contextRoot;
        ContextInfo contextInfo = this.infos.get(id);
        return contextInfo;
    }

    private ContextInfo addContextInfo(String host, StandardContext standardContext) {
        String id;
        ContextInfo contextInfo;
        String contextRoot = standardContext.getName();
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        if ((contextInfo = this.infos.get(id = host + contextRoot)) == null) {
            contextInfo = new ContextInfo();
            contextInfo.standardContext = standardContext;
            this.infos.put(id, contextInfo);
        }
        return contextInfo;
    }

    private void removeContextInfo(StandardContext standardContext) {
        String id = this.getId(standardContext);
        this.infos.remove(id);
    }

    public Map<ClassLoader, Map<String, Set<String>>> getJsfClasses() {
        return this.jsfClasses;
    }

    static {
        try {
            HOST_CONFIG_HOST = HostConfig.class.getDeclaredField("host");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private static class DeployedApplication {
        private AppInfo appInfo;
        private final Map<File, Long> watchedResource = new HashMap<File, Long>();

        public DeployedApplication(File base, AppInfo appInfo) {
            this.appInfo = appInfo;
            this.watchedResource.put(base, base.lastModified());
            if (appInfo != null) {
                File file;
                for (String resource : appInfo.watchedResources) {
                    File file2 = new File(resource);
                    this.watchedResource.put(file2, file2.lastModified());
                }
                for (EjbJarInfo info : appInfo.ejbJars) {
                    for (String resource : info.watchedResources) {
                        file = new File(resource);
                        this.watchedResource.put(file, file.lastModified());
                    }
                }
                for (EjbJarInfo info : appInfo.webApps) {
                    for (String resource : info.watchedResources) {
                        file = new File(resource);
                        this.watchedResource.put(file, file.lastModified());
                    }
                }
                for (EjbJarInfo info : appInfo.connectors) {
                    for (String resource : info.watchedResources) {
                        file = new File(resource);
                        this.watchedResource.put(file, file.lastModified());
                    }
                }
            }
        }

        public boolean isModified() {
            for (Map.Entry<File, Long> entry : this.watchedResource.entrySet()) {
                File file = entry.getKey();
                long lastModified = entry.getValue();
                if ((file.exists() || lastModified == 0L) && file.lastModified() == lastModified) continue;
                return true;
            }
            return false;
        }
    }

    private static class ContextInfo {
        public AppInfo appInfo;
        public StandardContext standardContext;
        public HostConfig deployer;
        public Host host;
        public LinkResolver<EntityManagerFactory> emfLinkResolver;

        private ContextInfo() {
        }
    }

    public class StandardContextInfo {
        private final StandardContext standardContext;

        public StandardContextInfo(StandardContext standardContext) {
            this.standardContext = standardContext;
        }

        public WebAppInfo get() {
            ContextInfo contextInfo = TomcatWebAppBuilder.this.getContextInfo(this.standardContext);
            System.out.println("contextInfo = " + contextInfo);
            System.out.println("standardContext = " + this.standardContext);
            for (WebAppInfo webApp : contextInfo.appInfo.webApps) {
                if (!this.standardContext.getName().equals("/" + webApp.contextRoot)) continue;
                return webApp;
            }
            return null;
        }

        public String toString() {
            return "StandardContextInfo{standardContext=" + this.standardContext + '}';
        }
    }
}

