/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.common;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.Strings;
import org.apache.tomee.common.NamingUtil;

public abstract class AbstractObjectFactory
implements ObjectFactory {
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable environment) throws Exception {
        Reference ref = (Reference)object;
        String jndiProviderId = NamingUtil.getProperty(ref, "jndiproviderid");
        String jndiName = NamingUtil.getProperty(ref, "jndiname");
        if (jndiName == null) {
            jndiName = this.buildJndiName(ref);
        }
        try {
            return this.lookup(jndiProviderId, jndiName);
        }
        catch (NameNotFoundException nnfe) {
            if (jndiName.startsWith("java:")) {
                try {
                    return new InitialContext().lookup(jndiName);
                }
                catch (NameNotFoundException ignored) {
                    // empty catch block
                }
            }
            if (ref.getClassName() != null) {
                try {
                    return new InitialContext().lookup("java:module/" + Strings.lastPart((String)ref.getClassName(), (char)'.'));
                }
                catch (NameNotFoundException ignored) {
                    // empty catch block
                }
            }
            throw nnfe;
        }
    }

    protected abstract String buildJndiName(Reference var1) throws NamingException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object lookup(String jndiProviderId, String jndiName) throws NamingException {
        Context externalContext;
        Context context = externalContext = this.getContext(jndiProviderId);
        synchronized (context) {
            return externalContext.lookup(jndiName);
        }
    }

    protected Context getContext(String jndiProviderId) throws NamingException {
        if (jndiProviderId != null) {
            String contextJndiName = "java:openejb/remote_jndi_contexts/" + jndiProviderId;
            ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
            Context context = (Context)containerSystem.getJNDIContext().lookup(contextJndiName);
            return context;
        }
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        Context context = containerSystem.getJNDIContext();
        return context;
    }
}

