/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.common;

import java.net.URL;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.tomee.common.AbstractObjectFactory;
import org.apache.tomee.common.NamingUtil;

public class ResourceFactory
extends AbstractObjectFactory {
    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable environment) throws Exception {
        Reference reference = (Reference)object;
        String type = reference.getClassName();
        if ("java.net.URL".equals(type)) {
            String resourceId = NamingUtil.getProperty(reference, "resourceid");
            return new URL(resourceId);
        }
        if ("java.lang.Class".equals(type)) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            String resourceId = NamingUtil.getProperty(reference, "resourceid");
            return loader.loadClass(resourceId);
        }
        return super.getObjectInstance(object, name, context, environment);
    }

    @Override
    protected String buildJndiName(Reference reference) throws NamingException {
        String resourceId = NamingUtil.getProperty(reference, "resourceid");
        if (resourceId == null) {
            resourceId = NamingUtil.getProperty(reference, "name");
        }
        if (resourceId == null) {
            throw new NamingException("Resource reference id is null");
        }
        String jndiName = "java:openejb/Resource/" + resourceId;
        return jndiName;
    }
}

