/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.installer;

import java.io.File;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomee.installer.Installer;
import org.apache.tomee.installer.Paths;

public class InstallerServlet
extends HttpServlet {
    protected Paths paths;
    protected Installer installer;
    protected int attempts;
    private ServletConfig servletConfig;

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        String path = servletConfig.getServletContext().getRealPath("/");
        File openejbWarDir = null;
        if (path != null) {
            openejbWarDir = new File(path);
        }
        this.paths = new Paths(openejbWarDir);
        this.installer = new Installer(this.paths);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doIt(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doIt(httpServletRequest, httpServletResponse);
    }

    protected void doIt(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if ("install".equalsIgnoreCase(req.getParameter("action"))) {
            if (this.installer.getStatus() == Installer.Status.NONE) {
                ++this.attempts;
                this.paths.reset();
                this.installer.reset();
                this.paths.setCatalinaHomeDir(req.getParameter("catalinaHome"));
                this.paths.setCatalinaBaseDir(req.getParameter("catalinaBase"));
                this.paths.setServerXmlFile(req.getParameter("serverXml"));
                if (this.paths.verify()) {
                    this.installer.installAll();
                }
            }
            res.sendRedirect(req.getRequestURI());
        } else {
            req.setAttribute("installer", (Object)this.installer);
            req.setAttribute("paths", (Object)this.paths);
            RequestDispatcher rd = this.servletConfig.getServletContext().getRequestDispatcher("/installer-view.jsp");
            rd.forward((ServletRequest)req, (ServletResponse)res);
        }
    }

    public void dump(ServletOutputStream out) throws IOException {
        this.printFile(out, "Catalina home: ", this.paths.getCatalinaHomeDir());
        this.printFile(out, "Catalina base: ", this.paths.getCatalinaBaseDir());
        this.printFile(out, "Catalina server.xml: ", this.paths.getServerXmlFile());
        this.printFile(out, "Catalina conf: ", this.paths.getCatalinaConfDir());
        this.printFile(out, "Catalina lib: ", this.paths.getCatalinaLibDir());
        this.printFile(out, "Catalina bin: ", this.paths.getCatalinaBinDir());
        this.printFile(out, "Catalina catalina.sh: ", this.paths.getCatalinaShFile());
        this.printFile(out, "Catalina catalina.bat: ", this.paths.getCatalinaBatFile());
        this.printFile(out, "OpenEJB lib: ", this.paths.getOpenEJBLibDir());
        this.printFile(out, "OpenEJB loader jar: ", this.paths.getOpenEJBTomcatLoaderJar());
        this.printFile(out, "OpenEJB javaagent jar: ", this.paths.getOpenEJBJavaagentJar());
    }

    private void printFile(ServletOutputStream out, String description, File file) throws IOException {
        out.println(description + ":");
        out.println("    " + file);
    }
}

