/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.embedded;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.ejb.spi.EJBContainerProvider;
import javax.naming.Context;
import javax.validation.ValidationException;
import org.apache.geronimo.osgi.locator.ProviderLocator;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.util.Exceptions;
import org.apache.openejb.util.NetworkUtil;
import org.apache.tomee.catalina.TomEERuntimeException;
import org.apache.tomee.embedded.Configuration;
import org.apache.tomee.embedded.Container;

public class EmbeddedTomEEContainer
extends EJBContainer {
    public static final String TOMEE_EJBCONTAINER_HTTP_PORT = "tomee.ejbcontainer.http.port";
    private static EmbeddedTomEEContainer tomEEContainer;
    private static final List<String> CONTAINER_NAMES;
    private Container container = new Container();
    private String appId;

    private EmbeddedTomEEContainer(String id) {
        this.appId = id;
    }

    public void close() {
        try {
            if (EmbeddedTomEEContainer.tomEEContainer.container.getAppContexts(this.appId) != null) {
                EmbeddedTomEEContainer.tomEEContainer.container.undeploy(this.appId);
            }
            EmbeddedTomEEContainer.tomEEContainer.container.stop();
        }
        catch (Exception e) {
            throw Exceptions.newEJBException((Throwable)e);
        }
        tomEEContainer = null;
    }

    public Context getContext() {
        return EmbeddedTomEEContainer.tomEEContainer.container.getJndiContext();
    }

    static {
        CONTAINER_NAMES = Arrays.asList(EmbeddedTomEEContainer.class.getName(), "tomee-embedded", "embedded-tomee");
    }

    public static class EmbeddedTomEEContainerProvider
    implements EJBContainerProvider {
        public EJBContainer createEJBContainer(Map<?, ?> properties) {
            Object provider = properties.get("javax.ejb.embeddable.provider");
            int ejbContainerProviders = 1;
            try {
                ejbContainerProviders = ProviderLocator.getServices((String)EJBContainerProvider.class.getName(), EJBContainer.class, (ClassLoader)Thread.currentThread().getContextClassLoader()).size();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (provider == null && ejbContainerProviders > 1 || !provider.equals(EmbeddedTomEEContainer.class) && !CONTAINER_NAMES.contains(provider)) {
                return null;
            }
            if (tomEEContainer != null) {
                return tomEEContainer;
            }
            String appId = (String)properties.get("javax.ejb.embeddable.appName");
            Object modules = properties.get("javax.ejb.embeddable.modules");
            tomEEContainer = new EmbeddedTomEEContainer(appId);
            Configuration configuration = new Configuration();
            if (properties.containsKey(EmbeddedTomEEContainer.TOMEE_EJBCONTAINER_HTTP_PORT)) {
                int port;
                Object portValue = properties.get(EmbeddedTomEEContainer.TOMEE_EJBCONTAINER_HTTP_PORT);
                if (portValue instanceof Integer) {
                    port = (Integer)portValue;
                } else if (portValue instanceof String) {
                    port = Integer.parseInt((String)portValue);
                } else {
                    throw new TomEERuntimeException("port value should be an integer or a string");
                }
                if (port <= 0) {
                    port = NetworkUtil.getNextAvailablePort();
                }
                configuration.setHttpPort(port);
            }
            System.setProperty(EmbeddedTomEEContainer.TOMEE_EJBCONTAINER_HTTP_PORT, Integer.toString(configuration.getHttpPort()));
            tomEEContainer.container.setup(configuration);
            try {
                tomEEContainer.container.start();
                if (modules instanceof File) {
                    tomEEContainer.container.deploy(appId, (File)modules, true);
                } else if (modules instanceof String) {
                    tomEEContainer.container.deploy(appId, new File((String)modules), true);
                } else if (modules instanceof String[]) {
                    for (String path : (String[])modules) {
                        tomEEContainer.container.deploy(appId, new File(path), true);
                    }
                } else if (modules instanceof File[]) {
                    for (File file : (File[])modules) {
                        tomEEContainer.container.deploy(appId, file, true);
                    }
                } else {
                    try {
                        tomEEContainer.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    tomEEContainer = null;
                    throw Exceptions.newNoModulesFoundException();
                }
                EmbeddedTomEEContainer e = tomEEContainer;
                return e;
            }
            catch (OpenEJBException e) {
                throw new EJBException((Exception)((Object)e));
            }
            catch (MalformedURLException e) {
                throw new EJBException((Exception)e);
            }
            catch (ValidationException ve) {
                throw ve;
            }
            catch (Exception e) {
                if (e instanceof EJBException) {
                    throw (EJBException)e;
                }
                throw new TomEERuntimeException("initialization exception", (Throwable)e);
            }
            finally {
                if (tomEEContainer == null) {
                    try {
                        tomEEContainer.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }
}

