/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.embedded;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.tomee.embedded.Configuration;
import org.apache.tomee.embedded.Container;

public class Main {
    public static final String PORT = "port";
    public static final String SHUTDOWN = "shutdown";
    public static final String PATH = "path";
    public static final String CONTEXT = "context";
    public static final String DIRECTORY = "directory";

    public static void main(String[] args) {
        CommandLine line;
        PosixParser parser = new PosixParser();
        Options options = Main.createOptions();
        try {
            line = parser.parse(options, args, true);
        }
        catch (ParseException exp) {
            new HelpFormatter().printHelp("java -jar tomee-embedded-user.jar", options);
            return;
        }
        try {
            final Container container = new Container();
            container.setup(Main.createConfiguration(line));
            container.start();
            if (line.hasOption(PATH)) {
                String[] contexts = line.hasOption(CONTEXT) ? line.getOptionValues(CONTEXT) : null;
                int i = 0;
                for (String path : line.getOptionValues(PATH)) {
                    File file = new File(ProvisioningUtil.realLocation((String)path));
                    if (!file.exists()) {
                        System.err.println(file.getAbsolutePath() + " does not exist, skipping");
                        continue;
                    }
                    String name = file.getName().replaceAll("\\.[A-Za-z]+$", "");
                    if (contexts != null) {
                        name = contexts[i++];
                    }
                    container.deploy(name, file, true);
                }
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        container.stop();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            container.await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        options.addOption(null, PATH, true, "");
        options.addOption(null, CONTEXT, true, "Context name for applications (same order than paths)");
        options.addOption("p", PORT, true, "TomEE http port");
        options.addOption("s", SHUTDOWN, true, "TomEE shutdown port");
        options.addOption("d", DIRECTORY, true, "TomEE shutdown port");
        return options;
    }

    private static Configuration createConfiguration(CommandLine args) {
        Configuration config = new Configuration();
        config.setDir(System.getProperty("java.io.tmpdir"));
        config.setHttpPort(Integer.parseInt(args.getOptionValue(PORT, "8080")));
        config.setStopPort(Integer.parseInt(args.getOptionValue(SHUTDOWN, "8005")));
        config.setDir(args.getOptionValue(DIRECTORY, new File(new File("."), "apache-tomee").getAbsolutePath()));
        return config;
    }
}

