/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.openejb.loader.Embedder;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.loader.Zips;

class TomcatHook {
    static final String ADDITIONAL_LIB_CONFIG = "provisioning.properties";
    static final String ZIP_KEY = "zip";
    static final String DESTINATION_KEY = "destination";
    static final String JAR_KEY = "jar";
    public static final String TEMP_DIR = "temp";

    TomcatHook() {
    }

    static void hook(Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is null");
        }
        if (!properties.containsKey("tomee.war")) {
            throw new IllegalArgumentException("properties must contain the tomee.war property");
        }
        File openejbWar = new File(properties.getProperty("tomee.war"));
        if (!openejbWar.isDirectory()) {
            throw new IllegalArgumentException("tomee.war is not a directory: " + openejbWar);
        }
        if (SystemInstance.isInitialized()) {
            return;
        }
        properties.setProperty("openejb.loader", "tomcat-system");
        String catalinaHome = System.getProperty("catalina.home");
        properties.setProperty("openejb.home", catalinaHome);
        System.setProperty("openejb.home", catalinaHome);
        String catalinaBase = System.getProperty("catalina.base");
        properties.setProperty("openejb.base", catalinaBase);
        System.setProperty("openejb.base", catalinaBase);
        System.setProperty("tomee.war", openejbWar.getAbsolutePath());
        File libDir = new File(openejbWar, "lib");
        String libPath = libDir.getAbsolutePath();
        properties.setProperty("openejb.libs", libPath);
        try {
            String serverBuilt;
            String serverInfo;
            ClassLoader classLoader = TomcatHook.class.getClassLoader();
            Properties tomcatServerInfo = IO.readProperties((InputStream)classLoader.getResourceAsStream("org/apache/catalina/util/ServerInfo.properties"), (Properties)new Properties());
            String serverNumber = tomcatServerInfo.getProperty("server.number");
            if (serverNumber == null && (serverInfo = tomcatServerInfo.getProperty("server.info")) != null) {
                int slash = serverInfo.indexOf(47);
                serverNumber = serverInfo.substring(slash + 1);
            }
            if (serverNumber != null) {
                System.setProperty("tomcat.version", serverNumber);
            }
            if ((serverBuilt = tomcatServerInfo.getProperty("server.built")) != null) {
                System.setProperty("tomcat.built", serverBuilt);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (properties.getProperty("openejb.libs") == null) {
            throw new NullPointerException("openejb.libs property is not set");
        }
        try {
            TomcatHook.addAdditionalLibraries(SystemInstance.get().getBase().getDirectory("conf"), new File(SystemInstance.get().getBase().getDirectory(), ADDITIONAL_LIB_CONFIG));
        }
        catch (IOException e) {
            // empty catch block
        }
        Embedder embedder = new Embedder("org.apache.tomee.catalina.TomcatLoader");
        SystemInstance.get().setComponent(Embedder.class, (Object)embedder);
        try {
            SystemInstance.init((Properties)properties);
            embedder.init(properties);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addAdditionalLibraries(File confDir, File libDir) throws IOException {
        File destination;
        String toExtract;
        File conf = new File(confDir, ADDITIONAL_LIB_CONFIG);
        if (!conf.exists()) {
            return;
        }
        Properties additionalLibProperties = IO.readProperties((File)conf);
        ArrayList<String> libToCopy = new ArrayList<String>();
        String toCopy = additionalLibProperties.getProperty(JAR_KEY);
        if (toCopy != null) {
            for (String lib : toCopy.split(",")) {
                libToCopy.add(ProvisioningUtil.realLocation((String)lib.trim()));
            }
        }
        if ((toExtract = additionalLibProperties.getProperty(ZIP_KEY)) != null) {
            for (String zip : toExtract.split(",")) {
                libToCopy.addAll(TomcatHook.extract(ProvisioningUtil.realLocation((String)zip)));
            }
        }
        if (!(destination = additionalLibProperties.containsKey(DESTINATION_KEY) ? new File(additionalLibProperties.getProperty(DESTINATION_KEY)) : new File(SystemInstance.get().getBase().getDirectory(), Embedder.ADDITIONAL_LIB_FOLDER)).exists()) {
            destination = libDir;
        }
        for (String lib : libToCopy) {
            TomcatHook.copy(new File(lib), destination);
        }
    }

    private static void copy(File file, File lib) throws IOException {
        File dest = new File(lib, file.getName());
        if (dest.exists()) {
            return;
        }
        IO.copy((File)file, (File)dest);
    }

    private static Collection<String> extract(String zip) throws IOException {
        File zipFile;
        File extracted;
        File tmp = new File(SystemInstance.get().getBase().getDirectory(), TEMP_DIR);
        if (!tmp.exists()) {
            tmp.mkdirs();
        }
        if ((extracted = new File(tmp, (zipFile = new File(ProvisioningUtil.realLocation((String)zip))).getName().replace(".zip", ""))).exists()) {
            return TomcatHook.list(extracted);
        }
        TomcatHook.unzip(zipFile, extracted);
        return TomcatHook.list(extracted);
    }

    private static Collection<String> list(File dir) {
        ArrayList<String> libs = new ArrayList<String>();
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                libs.addAll(TomcatHook.list(file));
                continue;
            }
            libs.add(file.getAbsolutePath());
        }
        return libs;
    }

    public static void unzip(File source, File targetDirectory) throws IOException {
        Zips.unzip((File)source, (File)targetDirectory);
    }
}

