/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.loader.service.helper;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tomee.common.TomcatVersion;
import org.apache.tomee.loader.service.ServiceContext;
import org.apache.tomee.loader.service.helper.TestHelper;

public class TestHelperImpl
implements TestHelper {
    private final ServiceContext srvCtx;

    public TestHelperImpl(ServiceContext srvCtx) {
        this.srvCtx = srvCtx;
    }

    @Override
    public List<Map<String, Object>> getTestResults() {
        File openejbHomeLib;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String homePath = System.getProperty("openejb.home");
        result.add(this.createDTO("homeSet", homePath != null));
        File openejbHome = new File(homePath);
        result.add(this.createDTO("homeExists", openejbHome.exists()));
        result.add(this.createDTO("homeDirectory", openejbHome.isDirectory()));
        if (TomcatVersion.v6.isTheVersion() || TomcatVersion.v7.isTheVersion()) {
            openejbHomeLib = new File(openejbHome, "lib");
        } else {
            File common = new File(openejbHome, "common");
            openejbHomeLib = new File(common, "lib");
        }
        result.add(this.createDTO("libDirectory", openejbHomeLib.exists()));
        ClassLoader myLoader = this.getClass().getClassLoader();
        try {
            Class<?> openejb = Class.forName("org.apache.openejb.OpenEJB", true, myLoader);
            result.add(this.createDTO("openEjbInstalled", true));
            try {
                Method isInitialized = openejb.getDeclaredMethod("isInitialized", new Class[0]);
                Boolean running = (Boolean)isInitialized.invoke(openejb, new Object[0]);
                result.add(this.createDTO("openEjbStarted", running));
            }
            catch (Exception e) {
                result.add(this.createDTO("openEjbStarted", false));
            }
        }
        catch (Exception e) {
            result.add(this.createDTO("openEjbInstalled", false));
        }
        try {
            Class.forName("javax.ejb.EJBHome", true, myLoader);
            result.add(this.createDTO("ejbsInstalled", true));
        }
        catch (Exception e) {
            result.add(this.createDTO("ejbsInstalled", false));
        }
        try {
            Object obj = this.srvCtx.getOpenEJBHelper().lookup("");
            if (obj.getClass().getName().equals("org.apache.openejb.core.ivm.naming.IvmContext")) {
                result.add(this.createDTO("testLookup", true));
            } else {
                result.add(this.createDTO("testLookup", false));
            }
        }
        catch (Exception e) {
            result.add(this.createDTO("testLookup", false));
        }
        return result;
    }

    private Map<String, Object> createDTO(String key, boolean success) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("key", key);
        result.put("success", success);
        return result;
    }
}

