/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.openjpa.conf.OpenJPAConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Caches {
    Caches() {
    }

    static Set<Class<?>> addTypesByName(OpenJPAConfiguration conf, Collection<String> classNames, Set<Class<?>> classes) {
        if (classNames == null || classNames.isEmpty()) {
            return classes;
        }
        ClassLoader loader = conf.getClassResolverInstance().getClassLoader(null, null);
        for (String className : classNames) {
            try {
                Class<?> cls = Class.forName(className, true, loader);
                if (classes == null) {
                    classes = new HashSet();
                }
                classes.add(cls);
            }
            catch (Throwable t) {
                conf.getLog("openjpa.Runtime").warn(null, t);
            }
        }
        return classes;
    }
}

