/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.strats.AbstractFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.RelationStrategies;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;

public abstract class ContainerFieldStrategy
extends AbstractFieldStrategy {
    protected abstract ClassMapping[] getIndependentElementMappings(boolean var1);

    public void appendIsEmpty(SQLBuffer sql2, Select sel, Joins joins) {
        this.testEmpty(sql2, sel, joins, true);
    }

    public void appendIsNotEmpty(SQLBuffer sql2, Select sel, Joins joins) {
        this.testEmpty(sql2, sel, joins, false);
    }

    public void appendIsNull(SQLBuffer sql2, Select sel, Joins joins) {
        this.testEmpty(sql2, sel, joins, true);
    }

    public void appendIsNotNull(SQLBuffer sql2, Select sel, Joins joins) {
        this.testEmpty(sql2, sel, joins, false);
    }

    private void testEmpty(SQLBuffer sql2, Select sel, Joins joins, boolean empty) {
        if (empty) {
            sql2.append("0 = ");
        } else {
            sql2.append("0 < ");
        }
        this.appendSize(sql2, sel, joins);
    }

    protected abstract ForeignKey getJoinForeignKey();

    public void appendSize(SQLBuffer sql2, Select sel, Joins joins) {
        DBDictionary dict = this.field.getMappingRepository().getDBDictionary();
        dict.assertSupport(dict.supportsSubselect, "SupportsSubselect");
        ClassMapping[] ind = this.getIndependentElementMappings(false);
        if (ind != null && ind.length > 1) {
            throw RelationStrategies.unjoinable(this.field);
        }
        ForeignKey fk = this.getJoinForeignKey();
        ContainerFieldStrategy.appendJoinCount(sql2, sel, joins, dict, this.field, fk);
    }

    public void appendIndex(SQLBuffer sql2, Select sel, Joins joins) {
        sql2.append(sel.getColumnAlias(this.field.getOrderColumn(), this.field.getName()));
    }

    protected static void appendJoinCount(SQLBuffer sql2, Select sel, Joins joins, DBDictionary dict, FieldMapping field, ForeignKey fk) {
        String fullTable = dict.getFullName(fk.getTable(), false);
        sql2.append("(SELECT COUNT(*) FROM ").append(fullTable).append(" WHERE ");
        ContainerFieldStrategy.appendUnaliasedJoin(sql2, sel, joins, dict, field, fk);
        sql2.append(")");
    }

    public static void appendUnaliasedJoin(SQLBuffer sql2, Select sel, Joins joins, DBDictionary dict, FieldMapping field, ForeignKey fk) {
        String fullTable = dict.getFullName(fk.getTable(), false);
        Column[] cols = fk.getColumns();
        Column[] pks = fk.getPrimaryKeyColumns();
        int count = 0;
        int i = 0;
        while (i < cols.length) {
            if (count > 0) {
                sql2.append(" AND ");
            }
            sql2.append(fullTable).append(".").append(cols[i]).append(" = ").append(sel.getColumnAlias(pks[i], joins));
            ++i;
            ++count;
        }
        cols = fk.getConstantColumns();
        i = 0;
        while (i < cols.length) {
            if (count > 0) {
                sql2.append(" AND ");
            }
            sql2.append(fullTable).append(".").append(cols[i]).append(" = ").appendValue(fk.getConstant(cols[i]), cols[i]);
            ++i;
            ++count;
        }
        pks = fk.getConstantPrimaryKeyColumns();
        i = 0;
        while (i < pks.length) {
            if (count > 0) {
                sql2.append(" AND ");
            }
            sql2.append(sel.getColumnAlias(pks[i], joins)).append(" = ").appendValue(fk.getPrimaryKeyConstant(pks[i]), pks[i]);
            ++i;
            ++count;
        }
    }
}

