/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.util.HashMap;
import java.util.Map;
import org.apache.openjpa.jdbc.meta.strats.ColumnVersionStrategy;
import org.apache.openjpa.jdbc.schema.Column;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberVersionStrategy
extends ColumnVersionStrategy {
    public static final String ALIAS = "version-number";
    private Number _initial = 1;

    public void setInitialValue(int initial) {
        this._initial = initial;
    }

    public int getInitialValue() {
        return this._initial.intValue();
    }

    @Override
    public String getAlias() {
        return ALIAS;
    }

    @Override
    protected int getJavaType() {
        return 5;
    }

    @Override
    protected Object nextVersion(Object version) {
        if (version == null) {
            return this._initial;
        }
        return ((Number)version).intValue() + 1;
    }

    @Override
    public Map<Column, String> getBulkUpdateValues() {
        Column[] cols = this.vers.getColumns();
        HashMap<Column, String> map = new HashMap<Column, String>(cols.length);
        for (int i = 0; i < cols.length; ++i) {
            map.put(cols[i], cols[i].getName() + " + 1");
        }
        return map;
    }
}

