/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.strats.AbstractValueHandler;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.util.InternalException;

public class XMLValueHandler
extends AbstractValueHandler {
    private static final String PROXY_SUFFIX = "$proxy";

    public Column[] map(ValueMapping vm, String name, ColumnIO io, boolean adapt) {
        DBDictionary dict = vm.getMappingRepository().getDBDictionary();
        DBIdentifier colName = DBIdentifier.newColumn(name, dict != null ? dict.delimitAll() : false);
        return this.map(vm, colName, io, adapt);
    }

    public Column[] map(ValueMapping vm, DBIdentifier name, ColumnIO io, boolean adapt) {
        Column col = new Column();
        col.setIdentifier(name);
        col.setJavaType(9);
        col.setSize(-1);
        col.setTypeIdentifier(DBIdentifier.newColumnDefinition(vm.getMappingRepository().getDBDictionary().xmlTypeName));
        col.setXML(true);
        return new Column[]{col};
    }

    public Object toDataStoreValue(ValueMapping vm, Object val, JDBCStore store) {
        if (val == null) {
            return null;
        }
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{val.getClass().getName().endsWith(PROXY_SUFFIX) ? val.getClass().getSuperclass() : val.getClass()});
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.encoding", (Object)store.getDBDictionary().getXMLTypeEncoding());
            StringWriter result = new StringWriter();
            m.marshal(val, (Writer)result);
            return ((Object)result).toString();
        }
        catch (JAXBException je) {
            throw new InternalException(je);
        }
    }

    public Object toObjectValue(ValueMapping vm, Object val) {
        if (val == null) {
            return null;
        }
        try {
            String packageName = vm.getDeclaredType().getPackage().getName();
            JAXBContext jc = JAXBContext.newInstance((String)packageName);
            Unmarshaller u = jc.createUnmarshaller();
            return u.unmarshal((Source)new StreamSource(new StringReader(val.toString())));
        }
        catch (JAXBException je) {
            throw new InternalException(je);
        }
    }
}

