/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.util.HashSet;
import java.util.Set;
import org.apache.openjpa.persistence.criteria.CriteriaExpression;
import org.apache.openjpa.persistence.criteria.CriteriaQueryImpl;
import org.apache.openjpa.persistence.criteria.ParameterExpressionImpl;

public interface CriteriaExpressionVisitor {
    public void enter(CriteriaExpression var1);

    public void exit(CriteriaExpression var1);

    public boolean isVisited(CriteriaExpression var1);

    public TraversalStyle getTraversalStyle(CriteriaExpression var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParameterVisitor
    extends AbstractVisitor {
        private final CriteriaQueryImpl<?> query;

        public ParameterVisitor(CriteriaQueryImpl<?> q) {
            this.query = q;
        }

        @Override
        public void enter(CriteriaExpression expr) {
            if (expr instanceof ParameterExpressionImpl) {
                this.query.registerParameter((ParameterExpressionImpl)expr);
            }
        }
    }

    public static abstract class AbstractVisitor
    implements CriteriaExpressionVisitor {
        protected final Set<CriteriaExpression> _visited = new HashSet<CriteriaExpression>();

        public void exit(CriteriaExpression node) {
            this._visited.add(node);
        }

        public boolean isVisited(CriteriaExpression node) {
            return this._visited.contains(node);
        }

        public TraversalStyle getTraversalStyle(CriteriaExpression node) {
            return TraversalStyle.PREFIX;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TraversalStyle {
        INFIX,
        POSTFIX,
        PREFIX,
        FUNCTION;

    }
}

