/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.io.ByteArrayInputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Set;
import org.apache.openjpa.enhance.PCEnhancer;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.util.GeneralException;
import serp.bytecode.Project;
import serp.bytecode.lowlevel.ConstantPoolTable;

public class PCClassFileTransformer
implements ClassFileTransformer {
    private static final Localizer _loc = Localizer.forPackage(PCClassFileTransformer.class);
    private final MetaDataRepository _repos;
    private final PCEnhancer.Flags _flags;
    private final ClassLoader _tmpLoader;
    private final Log _log;
    private final Set _names;
    private boolean _transforming = false;

    public PCClassFileTransformer(MetaDataRepository repos, Options opts, ClassLoader loader) {
        this(repos, PCClassFileTransformer.toFlags(opts), loader, opts.removeBooleanProperty("scanDevPath", "ScanDevPath", false));
    }

    private static PCEnhancer.Flags toFlags(Options opts) {
        PCEnhancer.Flags flags = new PCEnhancer.Flags();
        flags.addDefaultConstructor = opts.removeBooleanProperty("addDefaultConstructor", "AddDefaultConstructor", flags.addDefaultConstructor);
        flags.enforcePropertyRestrictions = opts.removeBooleanProperty("enforcePropertyRestrictions", "EnforcePropertyRestrictions", flags.enforcePropertyRestrictions);
        return flags;
    }

    public PCClassFileTransformer(MetaDataRepository repos, PCEnhancer.Flags flags, ClassLoader tmpLoader, boolean devscan) {
        this._repos = repos;
        this._tmpLoader = tmpLoader;
        this._log = repos.getConfiguration().getLog("openjpa.Enhance");
        this._flags = flags;
        this._names = repos.getPersistentTypeNames(devscan, tmpLoader);
        if (this._names == null && this._log.isInfoEnabled()) {
            this._log.info(_loc.get("runtime-enhance-pcclasses"));
        }
    }

    public byte[] transform(ClassLoader loader, String className, Class redef, ProtectionDomain domain, byte[] bytes) throws IllegalClassFormatException {
        if (loader == this._tmpLoader) {
            return null;
        }
        if (className == null) {
            return null;
        }
        if (this._transforming) {
            return null;
        }
        this._transforming = true;
        return this.transform0(className, redef, bytes);
    }

    private byte[] transform0(String className, Class redef, byte[] bytes) throws IllegalClassFormatException {
        byte[] returnBytes = null;
        try {
            Boolean enhance = this.needsEnhance(className, redef, bytes);
            if (enhance != null && this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("needs-runtime-enhance", className, enhance));
            }
            if (enhance != Boolean.TRUE) {
                byte[] byArray = null;
                return byArray;
            }
            PCEnhancer enhancer = new PCEnhancer(this._repos.getConfiguration(), new Project().loadClass(new ByteArrayInputStream(bytes), this._tmpLoader), this._repos);
            enhancer.setAddDefaultConstructor(this._flags.addDefaultConstructor);
            enhancer.setEnforcePropertyRestrictions(this._flags.enforcePropertyRestrictions);
            if (enhancer.run() == 0) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = returnBytes = enhancer.getPCBytecode().toByteArray();
            return byArray;
        }
        catch (Throwable t) {
            this._log.warn(_loc.get("cft-exception-thrown", className), t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof IllegalClassFormatException) {
                throw (IllegalClassFormatException)t;
            }
            throw new GeneralException(t);
        }
        finally {
            this._transforming = false;
            if (returnBytes != null && this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("runtime-enhance-complete", className, bytes.length, returnBytes.length));
            }
        }
    }

    private Boolean needsEnhance(String clsName, Class redef, byte[] bytes) {
        if (redef != null) {
            Class<?>[] intfs = redef.getInterfaces();
            for (int i = 0; i < intfs.length; ++i) {
                if (!PersistenceCapable.class.getName().equals(intfs[i].getName())) continue;
                return !PCClassFileTransformer.isEnhanced(bytes);
            }
            return null;
        }
        if (this._names != null) {
            if (this._names.contains(clsName.replace('/', '.'))) {
                return !PCClassFileTransformer.isEnhanced(bytes);
            }
            return null;
        }
        if (clsName.startsWith("java/") || clsName.startsWith("javax/")) {
            return null;
        }
        if (PCClassFileTransformer.isEnhanced(bytes)) {
            return Boolean.FALSE;
        }
        try {
            Class<?> c = Class.forName(clsName.replace('/', '.'), false, this._tmpLoader);
            if (this._repos.getMetaData(c, null, false) != null) {
                return Boolean.TRUE;
            }
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            return Boolean.FALSE;
        }
        catch (LinkageError cce) {
            return Boolean.FALSE;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new GeneralException(t);
        }
    }

    private static boolean isEnhanced(byte[] b) {
        ConstantPoolTable table = new ConstantPoolTable(b);
        int idx = table.getEndIndex();
        int ifaces = table.readUnsignedShort(idx += 6);
        for (int i = 0; i < ifaces; ++i) {
            int clsEntry = table.readUnsignedShort(idx += 2);
            int utfEntry = table.readUnsignedShort(table.get(clsEntry));
            String name = table.readString(table.get(utfEntry));
            if (!"org/apache/openjpa/enhance/PersistenceCapable".equals(name)) continue;
            return true;
        }
        return false;
    }
}

