/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.util.Iterator;
import java.util.List;
import org.apache.openjpa.kernel.DelegatingExtent;
import org.apache.openjpa.persistence.EntityManagerFactoryImpl;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.Extent;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.PersistenceExceptions;

public class ExtentImpl<T>
implements Extent<T> {
    private final EntityManagerImpl _em;
    private final DelegatingExtent _extent;
    private FetchPlan _fetch = null;

    public ExtentImpl(EntityManagerImpl em, org.apache.openjpa.kernel.Extent extent) {
        this._em = em;
        this._extent = new DelegatingExtent(extent, PersistenceExceptions.getRollbackTranslator(em));
    }

    @Override
    public org.apache.openjpa.kernel.Extent getDelegate() {
        return this._extent.getDelegate();
    }

    @Override
    public Class<T> getElementClass() {
        return this._extent.getElementType();
    }

    @Override
    public boolean hasSubclasses() {
        return this._extent.hasSubclasses();
    }

    @Override
    public OpenJPAEntityManager getEntityManager() {
        return this._em;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchPlan getFetchPlan() {
        this._em.assertNotCloseInvoked();
        this._extent.lock();
        try {
            if (this._fetch == null) {
                this._fetch = ((EntityManagerFactoryImpl)this._em.getEntityManagerFactory()).toFetchPlan(this._extent.getBroker(), this._extent.getFetchConfiguration());
            }
            FetchPlan fetchPlan = this._fetch;
            return fetchPlan;
        }
        finally {
            this._extent.unlock();
        }
    }

    @Override
    public boolean getIgnoreChanges() {
        return this._extent.getIgnoreChanges();
    }

    @Override
    public void setIgnoreChanges(boolean ignoreChanges) {
        this._em.assertNotCloseInvoked();
        this._extent.setIgnoreChanges(ignoreChanges);
    }

    @Override
    public List<T> list() {
        this._em.assertNotCloseInvoked();
        return this._extent.list();
    }

    @Override
    public Iterator<T> iterator() {
        this._em.assertNotCloseInvoked();
        return this._extent.iterator();
    }

    @Override
    public void closeAll() {
        this._extent.closeAll();
    }

    public int hashCode() {
        return this._extent == null ? 0 : this._extent.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        if (this._extent == null) {
            return false;
        }
        return this._extent.equals(((ExtentImpl)other)._extent);
    }
}

