/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Path;
import javax.validation.ValidationException;
import org.apache.bval.jsr303.ConstraintValidation;
import org.apache.bval.jsr303.GroupValidationContext;
import org.apache.bval.jsr303.util.NodeBuilderDefinedContextImpl;
import org.apache.bval.jsr303.util.NodeImpl;
import org.apache.bval.jsr303.util.PathImpl;
import org.apache.bval.model.ValidationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintValidatorContextImpl
implements ConstraintValidatorContext {
    private final List<ValidationListener.Error> errorMessages = new LinkedList<ValidationListener.Error>();
    private final ConstraintValidation<?> constraintDescriptor;
    private final GroupValidationContext<?> validationContext;
    private boolean defaultDisabled;

    public ConstraintValidatorContextImpl(GroupValidationContext<?> validationContext, ConstraintValidation<?> aConstraintValidation) {
        this.validationContext = validationContext;
        this.constraintDescriptor = aConstraintValidation;
    }

    @Override
    public void disableDefaultConstraintViolation() {
        this.defaultDisabled = true;
    }

    @Override
    public String getDefaultConstraintMessageTemplate() {
        return this.constraintDescriptor.getMessageTemplate();
    }

    @Override
    public ConstraintValidatorContext.ConstraintViolationBuilder buildConstraintViolationWithTemplate(String messageTemplate) {
        return new ConstraintViolationBuilderImpl(this, messageTemplate, this.validationContext.getPropertyPath());
    }

    public List<ValidationListener.Error> getErrorMessages() {
        if (this.defaultDisabled && this.errorMessages.isEmpty()) {
            throw new ValidationException("At least one custom message must be created if the default error message gets disabled.");
        }
        ArrayList<ValidationListener.Error> returnedErrorMessages = new ArrayList<ValidationListener.Error>(this.errorMessages);
        if (!this.defaultDisabled) {
            returnedErrorMessages.add(new ValidationListener.Error(this.getDefaultConstraintMessageTemplate(), this.validationContext.getPropertyPath(), null));
        }
        return returnedErrorMessages;
    }

    public GroupValidationContext<?> getValidationContext() {
        return this.validationContext;
    }

    public void addError(String messageTemplate, Path propertyPath) {
        this.errorMessages.add(new ValidationListener.Error(messageTemplate, propertyPath, null));
    }

    private static final class ConstraintViolationBuilderImpl
    implements ConstraintValidatorContext.ConstraintViolationBuilder {
        private final ConstraintValidatorContextImpl parent;
        private final String messageTemplate;
        private final PathImpl propertyPath;

        ConstraintViolationBuilderImpl(ConstraintValidatorContextImpl contextImpl, String template, PathImpl path) {
            this.parent = contextImpl;
            this.messageTemplate = template;
            this.propertyPath = path;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext addNode(String name) {
            PathImpl path;
            if (this.propertyPath.isRootPath()) {
                path = PathImpl.create(name);
            } else {
                path = PathImpl.copy(this.propertyPath);
                path.addNode(new NodeImpl(name));
            }
            return new NodeBuilderDefinedContextImpl(this.parent, this.messageTemplate, path);
        }

        public ConstraintValidatorContext addConstraintViolation() {
            this.parent.addError(this.messageTemplate, this.propertyPath);
            return this.parent;
        }
    }
}

