/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.validation.ConstraintDeclarationException;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.GroupConversionDescriptor;
import org.apache.bval.jsr.ConstraintFinderImpl;
import org.apache.bval.jsr.ConstraintValidation;
import org.apache.bval.jsr.groups.Group;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.Validation;

public abstract class ElementDescriptorImpl
implements ElementDescriptor {
    private final Set<GroupConversionDescriptor> groupConversions = new CopyOnWriteArraySet<GroupConversionDescriptor>();
    private boolean cascaded;
    private final Collection<Object> validated = new CopyOnWriteArraySet<Object>();
    protected final MetaBean metaBean;
    protected final Class<?> elementClass;
    private Set<ConstraintDescriptor<?>> constraintDescriptors;
    private final Map<Group, Group> groupMapping = new HashMap<Group, Group>();

    protected static Set<ConstraintDescriptor<?>> getConstraintDescriptors(Validation[] validations) {
        HashSet result = new HashSet(validations.length);
        for (Validation validation : validations) {
            if (!(validation instanceof ConstraintValidation)) continue;
            result.add((ConstraintValidation)validation);
        }
        return result;
    }

    protected ElementDescriptorImpl(MetaBean metaBean, Class<?> elementClass, Validation[] validations) {
        this.metaBean = metaBean;
        this.elementClass = elementClass;
        this.setConstraintDescriptors(ElementDescriptorImpl.getConstraintDescriptors(validations));
    }

    protected ElementDescriptorImpl(Class<?> elementClass, Validation[] validations) {
        this(null, elementClass, validations);
    }

    @Override
    public Class<?> getElementClass() {
        return this.elementClass;
    }

    @Override
    public ElementDescriptor.ConstraintFinder findConstraints() {
        return new ConstraintFinderImpl(this.metaBean, new HashSet(this.constraintDescriptors));
    }

    @Override
    public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
        return this.constraintDescriptors.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(this.constraintDescriptors);
    }

    public Set<ConstraintDescriptor<?>> getMutableConstraintDescriptors() {
        return this.constraintDescriptors;
    }

    @Override
    public boolean hasConstraints() {
        return !this.getConstraintDescriptors().isEmpty();
    }

    public void setConstraintDescriptors(Set<ConstraintDescriptor<?>> constraintDescriptors) {
        this.constraintDescriptors = constraintDescriptors;
    }

    public MetaBean getMetaBean() {
        return this.metaBean;
    }

    public void addGroupMapping(Group from, Group to) {
        this.groupMapping.put(from, to);
    }

    public Group mapGroup(Group current) {
        Group mapping = this.groupMapping.get(current);
        if (mapping != null) {
            return mapping;
        }
        return current;
    }

    public Set<GroupConversionDescriptor> getGroupConversions() {
        return this.groupConversions;
    }

    public void addGroupConversion(GroupConversionDescriptor descriptor) {
        this.groupConversions.add(descriptor);
        Group from = new Group(descriptor.getFrom());
        if (this.mapGroup(from) != from) {
            throw new ConstraintDeclarationException("You can't map twice from the same group");
        }
        this.addGroupMapping(from, new Group(descriptor.getTo()));
    }

    public boolean isCascaded() {
        return this.cascaded;
    }

    public void setCascaded(boolean cascaded) {
        this.cascaded = cascaded;
    }

    public boolean isValidated(Object object) {
        return this.validated.contains(object);
    }

    public void setValidated(Object object) {
        this.validated.add(object);
    }
}

