/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.openjpa.datacache.CacheDistributionPolicy;
import org.apache.openjpa.datacache.DefaultCacheDistributionPolicy;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.meta.ClassMetaData;

public class TypeBasedCacheDistributionPolicy
extends DefaultCacheDistributionPolicy
implements CacheDistributionPolicy {
    private Set<String> _excludedTypes;
    private Set<String> _includedTypes;

    public Set<String> getExcludedTypes() {
        return this._excludedTypes;
    }

    public void setExcludedTypes(String types) {
        this._excludedTypes = this.parseNames(types);
    }

    public Set<String> getIncludedTypes() {
        return this._includedTypes;
    }

    public void setIncludedTypes(String types) {
        this._includedTypes = this.parseNames(types);
    }

    private Set<String> parseNames(String types) {
        if (StringUtil.isEmpty(types)) {
            return Collections.emptySet();
        }
        String[] names = StringUtil.split(types, ";", 0);
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(names));
        return Collections.unmodifiableSet(set);
    }

    @Override
    public String selectCache(OpenJPAStateManager sm, Object context) {
        ClassMetaData meta = sm.getMetaData();
        String className = meta.getDescribedType().getName();
        if (this._excludedTypes != null && this._excludedTypes.contains(className)) {
            return null;
        }
        if (this._includedTypes != null && !this._includedTypes.isEmpty()) {
            if (this._includedTypes.contains(className)) {
                return meta.getDataCacheName();
            }
            return meta.getDataCacheEnabled() ? meta.getDataCacheName() : null;
        }
        return super.selectCache(sm, context);
    }
}

